/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.api.ui.support;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.netbeans.modules.gradle.javaee.api.ui.support.Bundle;

public final class ComboBoxUpdater<T>
implements ItemListener {
    private final Store store;
    private final Verify verifier;
    private final JComboBox<T> comboBox;
    private final JLabel comboBoxLabel;
    private final T defaultValue;

    public static <T> ComboBoxUpdater create(JComboBox<T> comboBox, JLabel comboBoxLabel, T defaultValue, Store store) {
        ComboBoxUpdater<T> instance = new ComboBoxUpdater<T>(comboBox, comboBoxLabel, defaultValue, store, null);
        instance.comboBox.addItemListener(instance);
        return instance;
    }

    public static <T> ComboBoxUpdater create(JComboBox<T> comboBox, JLabel comboBoxLabel, T defaultValue, Store store, Verify verifier) {
        ComboBoxUpdater<T> instance = new ComboBoxUpdater<T>(comboBox, comboBoxLabel, defaultValue, store, verifier);
        instance.comboBox.addItemListener(instance);
        return instance;
    }

    private ComboBoxUpdater(JComboBox<T> comboBox, JLabel comboBoxLabel, T defaultValue, Store store, Verify verifier) {
        assert (comboBox != null);
        assert (comboBoxLabel != null);
        assert (store != null);
        this.comboBox = comboBox;
        this.comboBox.setSelectedItem(defaultValue);
        this.comboBoxLabel = comboBoxLabel;
        this.defaultValue = defaultValue;
        this.store = store;
        this.verifier = verifier;
        this.setValue(defaultValue);
    }

    public void storeValue() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if (!selectedItem.equals(this.defaultValue)) {
            this.store.storeValue(selectedItem);
        }
    }

    private void setValue(Object value) {
        if (this.defaultValue != null && this.defaultValue.equals(value)) {
            this.comboBoxLabel.setFont(this.comboBoxLabel.getFont().deriveFont(0));
            this.comboBox.setToolTipText(null);
        } else {
            this.comboBoxLabel.setFont(this.comboBoxLabel.getFont().deriveFont(1));
            this.comboBox.setToolTipText(Bundle.MSG_ComboBox_Value_Changed());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Object newValue = this.comboBox.getSelectedItem();
            if (this.verifier != null) {
                if (this.verifier.verifyValue(newValue)) {
                    this.setValue(newValue);
                }
            } else {
                this.setValue(newValue);
            }
        }
    }

    public static interface Store {
        public void storeValue(Object var1);
    }

    public static interface Verify {
        public boolean verifyValue(Object var1);
    }
}

