/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NamespaceMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="defaultS3CompartmentId")
    private final String defaultS3CompartmentId;
    @JsonProperty(value="defaultSwiftCompartmentId")
    private final String defaultSwiftCompartmentId;

    @Deprecated
    @ConstructorProperties(value={"namespace", "defaultS3CompartmentId", "defaultSwiftCompartmentId"})
    public NamespaceMetadata(String namespace, String defaultS3CompartmentId, String defaultSwiftCompartmentId) {
        this.namespace = namespace;
        this.defaultS3CompartmentId = defaultS3CompartmentId;
        this.defaultSwiftCompartmentId = defaultSwiftCompartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDefaultS3CompartmentId() {
        return this.defaultS3CompartmentId;
    }

    public String getDefaultSwiftCompartmentId() {
        return this.defaultSwiftCompartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NamespaceMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("namespace=").append(String.valueOf(this.namespace));
        sb.append(", defaultS3CompartmentId=").append(String.valueOf(this.defaultS3CompartmentId));
        sb.append(", defaultSwiftCompartmentId=").append(String.valueOf(this.defaultSwiftCompartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespaceMetadata)) {
            return false;
        }
        NamespaceMetadata other = (NamespaceMetadata)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.defaultS3CompartmentId, other.defaultS3CompartmentId) && Objects.equals(this.defaultSwiftCompartmentId, other.defaultSwiftCompartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.defaultS3CompartmentId == null ? 43 : this.defaultS3CompartmentId.hashCode());
        result = result * 59 + (this.defaultSwiftCompartmentId == null ? 43 : this.defaultSwiftCompartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="defaultS3CompartmentId")
        private String defaultS3CompartmentId;
        @JsonProperty(value="defaultSwiftCompartmentId")
        private String defaultSwiftCompartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder defaultS3CompartmentId(String defaultS3CompartmentId) {
            this.defaultS3CompartmentId = defaultS3CompartmentId;
            this.__explicitlySet__.add("defaultS3CompartmentId");
            return this;
        }

        public Builder defaultSwiftCompartmentId(String defaultSwiftCompartmentId) {
            this.defaultSwiftCompartmentId = defaultSwiftCompartmentId;
            this.__explicitlySet__.add("defaultSwiftCompartmentId");
            return this;
        }

        public NamespaceMetadata build() {
            NamespaceMetadata model = new NamespaceMetadata(this.namespace, this.defaultS3CompartmentId, this.defaultSwiftCompartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NamespaceMetadata model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("defaultS3CompartmentId")) {
                this.defaultS3CompartmentId(model.getDefaultS3CompartmentId());
            }
            if (model.wasPropertyExplicitlySet("defaultSwiftCompartmentId")) {
                this.defaultSwiftCompartmentId(model.getDefaultSwiftCompartmentId());
            }
            return this;
        }
    }
}

