/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Duration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeAmount")
    private final Long timeAmount;
    @JsonProperty(value="timeUnit")
    private final TimeUnit timeUnit;

    @Deprecated
    @ConstructorProperties(value={"timeAmount", "timeUnit"})
    public Duration(Long timeAmount, TimeUnit timeUnit) {
        this.timeAmount = timeAmount;
        this.timeUnit = timeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getTimeAmount() {
        return this.timeAmount;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Duration(");
        sb.append("super=").append(super.toString());
        sb.append("timeAmount=").append(String.valueOf(this.timeAmount));
        sb.append(", timeUnit=").append(String.valueOf((Object)this.timeUnit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)((Object)o);
        return Objects.equals(this.timeAmount, other.timeAmount) && Objects.equals((Object)this.timeUnit, (Object)other.timeUnit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeAmount == null ? 43 : this.timeAmount.hashCode());
        result = result * 59 + (this.timeUnit == null ? 43 : this.timeUnit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TimeUnit implements BmcEnum
    {
        Years("YEARS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TimeUnit> map;

        private TimeUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TimeUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TimeUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TimeUnit.class);
            map = new HashMap<String, TimeUnit>();
            for (TimeUnit v : TimeUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeAmount")
        private Long timeAmount;
        @JsonProperty(value="timeUnit")
        private TimeUnit timeUnit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeAmount(Long timeAmount) {
            this.timeAmount = timeAmount;
            this.__explicitlySet__.add("timeAmount");
            return this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            this.__explicitlySet__.add("timeUnit");
            return this;
        }

        public Duration build() {
            Duration model = new Duration(this.timeAmount, this.timeUnit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Duration model) {
            if (model.wasPropertyExplicitlySet("timeAmount")) {
                this.timeAmount(model.getTimeAmount());
            }
            if (model.wasPropertyExplicitlySet("timeUnit")) {
                this.timeUnit(model.getTimeUnit());
            }
            return this;
        }
    }
}

