/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.xml.parsers.DocumentInputSource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.xml.api.model.ExtendedGrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarQueryManager;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.completion.EmptyQuery;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class GrammarManager
extends FileChangeAdapter
implements DocumentListener {
    private static final String FILE_PROTOCOL_URI_PREFIX = "file:/";
    private List<FileObject> externalDTDs = new ArrayList<FileObject>();
    private int state = 3;
    static final int VALID = 1;
    static final int INVALID = 3;
    private GrammarQuery grammar;
    private final XMLSyntaxSupport syntax;
    private final Document doc;
    private Position[] guarded;
    private Position maxGuarded;
    private int environmentElementsCount = -1;

    public GrammarManager(Document doc, XMLSyntaxSupport syntax) {
        this.doc = doc;
        this.syntax = syntax;
    }

    public synchronized GrammarQuery getGrammar() {
        switch (this.state) {
            case 1: {
                return this.grammar;
            }
            case 3: {
                this.loadGrammar();
                return this.grammar;
            }
        }
        throw new IllegalStateException();
    }

    public synchronized void invalidateGrammar() {
        if (this.state == 1) {
            String msg = NbBundle.getMessage(GrammarManager.class, (String)"MSG_loading_cancel");
            StatusDisplayer.getDefault().setStatusText(msg);
        }
        this.doc.removeDocumentListener(this);
        for (FileObject fo : this.externalDTDs) {
            fo.removeFileChangeListener((FileChangeListener)this);
        }
        this.externalDTDs.clear();
        this.guarded = new Position[0];
        this.state = 3;
    }

    public void fileChanged(FileEvent fe) {
        this.invalidateGrammar();
    }

    public void fileDeleted(FileEvent fe) {
        this.invalidateGrammar();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDocumentEnvironment(e);
        if (this.isGuarded(e.getOffset(), e.getLength())) {
            this.invalidateGrammar();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDocumentEnvironment(e);
        if (this.isGuarded(e.getOffset(), e.getLength())) {
            this.invalidateGrammar();
        }
    }

    private void checkDocumentEnvironment(DocumentEvent e) {
        long current = System.currentTimeMillis();
        try {
            LinkedList ll = this.getEnvironmentElements();
            if (ll.size() != this.environmentElementsCount) {
                this.invalidateGrammar();
                this.environmentElementsCount = ll.size();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private boolean isGuarded(int offset, int length) {
        if (this.maxGuarded != null && offset > this.maxGuarded.getOffset()) {
            return false;
        }
        if (this.guarded == null) {
            return false;
        }
        for (int i = 0; i < this.guarded.length; i += 2) {
            int start = this.guarded[i].getOffset();
            int end = this.guarded[i + 1].getOffset();
            if (start < offset && offset < end) {
                return true;
            }
            int changeEnd = offset + length;
            if (offset >= start || start >= changeEnd) continue;
            return true;
        }
        return false;
    }

    private synchronized void grammarLoaded(GrammarQuery grammar) {
        String status = grammar != null ? NbBundle.getMessage(GrammarManager.class, (String)"MSG_loading_done") : null;
        this.grammar = grammar == null ? EmptyQuery.INSTANCE : grammar;
        this.state = 1;
        StatusDisplayer.getDefault().setStatusText(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGrammar() {
        GrammarQuery loaded = null;
        try {
            Enumeration en;
            GrammarQueryManager g;
            GrammarEnvironment env;
            block14: {
                String status = NbBundle.getMessage(GrammarManager.class, (String)"MSG_loading");
                StatusDisplayer.getDefault().setStatusText(status);
                LinkedList ctx = this.getEnvironmentElements();
                DocumentInputSource inputSource = new DocumentInputSource(this.doc);
                FileObject fileObject = null;
                Object obj = this.doc.getProperty("stream");
                if (obj instanceof DataObject) {
                    DataObject dobj = (DataObject)obj;
                    fileObject = dobj.getPrimaryFile();
                }
                env = new GrammarEnvironment(Collections.enumeration(ctx), (InputSource)inputSource, fileObject);
                g = GrammarQueryManager.getDefault();
                en = g.enabled(env);
                if (en != null) break block14;
                return;
            }
            try {
                ArrayList<Position> positions = new ArrayList<Position>(10);
                int max = 0;
                while (en.hasMoreElements()) {
                    Node next = (Node)en.nextElement();
                    if (!(next instanceof SyntaxElement)) continue;
                    SyntaxElement node = (SyntaxElement)((Object)next);
                    int start = node.getElementOffset();
                    int end = start + node.getElementLength();
                    if (end > max) {
                        max = end;
                    }
                    Position startPosition = NbDocument.createPosition((Document)this.doc, (int)start, (Position.Bias)Position.Bias.Forward);
                    positions.add(startPosition);
                    Position endPosition = NbDocument.createPosition((Document)this.doc, (int)end, (Position.Bias)Position.Bias.Backward);
                    positions.add(endPosition);
                }
                this.guarded = positions.toArray(new Position[0]);
                this.maxGuarded = NbDocument.createPosition((Document)this.doc, (int)max, (Position.Bias)Position.Bias.Backward);
                loaded = g.getGrammar(env);
                if (loaded instanceof ExtendedGrammarQuery) {
                    for (String resolvedEntity : ((ExtendedGrammarQuery)loaded).getResolvedEntities()) {
                        FileObject docFo;
                        DataObject docDo;
                        if (!resolvedEntity.startsWith(FILE_PROTOCOL_URI_PREFIX) || (docDo = NbEditorUtilities.getDataObject((Document)this.doc)) == null || (docFo = docDo.getPrimaryFile()) == null) continue;
                        try {
                            FileSystem fs = docFo.getFileSystem();
                            FileObject fo = fs.findResource(resolvedEntity.substring(FILE_PROTOCOL_URI_PREFIX.length()));
                            if (fo == null) continue;
                            this.externalDTDs.add(fo);
                            fo.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.doc));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (BadLocationException ex) {
                loaded = null;
            }
        }
        finally {
            this.doc.addDocumentListener(this);
            this.grammarLoaded(loaded);
        }
    }

    private LinkedList getEnvironmentElements() throws BadLocationException {
        LinkedList ctx = new LinkedList();
        for (SyntaxElement first = this.syntax.getElementChain(1); first != null; first = first.getNext()) {
            Object node = first.getNode();
            if (node == null) continue;
            ctx.add(node);
            if (1 == node.getNodeType()) break;
        }
        return ctx;
    }
}

