/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.versioning;

import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.versioning.VersionNumber;

public class VersionNumberBuilder {
    private VersionNumber versionNumber;

    protected VersionNumberBuilder(Integer featureNumber) {
        if (null == featureNumber) {
            throw new IllegalArgumentException("featureNumber cannot be null");
        }
        if (featureNumber <= 0) {
            throw new IllegalArgumentException("featureNumber cannot <= 0");
        }
        this.versionNumber = new VersionNumber(featureNumber);
    }

    public static VersionNumberBuilder create(Integer featureNumber) throws IllegalArgumentException {
        if (null == featureNumber) {
            throw new IllegalArgumentException("Feature version cannot be null");
        }
        if (0 >= featureNumber) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0 (" + featureNumber + ")");
        }
        return new VersionNumberBuilder(featureNumber);
    }

    public VersionNumberBuilder interimNumber(Integer interimNumber) throws IllegalArgumentException {
        if (null != interimNumber && 0 > interimNumber) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        this.versionNumber.setInterim(interimNumber);
        return this;
    }

    public VersionNumberBuilder updateNumber(Integer updateNumber) throws IllegalArgumentException {
        if (null != updateNumber && 0 > updateNumber) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        this.versionNumber.setUpdate(updateNumber);
        return this;
    }

    public VersionNumberBuilder patchNumber(Integer patchNumber) throws IllegalArgumentException {
        if (null != patchNumber && 0 > patchNumber) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        this.versionNumber.setPatch(patchNumber);
        return this;
    }

    public VersionNumberBuilder fifthNumber(Integer fifthNumber) throws IllegalArgumentException {
        if (null != fifthNumber && 0 > fifthNumber) {
            throw new IllegalArgumentException("Fifth version cannot be smaller than 0");
        }
        this.versionNumber.setFifth(fifthNumber);
        return this;
    }

    public VersionNumberBuilder sixthNumber(Integer sixthNumber) throws IllegalArgumentException {
        if (null != sixthNumber && 0 > sixthNumber) {
            throw new IllegalArgumentException("Sixth version cannot be smaller than 0");
        }
        this.versionNumber.setSixth(sixthNumber);
        return this;
    }

    public VersionNumberBuilder buildNumber(Integer buildNumber) throws IllegalArgumentException {
        if (null != buildNumber && 0 > buildNumber) {
            throw new IllegalArgumentException("Build version cannot be smaller than 0");
        }
        this.versionNumber.setBuild(buildNumber);
        return this;
    }

    public VersionNumberBuilder releaseStatus(ReleaseStatus releaseStatus) {
        if (null == releaseStatus) {
            throw new IllegalArgumentException("Release status cannot be null");
        }
        this.versionNumber.setReleaseStatus(releaseStatus);
        return this;
    }

    public VersionNumber build() {
        return this.versionNumber;
    }
}

