/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.openide.NotifyDescriptor;
import org.openide.util.Parameters;

public class ReferenceNameStep
extends AbstractStep<String> {
    private String referenceName;
    private String contextPath;
    private OCIItem context;

    public ReferenceNameStep(OCIItem context) {
        this.context = context;
    }

    public ReferenceNameStep(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public NotifyDescriptor createInput() {
        String oldRefName;
        NotifyDescriptor.InputLine ci = new NotifyDescriptor.InputLine(Bundle.ReferenceName(), Bundle.ReferenceName());
        if (this.context != null && (oldRefName = CloudAssets.getDefault().getReferenceName(this.context)) != null) {
            ci.setInputText(oldRefName);
        }
        return ci;
    }

    @Override
    public boolean onlyOneChoice() {
        return false;
    }

    @Override
    public void setValue(String value) {
        if (this.validateName(value)) {
            this.referenceName = value;
        }
    }

    @Override
    public String getValue() {
        return this.referenceName;
    }

    private boolean validateName(String value) {
        Parameters.notNull((CharSequence)"Reference name", (Object)value);
        if (!value.matches("[a-zA-Z0-9]+")) {
            NotificationUtils.showMessage(Bundle.ReferenceNameValidationError());
            return false;
        }
        if (this.referenceNameExist(value)) {
            NotificationUtils.showMessage(Bundle.ReferenceNameExist());
        }
        return true;
    }

    private boolean referenceNameExist(String value) {
        String itemContextPath = this.context == null ? this.contextPath : this.context.getKey().getPath();
        return CloudAssets.getDefault().referenceNameExist(itemContextPath, value);
    }
}

