/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.StructHandler;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;

public class PropertiesStructure
extends Element {
    private Map<String, Element.ItemElem> items;
    private StructHandler handler;
    static final long serialVersionUID = -78380271920882131L;

    public PropertiesStructure(PositionBounds bounds, Map<String, Element.ItemElem> items) {
        super(bounds);
        for (Element.ItemElem itemElem : items.values()) {
            itemElem.setParent(this);
        }
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PropertiesStructure struct) {
        BundleStructure bundleStructure = this.getParentBundleStructure();
        synchronized (bundleStructure) {
            StructHandler structHandler = this.getParent();
            synchronized (structHandler) {
                boolean structChanged = false;
                Map<String, Element.ItemElem> new_items = struct.items;
                HashMap<String, Element.ItemElem> changed = new HashMap<String, Element.ItemElem>();
                HashMap<String, Element.ItemElem> inserted = new HashMap<String, Element.ItemElem>();
                Map<Object, Object> deleted = new HashMap();
                for (Element.ItemElem curItem : new_items.values()) {
                    curItem.setParent(this);
                    Element.ItemElem oldItem = this.getItem(curItem.getKey());
                    if (oldItem == null) {
                        inserted.put(curItem.getKey(), curItem);
                        continue;
                    }
                    if (!curItem.equals(oldItem)) {
                        changed.put(curItem.getKey(), curItem);
                    }
                    this.items.remove(oldItem.getKey());
                }
                deleted = this.items;
                if (deleted.size() > 0 || inserted.size() > 0) {
                    structChanged = true;
                }
                this.items = new_items;
                this.bounds = struct.getBounds();
                if (structChanged) {
                    this.structureChanged(changed, inserted, deleted);
                } else {
                    for (Element.ItemElem itemElem : changed.values()) {
                        this.itemChanged(itemElem);
                    }
                }
            }
        }
    }

    void setParent(StructHandler parent) {
        this.handler = parent;
    }

    public StructHandler getParent() {
        if (this.handler == null) {
            throw new IllegalStateException();
        }
        return this.handler;
    }

    BundleStructure getParentBundleStructure() {
        PropertiesDataObject dataObj = (PropertiesDataObject)this.getParent().getEntry().getDataObject();
        return dataObj.getBundleStructure();
    }

    @Override
    public String getDocumentString() {
        StringBuilder sb = new StringBuilder();
        for (Element.ItemElem item : this.items.values()) {
            sb.append(item.getDocumentString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Element.ItemElem item : this.items.values()) {
            sb.append(item.toString());
            sb.append("- - -\n");
        }
        return sb.toString();
    }

    public Element.ItemElem getItem(String key) {
        return this.items.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameItem(String oldKey, String newKey) {
        BundleStructure bundleStructure = this.getParentBundleStructure();
        synchronized (bundleStructure) {
            StructHandler structHandler = this.getParent();
            synchronized (structHandler) {
                Element.ItemElem item = this.getItem(newKey);
                if (item == null) {
                    item = this.getItem(oldKey);
                    if (item == null) {
                        return false;
                    }
                    this.items.remove(oldKey);
                    this.items.put(newKey, item);
                    item.setKey(newKey);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteItem(String key) {
        BundleStructure bundleStructure = this.getParentBundleStructure();
        synchronized (bundleStructure) {
            StructHandler structHandler = this.getParent();
            synchronized (structHandler) {
                Element.ItemElem item = this.getItem(key);
                if (item == null) {
                    return false;
                }
                try {
                    item.getBounds().setText("");
                    this.items.remove(key);
                    this.structureChanged();
                    return true;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return false;
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItem(String key, String value, String comment) {
        Element.ItemElem item = this.getItem(key);
        if (item != null) {
            return false;
        }
        item = new Element.ItemElem(null, new Element.KeyElem(null, key), new Element.ValueElem(null, value), new Element.CommentElem(null, comment));
        try {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                StructHandler structHandler = this.getParent();
                synchronized (structHandler) {
                    PositionBounds pos = this.getBounds();
                    PositionBounds itemBounds = pos.getText().endsWith("\n") ? pos.insertAfter(item.getDocumentString()) : pos.insertAfter("\n").insertAfter(item.getDocumentString());
                    item.bounds = itemBounds;
                    item.setParent(this);
                    this.items.put(key, item);
                    this.structureChanged();
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (BadLocationException ble) {
            return false;
        }
    }

    boolean addItem(Element.ItemElem item) {
        return this.addItem(item.getKey(), item.getValue(), item.getComment());
    }

    public Iterator<Element.ItemElem> allItems() {
        return this.items.values().iterator();
    }

    void itemChanged(Element.ItemElem elem) {
        this.getParentBundleStructure().notifyItemChanged(this, elem);
    }

    void structureChanged() {
        this.getParentBundleStructure().notifyOneFileChanged(this.getParent());
    }

    void structureChanged(Map<String, Element.ItemElem> changed, Map<String, Element.ItemElem> inserted, Map<String, Element.ItemElem> deleted) {
        this.getParentBundleStructure().notifyOneFileChanged(this.getParent(), changed, inserted, deleted);
    }

    void itemKeyChanged(String oldKey, Element.ItemElem newElem) {
        HashMap<String, Element.ItemElem> changed = new HashMap<String, Element.ItemElem>();
        HashMap<String, Element.ItemElem> inserted = new HashMap<String, Element.ItemElem>();
        HashMap<String, Element.ItemElem> deleted = new HashMap<String, Element.ItemElem>();
        Element.ItemElem item = this.getItem(oldKey);
        if (item == null) {
            Element.ItemElem emptyItem = new Element.ItemElem(null, new Element.KeyElem(null, oldKey), new Element.ValueElem(null, ""), new Element.CommentElem(null, ""));
            deleted.put(oldKey, emptyItem);
        } else {
            changed.put(item.getKey(), item);
        }
        inserted.put(newElem.getKey(), newElem);
        this.structureChanged(changed, inserted, deleted);
    }
}

