/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class Matcher {
    private final Item[] items;
    private final boolean unmatchedValue;

    private static Pattern toPattern(String value) {
        int l = value.length();
        boolean endsDotStar = value.endsWith(".*");
        if (endsDotStar) {
            l -= 2;
        }
        boolean hasWildcards = endsDotStar;
        StringBuilder sb = new StringBuilder(2 * l);
        block7: for (int i = 0; i < l; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block7;
                }
                case '*': {
                    sb.append(".*");
                    hasWildcards = true;
                    continue block7;
                }
                case '?': {
                    sb.append(".?");
                    hasWildcards = true;
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (hasWildcards) {
            if (endsDotStar) {
                sb.append("(?:\\..*)?");
            }
            try {
                return Pattern.compile(sb.toString());
            }
            catch (PatternSyntaxException px) {
                Logger.getLogger(Matcher.class.getName()).log(Level.WARNING, null, px);
                return null;
            }
        }
        return null;
    }

    Matcher(String pattern) {
        ArrayList<Item> list = new ArrayList<Item>();
        boolean unmatched = false;
        if (pattern != null && !pattern.contains("${")) {
            String[] strItems;
            for (String strItem : strItems = pattern.split(",")) {
                int semic = strItem.indexOf(59);
                String value = (semic < 0 ? strItem : strItem.substring(0, semic)).trim();
                if (value.isEmpty()) continue;
                boolean returnOnMatch = true;
                if (value.startsWith("!")) {
                    returnOnMatch = false;
                    value = value.substring(1);
                }
                if ("*".equals(value)) {
                    unmatched = returnOnMatch;
                    break;
                }
                list.add(new Item(returnOnMatch, value, Matcher.toPattern(value)));
            }
        }
        this.items = list.toArray(new Item[0]);
        this.unmatchedValue = unmatched;
    }

    boolean matches(String packageName) {
        for (Item item : this.items) {
            if (!item.matches(packageName)) continue;
            return item.returnOnMatch;
        }
        return this.unmatchedValue;
    }

    private static class Item {
        final boolean returnOnMatch;
        final String exact;
        final Pattern pattern;

        public Item(boolean returnOnMatch, String exact, Pattern pattern) {
            this.returnOnMatch = returnOnMatch;
            this.exact = exact;
            this.pattern = pattern;
        }

        boolean matches(String packageName) {
            return this.pattern != null ? this.pattern.matcher(packageName).matches() : this.exact.equals(packageName);
        }
    }
}

