/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.monitoring.model.PostMetricDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PostMetricDataRequest
extends BmcRequest<PostMetricDataDetails> {
    private PostMetricDataDetails postMetricDataDetails;
    private String opcRequestId;
    private String contentEncoding;

    public PostMetricDataDetails getPostMetricDataDetails() {
        return this.postMetricDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @InternalSdk
    public PostMetricDataDetails getBody$() {
        return this.postMetricDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().postMetricDataDetails(this.postMetricDataDetails).opcRequestId(this.opcRequestId).contentEncoding(this.contentEncoding);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",postMetricDataDetails=").append(String.valueOf((Object)this.postMetricDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",contentEncoding=").append(String.valueOf(this.contentEncoding));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostMetricDataRequest)) {
            return false;
        }
        PostMetricDataRequest other = (PostMetricDataRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.postMetricDataDetails, (Object)other.postMetricDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.contentEncoding, other.contentEncoding);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.postMetricDataDetails == null ? 43 : this.postMetricDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.contentEncoding == null ? 43 : this.contentEncoding.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PostMetricDataRequest, PostMetricDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private PostMetricDataDetails postMetricDataDetails = null;
        private String opcRequestId = null;
        private String contentEncoding = null;

        public Builder postMetricDataDetails(PostMetricDataDetails postMetricDataDetails) {
            this.postMetricDataDetails = postMetricDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PostMetricDataRequest o) {
            this.postMetricDataDetails(o.getPostMetricDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.contentEncoding(o.getContentEncoding());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PostMetricDataRequest build() {
            PostMetricDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PostMetricDataDetails body) {
            this.postMetricDataDetails(body);
            return this;
        }

        public PostMetricDataRequest buildWithoutInvocationCallback() {
            PostMetricDataRequest request = new PostMetricDataRequest();
            request.postMetricDataDetails = this.postMetricDataDetails;
            request.opcRequestId = this.opcRequestId;
            request.contentEncoding = this.contentEncoding;
            return request;
        }
    }
}

