/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.monitoring.model.MetricDataDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PostMetricDataDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricData")
    private final List<MetricDataDetails> metricData;
    @JsonProperty(value="batchAtomicity")
    private final BatchAtomicity batchAtomicity;

    @Deprecated
    @ConstructorProperties(value={"metricData", "batchAtomicity"})
    public PostMetricDataDetails(List<MetricDataDetails> metricData, BatchAtomicity batchAtomicity) {
        this.metricData = metricData;
        this.batchAtomicity = batchAtomicity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<MetricDataDetails> getMetricData() {
        return this.metricData;
    }

    public BatchAtomicity getBatchAtomicity() {
        return this.batchAtomicity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PostMetricDataDetails(");
        sb.append("super=").append(super.toString());
        sb.append("metricData=").append(String.valueOf(this.metricData));
        sb.append(", batchAtomicity=").append(String.valueOf((Object)this.batchAtomicity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostMetricDataDetails)) {
            return false;
        }
        PostMetricDataDetails other = (PostMetricDataDetails)((Object)o);
        return Objects.equals(this.metricData, other.metricData) && Objects.equals((Object)this.batchAtomicity, (Object)other.batchAtomicity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricData == null ? 43 : this.metricData.hashCode());
        result = result * 59 + (this.batchAtomicity == null ? 43 : this.batchAtomicity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BatchAtomicity implements BmcEnum
    {
        Atomic("ATOMIC"),
        NonAtomic("NON_ATOMIC");

        private final String value;
        private static Map<String, BatchAtomicity> map;

        private BatchAtomicity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BatchAtomicity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BatchAtomicity: " + key);
        }

        static {
            map = new HashMap<String, BatchAtomicity>();
            for (BatchAtomicity v : BatchAtomicity.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricData")
        private List<MetricDataDetails> metricData;
        @JsonProperty(value="batchAtomicity")
        private BatchAtomicity batchAtomicity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricData(List<MetricDataDetails> metricData) {
            this.metricData = metricData;
            this.__explicitlySet__.add("metricData");
            return this;
        }

        public Builder batchAtomicity(BatchAtomicity batchAtomicity) {
            this.batchAtomicity = batchAtomicity;
            this.__explicitlySet__.add("batchAtomicity");
            return this;
        }

        public PostMetricDataDetails build() {
            PostMetricDataDetails model = new PostMetricDataDetails(this.metricData, this.batchAtomicity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PostMetricDataDetails model) {
            if (model.wasPropertyExplicitlySet("metricData")) {
                this.metricData(model.getMetricData());
            }
            if (model.wasPropertyExplicitlySet("batchAtomicity")) {
                this.batchAtomicity(model.getBatchAtomicity());
            }
            return this;
        }
    }
}

