/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.editor.bookmarks.FileBookmarksChange;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;

public final class ProjectBookmarksChange {
    private final ProjectBookmarks projectBookmarks;
    private final Map<URI, FileBookmarksChange> fileBookmarksChanges;
    private boolean added;
    private boolean loaded;
    private boolean released;

    public ProjectBookmarksChange(ProjectBookmarks projectBookmarks) {
        this.projectBookmarks = projectBookmarks;
        this.fileBookmarksChanges = new HashMap<URI, FileBookmarksChange>();
    }

    public ProjectBookmarks getProjectBookmarks() {
        return this.projectBookmarks;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isReleased() {
        return this.released;
    }

    public FileBookmarksChange getFileBookmarksChange(URI relativeURI) {
        return this.fileBookmarksChanges.get(relativeURI);
    }

    public Collection<FileBookmarksChange> getFileBookmarksChanges() {
        return this.fileBookmarksChanges.values();
    }

    void markAdded() {
        this.added = true;
    }

    void markLoaded() {
        this.loaded = true;
    }

    void markReleased() {
        this.released = true;
    }

    void addChange(FileBookmarksChange change) {
        FileBookmarksChange o = this.fileBookmarksChanges.put(change.getFileBookmarks().getRelativeURI(), change);
        if (o != null) {
            throw new IllegalStateException("Change already present: " + change);
        }
    }
}

