/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.imports;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.java.editor.base.javadoc.JavadocImports;
import org.openide.util.Pair;

public class UnusedImports {
    private static final Object KEY_CACHE = new Object();
    private static final ImportTree FAKE_IMPORT = new ImportTree(){

        @Override
        public boolean isStatic() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isModule() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Tree getQualifiedIdentifier() {
            return null;
        }

        @Override
        public Tree.Kind getKind() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };

    public static List<TreePathHandle> computeUnusedImports(CompilationInfo info) {
        ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>();
        for (TreePath unused : UnusedImports.process(info, new AtomicBoolean())) {
            result.add(TreePathHandle.create((TreePath)unused, (CompilationInfo)info));
        }
        return result;
    }

    public static Collection<TreePath> process(CompilationInfo info, AtomicBoolean cancel) {
        Collection result = (Collection)info.getCachedValue(KEY_CACHE);
        if (result != null) {
            return result;
        }
        DetectorVisitor v = new DetectorVisitor(info, cancel);
        CompilationUnitTree cu = info.getCompilationUnit();
        v.scan(cu, null);
        if (cancel.get()) {
            return null;
        }
        List<TreePath> allUnusedImports = new ArrayList();
        for (TreePath tree : v.getUnusedImports().values()) {
            if (cancel.get()) {
                return null;
            }
            allUnusedImports.add(tree);
        }
        allUnusedImports = Collections.unmodifiableList(allUnusedImports);
        info.putCachedValue(KEY_CACHE, allUnusedImports, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        return allUnusedImports;
    }

    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, Void> {
        private final CompilationInfo info;
        private final Map<Element, ImportTree> element2Import = new HashMap<Element, ImportTree>();
        private final Map<PackageElement, Pair<ModuleElement, ModuleElement>> packagesFromModuleImports2PrimaryModuleAndRealModule = new HashMap<PackageElement, Pair<ModuleElement, ModuleElement>>();
        private final Map<ModuleElement, ImportTree> primaryModule2Import = new HashMap<ModuleElement, ImportTree>();
        private final Set<ModuleElement> usedModules = new HashSet<ModuleElement>();
        private final Map<ModuleElement, ModuleElement> usedTransitiveModule2PrimaryModule = new HashMap<ModuleElement, ModuleElement>();
        private final Set<Element> importedBySingleImport = new HashSet<Element>();
        private final Map<String, Collection<ImportTree>> simpleName2UnresolvableImports = new HashMap<String, Collection<ImportTree>>();
        private final Set<ImportTree> unresolvablePackageImports = new HashSet<ImportTree>();
        private final Map<ImportTree, TreePath> import2Highlight = new HashMap<ImportTree, TreePath>();
        private final Map<ImportTree, Integer> usageCounts = new HashMap<ImportTree, Integer>();

        private DetectorVisitor(CompilationInfo info, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
        }

        private void handleJavadoc(TreePath classMember) {
            if (classMember == null) {
                return;
            }
            for (Element element : JavadocImports.computeReferencedElements(this.info, classMember)) {
                this.typeUsed(element, null, false);
            }
        }

        public Map<ImportTree, TreePath> getUnusedImports() {
            HashMap<ImportTree, TreePath> ret = new HashMap<ImportTree, TreePath>(this.import2Highlight);
            ret.keySet().removeAll(this.usageCounts.keySet());
            HashSet<ModuleElement> pendingUsedModules = new HashSet<ModuleElement>(this.usedModules);
            Iterator<ModuleElement> it = pendingUsedModules.iterator();
            while (it.hasNext()) {
                ModuleElement primary = it.next();
                ImportTree imp = this.primaryModule2Import.get(primary);
                if (imp == null) continue;
                it.remove();
                ret.remove(imp);
            }
            for (ModuleElement remaining : pendingUsedModules) {
                ModuleElement primary = this.usedTransitiveModule2PrimaryModule.get(remaining);
                ImportTree imp = primary != null ? this.primaryModule2Import.get(primary) : null;
                if (imp == null) continue;
                ret.remove(imp);
            }
            return ret;
        }

        public Void visitClass(ClassTree node, Void p) {
            this.handleJavadoc(this.getCurrentPath());
            return (Void)super.visitClass(node, (Object)p);
        }

        public Void visitMethod(MethodTree node, Void p) {
            this.handleJavadoc(this.getCurrentPath());
            return (Void)super.visitMethod(node, (Object)p);
        }

        public Void visitVariable(VariableTree node, Void p) {
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && e.getKind().isField()) {
                this.handleJavadoc(this.getCurrentPath());
            }
            return (Void)super.visitVariable(node, (Object)p);
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, Void d) {
            PackageElement javaLang = this.info.getElements().getPackageElement("java.lang");
            if (javaLang != null) {
                List<TypeElement> types = ElementFilter.typesIn(javaLang.getEnclosedElements());
                for (TypeElement te : types) {
                    if (this.element2Import.containsKey(te)) continue;
                    this.element2Import.put(te, FAKE_IMPORT);
                }
            }
            this.scan(tree.getImports(), d);
            this.scan(tree.getPackageAnnotations(), d);
            this.scan(tree.getTypeDecls(), d);
            this.scan(tree.getModule(), d);
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, Void d) {
            if (this.info.getTrees().getSourcePositions().getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < 0L) {
                return null;
            }
            this.typeUsed(this.info.getTrees().getElement(this.getCurrentPath()), this.getCurrentPath(), this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION);
            return (Void)super.visitIdentifier(tree, null);
        }

        private boolean isStar(ImportTree tree) {
            Tree qualIdent = tree.getQualifiedIdentifier();
            if (qualIdent == null || qualIdent.getKind() == Tree.Kind.IDENTIFIER) {
                return false;
            }
            return ((MemberSelectTree)qualIdent).getIdentifier().contentEquals("*");
        }

        private boolean parseErrorInImport(ImportTree imp) {
            if (this.isStar(imp)) {
                return false;
            }
            final StringBuilder fqn = new StringBuilder();
            new ErrorAwareTreeScanner<Void, Void>(){

                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    super.visitMemberSelect(node, (Object)p);
                    fqn.append('.');
                    fqn.append(node.getIdentifier());
                    return null;
                }

                public Void visitIdentifier(IdentifierTree node, Void p) {
                    fqn.append(node.getName());
                    return null;
                }
            }.scan(imp.getQualifiedIdentifier(), null);
            return !SourceVersion.isName(fqn);
        }

        public boolean isErroneous(@NullAllowed Element e) {
            if (e == null) {
                return true;
            }
            if (e.getKind() == ElementKind.MODULE) {
                return false;
            }
            TypeMirror type = e.asType();
            if (type == null) {
                return false;
            }
            return type.getKind() == TypeKind.ERROR || type.getKind() == TypeKind.OTHER;
        }

        public Void visitImport(ImportTree tree, Void d) {
            if (this.parseErrorInImport(tree)) {
                return (Void)super.visitImport(tree, null);
            }
            if (tree.getQualifiedIdentifier() == null) {
                return (Void)super.visitImport(tree, null);
            }
            boolean assign = false;
            if (tree.isModule()) {
                String moduleName = tree.getQualifiedIdentifier().toString();
                ModuleElement primary = this.info.getElements().getModuleElement(moduleName);
                if (primary != null) {
                    this.primaryModule2Import.put(primary, tree);
                    for (PackageElement pack : this.info.getElementUtilities().transitivelyExportedPackages(primary)) {
                        this.usedTransitiveModule2PrimaryModule.putIfAbsent((ModuleElement)pack.getEnclosingElement(), primary);
                        this.packagesFromModuleImports2PrimaryModuleAndRealModule.put(pack, (Pair<ModuleElement, ModuleElement>)Pair.of((Object)primary, (Object)((ModuleElement)pack.getEnclosingElement())));
                    }
                    this.import2Highlight.put(tree, this.getCurrentPath());
                }
            } else {
                if (tree.getQualifiedIdentifier().getKind() != Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitImport(tree, null);
                }
                MemberSelectTree qualIdent = (MemberSelectTree)tree.getQualifiedIdentifier();
                boolean star = this.isStar(tree);
                TreePath tp = tree.isStatic() || star ? new TreePath(new TreePath(this.getCurrentPath(), qualIdent), qualIdent.getExpression()) : new TreePath(this.getCurrentPath(), tree.getQualifiedIdentifier());
                Element decl = this.info.getTrees().getElement(tp);
                this.import2Highlight.put(tree, this.getCurrentPath());
                if (decl != null && !this.isErroneous(decl)) {
                    if (!tree.isStatic()) {
                        if (star) {
                            List<TypeElement> types = ElementFilter.typesIn(decl.getEnclosedElements());
                            for (TypeElement typeElement : types) {
                                assign = true;
                                if (this.element2Import.containsKey(typeElement)) continue;
                                this.element2Import.put(typeElement, tree);
                            }
                        } else {
                            this.element2Import.put(decl, tree);
                            this.importedBySingleImport.add(decl);
                        }
                    } else if (decl.getKind().isClass() || decl.getKind().isInterface()) {
                        Name simpleName = star ? null : qualIdent.getIdentifier();
                        for (Element element : this.info.getElements().getAllMembers((TypeElement)decl)) {
                            if (!element.getModifiers().contains((Object)Modifier.STATIC) || simpleName != null && !element.getSimpleName().equals(simpleName)) continue;
                            if (!star || !this.element2Import.containsKey(element)) {
                                this.element2Import.put(element, tree);
                            }
                            assign = true;
                        }
                    }
                }
                if (!assign) {
                    if (!tree.isStatic() && star) {
                        this.unresolvablePackageImports.add(tree);
                    } else {
                        this.addUnresolvableImport(qualIdent.getIdentifier(), tree);
                    }
                }
            }
            super.visitImport(tree, null);
            return null;
        }

        private void addUnresolvableImport(Name name, ImportTree imp) {
            String key = name.toString();
            Collection<ImportTree> l = this.simpleName2UnresolvableImports.get(key);
            if (l == null) {
                l = new LinkedList<ImportTree>();
                this.simpleName2UnresolvableImports.put(key, l);
            }
            l.add(imp);
        }

        private void addUsage(ImportTree imp) {
            Integer i = this.usageCounts.get(imp);
            if (i == null) {
                i = 0;
            }
            Integer n = i;
            i = i + 1;
            this.usageCounts.put(imp, n);
        }

        private void typeUsed(Element decl, TreePath expr, boolean methodInvocation) {
            block2: {
                block3: {
                    Pair<ModuleElement, ModuleElement> modules;
                    if (decl == null || expr != null && expr.getLeaf().getKind() != Tree.Kind.IDENTIFIER && expr.getLeaf().getKind() != Tree.Kind.PARAMETERIZED_TYPE) break block2;
                    if (this.isErroneous(decl)) break block3;
                    ImportTree imp = this.element2Import.get(decl);
                    if (!(imp != null || !decl.getKind().isClass() && !decl.getKind().isInterface() || decl.getEnclosingElement().getKind() != ElementKind.PACKAGE || this.info.getCompilationUnit().getPackage() != null && decl.getEnclosingElement().equals(this.info.getTrees().getElement(new TreePath(new TreePath(this.info.getCompilationUnit()), this.info.getCompilationUnit().getPackage()))) || (modules = this.packagesFromModuleImports2PrimaryModuleAndRealModule.get(decl.getEnclosingElement())) == null)) {
                        this.usedModules.add((ModuleElement)modules.second());
                    }
                    if (imp == null) break block2;
                    this.addUsage(imp);
                    if (!this.isStar(imp)) break block2;
                    this.handleUnresolvableImports(decl, methodInvocation, false);
                    break block2;
                }
                this.handleUnresolvableImports(decl, methodInvocation, true);
                for (Map.Entry<Element, ImportTree> e : this.element2Import.entrySet()) {
                    if (this.importedBySingleImport.contains(e.getKey()) || !e.getKey().getSimpleName().equals(decl.getSimpleName())) continue;
                    this.import2Highlight.remove(e.getValue());
                }
            }
        }

        private void handleUnresolvableImports(Element decl, boolean methodInvocation, boolean removeStarImports) {
            block2: {
                block3: {
                    Name simpleName = decl.getSimpleName();
                    if (simpleName == null) break block2;
                    Collection<ImportTree> imps = this.simpleName2UnresolvableImports.get(simpleName.toString());
                    if (imps == null) break block3;
                    for (ImportTree imp : imps) {
                        if (methodInvocation && !imp.isStatic()) continue;
                        this.import2Highlight.remove(imp);
                    }
                    break block2;
                }
                if (!removeStarImports) break block2;
                for (ImportTree unresolvable : this.unresolvablePackageImports) {
                    if (methodInvocation && !unresolvable.isStatic()) continue;
                    this.import2Highlight.remove(unresolvable);
                }
            }
        }
    }
}

