/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.maven.index.ArtifactAvailability;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.StringSearchExpression;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.request.Field;
import org.apache.maven.search.api.request.FieldQuery;
import org.apache.maven.search.api.request.Paging;
import org.apache.maven.search.api.request.Query;
import org.apache.maven.search.api.transport.Java11HttpClientTransport;
import org.apache.maven.search.api.transport.Transport;
import org.apache.maven.search.backend.smo.SmoSearchBackend;
import org.apache.maven.search.backend.smo.SmoSearchBackendFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.indexer.ArtifactDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.ClassDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.CompositeResult;
import org.netbeans.modules.maven.indexer.NexusRepositoryIndexManager;
import org.netbeans.modules.maven.indexer.ResultImpl;
import org.netbeans.modules.maven.indexer.SMORequestResult;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;
import org.openide.util.Mutex;

final class NexusRepositoryQueries
implements BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
ClassUsageQuery,
GenericFindQuery,
ContextLoadedQuery {
    private static final Logger LOGGER = Logger.getLogger(NexusRepositoryQueries.class.getName());
    private SmoSearchBackend smo;
    private final NexusRepositoryIndexManager indexer;

    NexusRepositoryQueries(NexusRepositoryIndexManager indexer) {
        this.indexer = indexer;
    }

    @Override
    public ResultImplementation<String> getGroups(List<RepositoryInfo> repos) {
        return this.filterGroupIds("", repos);
    }

    private ResultImplementation<String> filterGroupIds(String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(res -> this.filterGroupIds(prefix, res, res.getSkipped(), false));
        return this.filterGroupIds(prefix, result, repos, true);
    }

    private ResultImplementation<String> filterGroupIds(String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> groups = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            Set<String> all = context.getAllGroups();
            if (!all.isEmpty()) {
                if (prefix.isEmpty()) {
                    groups.addAll(all);
                } else {
                    for (String gr : all) {
                        if (!gr.startsWith(prefix)) continue;
                        groups.add(gr);
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(groups);
        return result;
    }

    @Override
    public ResultImplementation<String> getGAVsForPackaging(String packaging, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.getGAVsForPackaging(packaging, result1, result1.getSkipped(), false));
        return this.getGAVsForPackaging(packaging, result, repos, true);
    }

    private ResultImplementation<String> getGAVsForPackaging(String packaging, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<String> infos = new ArrayList<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, packaging)), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        String gav = ai.getGroupId() + ":" + ai.getArtifactId() + ":" + ai.getVersion();
                        if (infos.contains(gav)) continue;
                        infos.add(gav);
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> getRecords(String groupId, String artifactId, String version, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.getRecords(groupId, artifactId, version, result1, result1.getSkipped(), false));
        return this.getRecords(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> getRecords(String groupId, String artifactId, String version, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|" + artifactId + "|" + version + "|";
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, 4096);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryQueries.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<String> getArtifacts(String groupId, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.getArtifacts(groupId, result1, result1.getSkipped(), false));
        return this.getArtifacts(groupId, result, repos, true);
    }

    private ResultImplementation<String> getArtifacts(String groupId, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|";
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause(NexusRepositoryQueries.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.getArtifactId());
                    }
                }
                finally {
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> getVersions(String groupId, String artifactId, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.getVersions(groupId, artifactId, result1, result1.getSkipped(), false));
        return this.getVersions(groupId, artifactId, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> getVersions(String groupId, String artifactId, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|" + artifactId + "|";
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause(NexusRepositoryQueries.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, 10000);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryQueries.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findVersionsByClass(String className, List<RepositoryInfo> repos) {
        Optional<RepositoryInfo> central = repos.stream().filter(repo -> repo.getId().equals(this.getSMO().getRepositoryId())).findFirst();
        if (central.isPresent()) {
            ArrayList<RepositoryInfo> otherRepos = new ArrayList<RepositoryInfo>(repos);
            otherRepos.remove(central.get());
            SearchRequest request = new SearchRequest(new Paging(128), (Query)FieldQuery.fieldQuery((Field)(className.contains(".") ? MAVEN.FQ_CLASS_NAME : MAVEN.CLASS_NAME), (String)className));
            return new CompositeResult<NBVersionInfo>(this.findVersionsByClass(className, otherRepos), new SMORequestResult(this.getSMO(), request));
        }
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findVersionsByClass(className, result1, result1.getSkipped(), false));
        return this.findVersionsByClass(className, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findVersionsByClass(String className, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            String clsname = className.replace(".", "/");
            while (!clsname.isEmpty() && (clsname.startsWith("*") || clsname.startsWith("?"))) {
                clsname = clsname.substring(1);
            }
            if (clsname.isEmpty()) {
                return;
            }
            org.apache.lucene.search.Query q = NexusRepositoryQueries.setBooleanRewrite(this.constructQuery(org.apache.maven.index.MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH)));
            IteratorSearchResponse response = this.repeatedPagedSearch(q, context, 4096);
            if (response != null) {
                try {
                    infos.addAll(this.postProcessClasses(response.getResults(), clsname));
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    private Collection<NBVersionInfo> postProcessClasses(IteratorResultSet artifactInfos, String classname) {
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        int patter = 40;
        boolean isPath = classname.contains("/");
        if (isPath) {
            for (ArtifactInfo i : artifactInfos) {
                toRet.add(NexusRepositoryQueries.convertToNBVersionInfo(i));
            }
            return toRet;
        }
        String pattStr = ".*/" + classname + "$.*";
        Pattern patt = Pattern.compile(pattStr, patter);
        ArrayList<ArtifactInfo> altArtifactInfos = new ArrayList<ArtifactInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            Matcher m = patt.matcher(ai.getClassNames());
            if (!m.matches()) continue;
            altArtifactInfos.add(ai);
        }
        for (ArtifactInfo i : altArtifactInfos) {
            toRet.add(NexusRepositoryQueries.convertToNBVersionInfo(i));
        }
        return toRet;
    }

    @Override
    public ResultImplementation<RepositoryQueries.ClassUsage> findClassUsages(String className, @NullAllowed List<RepositoryInfo> repos) {
        ResultImpl<RepositoryQueries.ClassUsage> result = new ResultImpl<RepositoryQueries.ClassUsage>(result1 -> this.findClassUsages(className, result1, result1.getSkipped(), false));
        return this.findClassUsages(className, result, repos, true);
    }

    private ResultImplementation<RepositoryQueries.ClassUsage> findClassUsages(String className, ResultImpl<RepositoryQueries.ClassUsage> result, @NullAllowed List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<RepositoryInfo> localRepos = new ArrayList<RepositoryInfo>();
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        for (RepositoryInfo repo2 : repos) {
            if (!repo2.isLocal()) continue;
            localRepos.add(repo2);
        }
        ArrayList<RepositoryQueries.ClassUsage> results = new ArrayList<RepositoryQueries.ClassUsage>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(localRepos, (repo, context) -> ClassDependencyIndexCreator.search(className, this.indexer.getIndexer(), List.of(context), results), skipAction, skipUnIndexed);
        results.sort((r1, r2) -> r1.getArtifact().compareTo(r2.getArtifact()));
        result.setResults(results);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findDependencyUsage(String groupId, String artifactId, String version, @NullAllowed List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findDependencyUsage(groupId, artifactId, version, result1, result1.getSkipped(), false));
        return this.findDependencyUsage(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findDependencyUsage(String groupId, String artifactId, String version, ResultImpl<NBVersionInfo> result, @NullAllowed List<RepositoryInfo> repos, boolean skipUnIndexed) {
        org.apache.lucene.search.Query q = ArtifactDependencyIndexCreator.query(groupId, artifactId, version);
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch(q, context, 4096);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryQueries.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBGroupInfo> findDependencyUsageGroups(String groupId, String artifactId, String version, List<RepositoryInfo> repos) {
        ResultImpl<NBGroupInfo> result = new ResultImpl<NBGroupInfo>(result1 -> this.findDependencyUsageGroups(groupId, artifactId, version, result1, result1.getSkipped(), false));
        return this.findDependencyUsageGroups(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBGroupInfo> findDependencyUsageGroups(String groupId, String artifactId, String version, ResultImpl<NBGroupInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        HashMap<String, NBGroupInfo> groupMap = new HashMap<String, NBGroupInfo>();
        HashMap<String, NBArtifactInfo> artifactMap = new HashMap<String, NBArtifactInfo>();
        ArrayList<NBGroupInfo> groupInfos = new ArrayList<NBGroupInfo>(result.getResults());
        ResultImpl<NBVersionInfo> res = new ResultImpl<NBVersionInfo>(result1 -> {});
        this.findDependencyUsage(groupId, artifactId, version, res, repos, skipUnIndexed);
        NexusRepositoryQueries.convertToNBGroupInfo(res.getResults(), groupMap, artifactMap, groupInfos);
        if (res.isPartial()) {
            result.addSkipped(res.getSkipped());
        }
        result.setResults(groupInfos);
        return result;
    }

    private static void convertToNBGroupInfo(Collection<NBVersionInfo> artifactInfos, Map<String, NBGroupInfo> groupMap, Map<String, NBArtifactInfo> artifactMap, List<NBGroupInfo> groupInfos) {
        for (NBVersionInfo ai : artifactInfos) {
            NBArtifactInfo ua;
            String groupId = ai.getGroupId();
            String artId = ai.getArtifactId();
            NBGroupInfo ug = groupMap.get(groupId);
            if (ug == null) {
                ug = new NBGroupInfo(groupId);
                groupInfos.add(ug);
                groupMap.put(groupId, ug);
            }
            if ((ua = artifactMap.get(artId)) == null) {
                ua = new NBArtifactInfo(artId);
                ug.addArtifactInfo(ua);
                artifactMap.put(artId, ua);
            }
            ua.addVersionInfo(ai);
        }
    }

    @Override
    public ResultImplementation<NBVersionInfo> findBySHA1(String sha1, List<RepositoryInfo> repos) {
        Optional<RepositoryInfo> central = repos.stream().filter(repo -> repo.getId().equals(this.getSMO().getRepositoryId())).findFirst();
        if (central.isPresent()) {
            ArrayList<RepositoryInfo> otherRepos = new ArrayList<RepositoryInfo>(repos);
            otherRepos.remove(central.get());
            SearchRequest request = new SearchRequest(new Paging(8), (Query)FieldQuery.fieldQuery((Field)MAVEN.SHA1, (String)sha1));
            return new CompositeResult<NBVersionInfo>(this.findBySHA1(sha1, otherRepos), new SMORequestResult(this.getSMO(), request));
        }
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findBySHA1(sha1, result1, result1.getSkipped(), false));
        return this.findBySHA1(sha1, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findBySHA1(String sha1, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause(NexusRepositoryQueries.setBooleanRewrite(this.constructQuery(org.apache.maven.index.MAVEN.SHA1, sha1)), BooleanClause.Occur.SHOULD)).build();
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, 4096);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryQueries.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findArchetypes(List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findArchetypes(result1, result1.getSkipped(), false));
        return this.findArchetypes(result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findArchetypes(ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-archetype")), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryQueries.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<String> filterPluginArtifactIds(String groupId, String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.filterPluginArtifactIds(groupId, prefix, result1, result1.getSkipped(), false));
        return this.filterPluginArtifactIds(groupId, prefix, result, repos, true);
    }

    private ResultImplementation<String> filterPluginArtifactIds(String groupId, String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|" + prefix;
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST)).add(new BooleanClause(NexusRepositoryQueries.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.getArtifactId());
                    }
                }
                finally {
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<String> filterPluginGroupIds(String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.filterPluginGroupIds(prefix, result1, result1.getSkipped(), false));
        return this.filterPluginGroupIds(prefix, result, repos, true);
    }

    private ResultImplementation<String> filterPluginGroupIds(String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
        if (!prefix.isEmpty()) {
            builder.add(new BooleanClause(NexusRepositoryQueries.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.GROUP_ID, prefix))), BooleanClause.Occur.MUST));
        }
        BooleanQuery bq = builder.build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.getGroupId());
                    }
                }
                finally {
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> find(List<QueryField> fields, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.find(fields, result1, result1.getSkipped(), false));
        return this.find(fields, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> find(List<QueryField> fields, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            for (QueryField field : fields) {
                Object q;
                BooleanClause.Occur occur;
                block22: {
                    occur = field.getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                    String fieldName = NexusRepositoryQueries.toNexusField(field.getField());
                    String one = field.getValue();
                    while (!one.isEmpty() && (one.startsWith("*") || one.startsWith("?"))) {
                        one = one.substring(1);
                    }
                    if (one.isEmpty() || fieldName == null) continue;
                    if (ArtifactInfo.NAMES.equals(fieldName)) {
                        try {
                            String clsname = one.replace(".", "/");
                            q = this.constructQuery(org.apache.maven.index.MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH));
                            break block22;
                        }
                        catch (IllegalArgumentException iae) {
                            String clsname = QueryParser.escape((String)one.replace(".", "/"));
                            try {
                                q = this.constructQuery(org.apache.maven.index.MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH));
                                break block22;
                            }
                            catch (IllegalArgumentException iae2) {
                                continue;
                            }
                        }
                    }
                    if (ArtifactInfo.ARTIFACT_ID.equals(fieldName)) {
                        String aid = one.replace("-", "?").replace(".", "?");
                        try {
                            q = this.constructQuery(org.apache.maven.index.MAVEN.ARTIFACT_ID, aid);
                            break block22;
                        }
                        catch (IllegalArgumentException iae) {
                            try {
                                q = this.constructQuery(org.apache.maven.index.MAVEN.ARTIFACT_ID, QueryParser.escape((String)aid));
                                break block22;
                            }
                            catch (IllegalArgumentException iae2) {
                                continue;
                            }
                        }
                    }
                    if (ArtifactInfo.GROUP_ID.equals(fieldName)) {
                        String gid = one.replace("-", "?").replace(".", "?");
                        try {
                            q = this.constructQuery(org.apache.maven.index.MAVEN.GROUP_ID, gid);
                            break block22;
                        }
                        catch (IllegalArgumentException iae) {
                            try {
                                q = this.constructQuery(org.apache.maven.index.MAVEN.GROUP_ID, QueryParser.escape((String)gid));
                                break block22;
                            }
                            catch (IllegalArgumentException iae2) {
                                continue;
                            }
                        }
                    }
                    q = field.getMatch() == 0 ? new TermQuery(new Term(fieldName, one)) : new PrefixQuery(new Term(fieldName, one));
                }
                bq.add(new BooleanClause(NexusRepositoryQueries.setBooleanRewrite(q), occur));
            }
            IteratorSearchResponse resp = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq.build(), context, 4096);
            if (resp != null) {
                try {
                    for (ArtifactInfo ai : resp) {
                        infos.add(NexusRepositoryQueries.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(resp.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(resp.getTotalHitsCount());
                    resp.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    private void doSortIssue226100(List<NBVersionInfo> infos) {
        try {
            Collections.sort(infos);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
    }

    private void iterate(List<RepositoryInfo> repos, RepoAction action, RepoAction actionSkip, boolean skipUnIndexed) {
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        for (RepositoryInfo repo : repos) {
            Mutex mutex = NexusRepositoryIndexManager.getRepoMutex(repo);
            if (skipUnIndexed && NexusRepositoryIndexManager.isIndexing(mutex)) {
                try {
                    actionSkip.run(repo, null);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINER, "could not skip " + repo.getId(), ex);
                }
                continue;
            }
            mutex.writeAccess(() -> {
                try {
                    boolean index = this.indexer.loadIndexingContext(repo);
                    if (skipUnIndexed && index) {
                        if (!RepositoryPreferences.isIndexRepositories()) {
                            return null;
                        }
                        boolean spawned = this.indexer.spawnIndexLoadedRepo(repo);
                        if (spawned) {
                            actionSkip.run(repo, null);
                        }
                        return null;
                    }
                    IndexingContext context = this.indexer.getIndexingContexts().get(repo.getId());
                    if (context == null) {
                        if (skipUnIndexed) {
                            actionSkip.run(repo, null);
                        }
                        return null;
                    }
                    action.run(repo, context);
                }
                catch (IOException x) {
                    LOGGER.log(Level.INFO, "could not process " + repo.getId(), x);
                }
                return null;
            });
        }
    }

    @CheckForNull
    IteratorSearchResponse repeatedPagedSearch(org.apache.lucene.search.Query q, IndexingContext context, int count) throws IOException {
        return this.repeatedPagedSearch(q, List.of(context), count);
    }

    @CheckForNull
    IteratorSearchResponse repeatedPagedSearch(org.apache.lucene.search.Query q, List<IndexingContext> contexts, int count) throws IOException {
        Object pq;
        BooleanQuery booleanQuery;
        List list;
        IteratorSearchRequest isr = new IteratorSearchRequest(q, contexts, new NoJavadocSourceFilter());
        if (count > 0) {
            isr.setCount(count);
        }
        int MAX_MAX_CLAUSE = 2048;
        if (q instanceof BooleanQuery && (list = (booleanQuery = (BooleanQuery)q).clauses()).size() == 1) {
            TermQuery tq;
            org.apache.lucene.search.Query q1 = ((BooleanClause)list.get(0)).getQuery();
            if (q1 instanceof PrefixQuery && "u".equals((pq = (PrefixQuery)q1).getPrefix().field())) {
                MAX_MAX_CLAUSE = 65536;
            } else if (q1 instanceof TermQuery && "p".equals((tq = (TermQuery)q1).getTerm().field())) {
                MAX_MAX_CLAUSE = 65536;
            }
        }
        int oldMax = IndexSearcher.getMaxClauseCount();
        try {
            int max = oldMax;
            while (true) {
                try {
                    IndexSearcher.setMaxClauseCount((int)max);
                    IteratorSearchResponse response = this.indexer.getSearcher().searchIteratorPaged(isr, contexts);
                    LOGGER.log(Level.FINE, "passed on {0} clauses processing {1} with {2} hits", new Object[]{max, q, response.getTotalHitsCount()});
                    pq = response;
                    return pq;
                }
                catch (IndexSearcher.TooManyClauses exc) {
                    block13: {
                        LOGGER.log(Level.FINE, "TooManyClauses on {0} clauses processing {1}", new Object[]{max, q});
                        if ((max *= 2) <= MAX_MAX_CLAUSE) break block13;
                        LOGGER.log(Level.WARNING, "Encountered more than {0} clauses processing {1}", new Object[]{MAX_MAX_CLAUSE, q});
                        IteratorSearchResponse iteratorSearchResponse = null;
                        IndexSearcher.setMaxClauseCount((int)oldMax);
                        return iteratorSearchResponse;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            IndexSearcher.setMaxClauseCount((int)oldMax);
        }
    }

    private org.apache.lucene.search.Query constructQuery(org.apache.maven.index.Field f, String qs) {
        return this.indexer.getIndexer().constructQuery(f, new StringSearchExpression(qs));
    }

    private static org.apache.lucene.search.Query setBooleanRewrite(org.apache.lucene.search.Query q) {
        if (q instanceof MultiTermQuery) {
            MultiTermQuery multiTermQuery = (MultiTermQuery)q;
            multiTermQuery.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
        } else if (q instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)q;
            for (BooleanClause c : booleanQuery.clauses()) {
                NexusRepositoryQueries.setBooleanRewrite(c.getQuery());
            }
        }
        return q;
    }

    private static String toNexusField(String field) {
        if (field != null) {
            switch (field) {
                case "artifactId": {
                    return ArtifactInfo.ARTIFACT_ID;
                }
                case "groupId": {
                    return ArtifactInfo.GROUP_ID;
                }
                case "version": {
                    return ArtifactInfo.VERSION;
                }
                case "classes": {
                    return ArtifactInfo.NAMES;
                }
                case "name": {
                    return ArtifactInfo.NAME;
                }
                case "description": {
                    return ArtifactInfo.DESCRIPTION;
                }
                case "packaging": {
                    return ArtifactInfo.PACKAGING;
                }
            }
        }
        return field;
    }

    static List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> artifactInfos) {
        ArrayList<NBVersionInfo> bVersionInfos = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            NBVersionInfo nbvi = NexusRepositoryQueries.convertToNBVersionInfo(ai);
            if (nbvi == null) continue;
            bVersionInfos.add(nbvi);
        }
        return bVersionInfos;
    }

    static NBVersionInfo convertToNBVersionInfo(ArtifactInfo ai) {
        if ("javadoc".equals(ai.getClassifier()) || "sources".equals(ai.getClassifier())) {
            return null;
        }
        NBVersionInfo nbvi = new NBVersionInfo(ai.getRepository(), ai.getGroupId(), ai.getArtifactId(), ai.getVersion(), ai.getFileExtension(), ai.getPackaging(), ai.getName(), ai.getDescription(), ai.getClassifier());
        nbvi.setJavadocExists(ai.getJavadocExists() == ArtifactAvailability.PRESENT);
        nbvi.setSourcesExists(ai.getSourcesExists() == ArtifactAvailability.PRESENT);
        nbvi.setSignatureExists(ai.getSignatureExists() == ArtifactAvailability.PRESENT);
        nbvi.setLastModified(ai.getLastModified());
        nbvi.setSize(ai.getSize());
        nbvi.setLuceneScore(ai.getLuceneScore());
        return nbvi;
    }

    @Override
    public List<RepositoryInfo> getLoaded(List<RepositoryInfo> repos) {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>(repos.size());
        for (RepositoryInfo repo : repos) {
            Path loc = NexusRepositoryIndexManager.getIndexDirectory(repo);
            if (!NexusRepositoryIndexManager.indexExists(loc)) continue;
            toRet.add(repo);
        }
        return toRet;
    }

    synchronized SmoSearchBackend getSMO() {
        if (this.smo == null) {
            this.smo = SmoSearchBackendFactory.create((String)"central-smo", (String)"central", (String)"https://search.maven.org/solrsearch/select", (Transport)new Java11HttpClientTransport(SMORequestResult.REQUEST_TIMEOUT));
        }
        return this.smo;
    }

    private record SkippedAction(ResultImpl<?> result) implements RepoAction
    {
        @Override
        public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
            this.result.addSkipped(repo);
        }
    }

    private static interface RepoAction {
        public void run(RepositoryInfo var1, IndexingContext var2) throws IOException;
    }

    private static class NoJavadocSourceFilter
    implements ArtifactInfoFilter {
        private NoJavadocSourceFilter() {
        }

        @Override
        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return !"javadoc".equals(ai.getClassifier()) && !"sources".equals(ai.getClassifier());
        }
    }
}

