/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.commands.SkeletonGenerator;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptions;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptionsValidator;
import org.netbeans.modules.php.phpunit.ui.options.Bundle;
import org.netbeans.modules.php.phpunit.ui.options.PhpUnitOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class PhpUnitOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "PhpUnit";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/PhpUnit";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/PhpUnit";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final RequestProcessor RP = new RequestProcessor(PhpUnitOptionsPanelController.class);
    private PhpUnitOptionsPanel phpUnitOptionsPanel = null;
    private volatile boolean changed = false;
    private boolean firstOpening = true;
    private String previousPhpUnitPath;
    private String previousSkeletonGeneratorPath;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPhpUnitOptionsPanel().setPhpUnit(this.getPhpUnitOptions().getPhpUnitPath());
            this.getPhpUnitOptionsPanel().setPhpUnitSkelGen(this.getPhpUnitOptions().getSkeletonGeneratorPath());
            this.updatePhpUnitVersion();
        }
        this.changed = false;
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkeletonGenerator.resetVersion();
                PhpUnitOptionsPanelController.this.getPhpUnitOptions().setPhpUnitPath(PhpUnitOptionsPanelController.this.getPhpUnitOptionsPanel().getPhpUnit());
                PhpUnitOptionsPanelController.this.getPhpUnitOptions().setSkeletonGeneratorPath(PhpUnitOptionsPanelController.this.getPhpUnitOptionsPanel().getPhpUnitSkelGen());
                PhpUnit.resetVersions();
                PhpUnitOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPhpUnitOptionsPanel().setPhpUnit(this.getPhpUnitOptions().getPhpUnitPath());
            this.getPhpUnitOptionsPanel().setPhpUnitSkelGen(this.getPhpUnitOptions().getSkeletonGeneratorPath());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        this.setPhpUnitVersion();
        PhpUnitOptionsPanel panel = this.getPhpUnitOptionsPanel();
        ValidationResult result = new PhpUnitOptionsValidator().validate(panel.getPhpUnit(), panel.getPhpUnitSkelGen()).getResult();
        if (result.hasErrors()) {
            panel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    private void updatePhpUnitVersion() {
        String phpUnitPath = this.getPhpUnitOptionsPanel().getPhpUnit();
        if (!StringUtils.hasText((String)phpUnitPath)) {
            SwingUtilities.invokeLater(() -> this.getPhpUnitOptionsPanel().setVersion(Bundle.PhpUnitOptionsPanelController_notFound_phpUnit_version()));
            return;
        }
        SwingUtilities.invokeLater(() -> this.getPhpUnitOptionsPanel().setVersion(Bundle.PhpUnitOptionsPanelController_getting_phpUnit_version()));
        RP.post(() -> {
            String versionLine = PhpUnit.getVersionLine(phpUnitPath);
            SwingUtilities.invokeLater(() -> this.getPhpUnitOptionsPanel().setVersion(versionLine));
        });
    }

    private void setPhpUnitVersion() {
        PhpUnitOptionsPanel panel = this.getPhpUnitOptionsPanel();
        ValidationResult phpUnitPathResult = new PhpUnitOptionsValidator().validatePhpUnitPath(panel.getPhpUnit()).getResult();
        if (!phpUnitPathResult.hasErrors() && !phpUnitPathResult.hasWarnings()) {
            this.updatePhpUnitVersion();
        } else {
            panel.setVersion(Bundle.PhpUnitOptionsPanelController_notFound_phpUnit_version());
        }
    }

    public boolean isChanged() {
        String current;
        String saved = this.previousPhpUnitPath;
        this.previousPhpUnitPath = current = this.getPhpUnitOptionsPanel().getPhpUnit().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.previousSkeletonGeneratorPath;
        this.previousSkeletonGeneratorPath = current = this.getPhpUnitOptionsPanel().getPhpUnitSkelGen().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPhpUnitOptionsPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.phpunit.PhpUnit");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private PhpUnitOptionsPanel getPhpUnitOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.phpUnitOptionsPanel == null) {
            this.phpUnitOptionsPanel = new PhpUnitOptionsPanel();
            this.phpUnitOptionsPanel.addChangeListener(this);
        }
        return this.phpUnitOptionsPanel;
    }

    private PhpUnitOptions getPhpUnitOptions() {
        return PhpUnitOptions.getInstance();
    }
}

