/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.CdiUtil;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BeansXmlIterator
implements TemplateWizard.Iterator {
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private int index;
    private static final String defaultName = "beans";
    private transient WizardDescriptor.Panel[] panels;
    private transient J2eeProjectType type;

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        FileObject fo;
        String targetName = Templates.getTargetName((WizardDescriptor)wizard);
        FileObject targetDir = Templates.getTargetFolder((WizardDescriptor)wizard);
        Project project = Templates.getProject((WizardDescriptor)wizard);
        Profile profile = null;
        if (project != null) {
            J2eeProjectCapabilities cap = J2eeProjectCapabilities.forProject((Project)project);
            if (cap != null && cap.isCdi41Supported()) {
                profile = Profile.JAKARTA_EE_11_FULL;
            } else if (cap != null && cap.isCdi40Supported()) {
                profile = Profile.JAKARTA_EE_10_FULL;
            } else if (cap != null && cap.isCdi30Supported()) {
                profile = Profile.JAKARTA_EE_9_FULL;
            } else if (cap != null && cap.isCdi20Supported()) {
                profile = Profile.JAVA_EE_8_FULL;
            } else if (cap != null && cap.isCdi11Supported()) {
                profile = Profile.JAVA_EE_7_FULL;
            }
        }
        if ((fo = DDHelper.createBeansXml((Profile)(profile != null ? profile : Profile.JAVA_EE_6_FULL), (FileObject)targetDir, (String)targetName)) != null) {
            CdiUtil logger;
            if (project != null && (logger = (CdiUtil)project.getLookup().lookup(CdiUtil.class)) != null) {
                logger.log("USG_CDI_BEANS_WIZARD", BeansXmlIterator.class, new Object[]{project.getClass().getName()}, true);
            }
            return Collections.singleton(DataObject.find((FileObject)fo));
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(TemplateWizard wizard) {
        SourceGroup[] sourceGroups;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        FileObject targetFolder = this.getTargetFolder(project);
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        String parentFolder = null;
        if (this.type == J2eeProjectType.WAR) {
            sourceGroups = sources.getSourceGroups("doc_root");
            if (targetFolder != null && targetFolder.getFileObject("beans.xml") != null) {
                parentFolder = WEB_INF;
            }
        } else {
            if (this.type != null && targetFolder != null && targetFolder.getFileObject("beans.xml") != null) {
                parentFolder = targetFolder.getName();
            }
            sourceGroups = sources.getSourceGroups("generic");
        }
        Templates.SimpleTargetChooserBuilder builder = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups);
        builder = builder.bottomPanel((WizardDescriptor.Panel)new FakePanel(parentFolder));
        WizardDescriptor.Panel folderPanel = builder.create();
        this.panels = new WizardDescriptor.Panel[]{folderPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = BeansXmlIterator.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        Templates.setTargetName((WizardDescriptor)wizard, (String)defaultName);
        Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)targetFolder);
    }

    private FileObject getTargetFolder(Project project) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            FileObject webInf = wm.getWebInf();
            if (webInf == null && wm.getDocumentBase() != null) {
                try {
                    webInf = FileUtil.createFolder((FileObject)wm.getDocumentBase(), (String)WEB_INF);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.type = J2eeProjectType.WAR;
            return webInf;
        }
        EjbJar[] ejbs = EjbJar.getEjbJars((Project)project);
        if (ejbs.length > 0) {
            this.type = J2eeProjectType.JAR;
            return ejbs[0].getMetaInf();
        }
        Car[] cars = Car.getCars((Project)project);
        if (cars.length > 0) {
            this.type = J2eeProjectType.CAR;
            return cars[0].getMetaInf();
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length > 0) {
            FileObject metaInf = sourceGroups[0].getRootFolder().getFileObject(META_INF);
            if (metaInf == null) {
                try {
                    metaInf = FileUtil.createFolder((FileObject)sourceGroups[0].getRootFolder(), (String)META_INF);
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            if (metaInf != null) {
                return metaInf;
            }
        }
        return project.getProjectDirectory();
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(BeansXmlIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private static enum J2eeProjectType {
        WAR,
        JAR,
        CAR;

    }

    static class FakePanel
    implements WizardDescriptor.Panel {
        private String folder;

        FakePanel(String folder) {
            this.folder = folder;
        }

        public Component getComponent() {
            return new JPanel();
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(Object settings) {
            if (this.folder != null) {
                ((WizardDescriptor)settings).putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(BeansXmlIterator.class, (String)"ERR_BeansAlreadyExists", (Object)this.folder));
            }
        }

        public void storeSettings(Object settings) {
        }

        public boolean isValid() {
            return this.folder == null;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

