/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.chrome_devtools_protocol;

import com.google.gson.JsonElement;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.netbeans.lib.chrome_devtools_protocol.ChromeDevToolsClient;
import org.netbeans.lib.chrome_devtools_protocol.Unregisterer;
import org.netbeans.lib.chrome_devtools_protocol.debugger.BreakpointResolved;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ContinueToLocationRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ContinueToLocationResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.DisableRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.DisableResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EnableRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EnableResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.GetPossibleBreakpointsRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.GetPossibleBreakpointsResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.GetScriptSourceRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.GetScriptSourceResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.PauseRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.PauseResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.Paused;
import org.netbeans.lib.chrome_devtools_protocol.debugger.RemoveBreakpointRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.RemoveBreakpointResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ResumeRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ResumeResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.Resumed;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ScriptFailedToParse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ScriptParsed;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SearchInContentRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SearchInContentResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetAsyncCallStackDepthRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetAsyncCallStackDepthResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointByUrlRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointByUrlResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointsActiveRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetBreakpointsActiveResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetInstrumentationBreakpointRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetInstrumentationBreakpointResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetPauseOnExceptionsRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetPauseOnExceptionsResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetScriptSourceRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetScriptSourceResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetSkipAllPausesRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetSkipAllPausesResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetVariableValueRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.SetVariableValueResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.StepIntoRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.StepIntoResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.StepOutRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.StepOutResponse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.StepOverRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.StepOverResponse;

public final class DebuggerDomain {
    private final ChromeDevToolsClient cdtc;

    DebuggerDomain(ChromeDevToolsClient cdtc) {
        this.cdtc = cdtc;
    }

    public CompletionStage<ContinueToLocationResponse> continueToLocation(ContinueToLocationRequest req) {
        return this.cdtc.methodCall("Debugger.continueToLocation", req).thenApply(s -> (ContinueToLocationResponse)this.cdtc.getGson().fromJson(s, ContinueToLocationResponse.class));
    }

    public CompletionStage<DisableResponse> disable(DisableRequest req) {
        return this.cdtc.methodCall("Debugger.disable", req).thenApply(s -> (DisableResponse)this.cdtc.getGson().fromJson(s, DisableResponse.class));
    }

    public CompletionStage<EnableResponse> enable(EnableRequest req) {
        return this.cdtc.methodCall("Debugger.enable", req).thenApply(s -> (EnableResponse)this.cdtc.getGson().fromJson(s, EnableResponse.class));
    }

    public CompletionStage<EvaluateOnCallFrameResponse> evaluateOnCallFrame(EvaluateOnCallFrameRequest req) {
        return this.cdtc.methodCall("Debugger.evaluateOnCallFrame", req).thenApply(s -> (EvaluateOnCallFrameResponse)this.cdtc.getGson().fromJson(s, EvaluateOnCallFrameResponse.class));
    }

    public CompletionStage<GetPossibleBreakpointsResponse> getPossibleBreakpoints(GetPossibleBreakpointsRequest req) {
        return this.cdtc.methodCall("Debugger.getPossibleBreakpoints", req).thenApply(s -> (GetPossibleBreakpointsResponse)this.cdtc.getGson().fromJson(s, GetPossibleBreakpointsResponse.class));
    }

    public CompletionStage<GetScriptSourceResponse> getScriptSource(GetScriptSourceRequest req) {
        return this.cdtc.methodCall("Debugger.getScriptSource", req).thenApply(s -> (GetScriptSourceResponse)this.cdtc.getGson().fromJson(s, GetScriptSourceResponse.class));
    }

    public CompletionStage<PauseResponse> pause(PauseRequest req) {
        return this.cdtc.methodCall("Debugger.pause", req).thenApply(s -> (PauseResponse)this.cdtc.getGson().fromJson(s, PauseResponse.class));
    }

    public CompletionStage<RemoveBreakpointResponse> removeBreakpoint(RemoveBreakpointRequest req) {
        return this.cdtc.methodCall("Debugger.removeBreakpoint", req).thenApply(s -> (RemoveBreakpointResponse)this.cdtc.getGson().fromJson(s, RemoveBreakpointResponse.class));
    }

    public CompletionStage<ResumeResponse> resume(ResumeRequest req) {
        return this.cdtc.methodCall("Debugger.resume", req).thenApply(s -> (ResumeResponse)this.cdtc.getGson().fromJson(s, ResumeResponse.class));
    }

    public CompletionStage<SearchInContentRequest> searchInContent(SearchInContentResponse req) {
        return this.cdtc.methodCall("Debugger.searchInContent", req).thenApply(s -> (SearchInContentRequest)this.cdtc.getGson().fromJson(s, SearchInContentRequest.class));
    }

    public CompletionStage<SetAsyncCallStackDepthResponse> setAsyncCallStackDepth(SetAsyncCallStackDepthRequest req) {
        return this.cdtc.methodCall("Debugger.setAsyncCallStackDepth", req).thenApply(s -> (SetAsyncCallStackDepthResponse)this.cdtc.getGson().fromJson(s, SetAsyncCallStackDepthResponse.class));
    }

    public CompletionStage<SetBreakpointResponse> setBreakpoint(SetBreakpointRequest req) {
        return this.cdtc.methodCall("Debugger.setBreakpoint", req).thenApply(s -> (SetBreakpointResponse)this.cdtc.getGson().fromJson(s, SetBreakpointResponse.class));
    }

    public CompletionStage<SetBreakpointByUrlResponse> setBreakpointByUrl(SetBreakpointByUrlRequest bbur) {
        return this.cdtc.methodCall("Debugger.setBreakpointByUrl", bbur).thenApply(s -> (SetBreakpointByUrlResponse)this.cdtc.getGson().fromJson(s, SetBreakpointByUrlResponse.class));
    }

    public CompletionStage<SetBreakpointsActiveResponse> setBreakpointsActive(SetBreakpointsActiveRequest req) {
        return this.cdtc.methodCall("Debugger.setBreakpointsActive", req).thenApply(s -> (SetBreakpointsActiveResponse)this.cdtc.getGson().fromJson(s, SetBreakpointsActiveResponse.class));
    }

    public CompletionStage<SetInstrumentationBreakpointResponse> setInstrumentationBreakpoint(SetInstrumentationBreakpointRequest req) {
        return this.cdtc.methodCall("Debugger.setInstrumentationBreakpoint", req).thenApply(s -> (SetInstrumentationBreakpointResponse)this.cdtc.getGson().fromJson(s, SetInstrumentationBreakpointResponse.class));
    }

    public CompletionStage<SetPauseOnExceptionsResponse> setPauseOnExceptions(SetPauseOnExceptionsRequest req) {
        return this.cdtc.methodCall("Debugger.setPauseOnExceptions", req).thenApply(s -> (SetPauseOnExceptionsResponse)this.cdtc.getGson().fromJson(s, SetPauseOnExceptionsResponse.class));
    }

    public CompletionStage<SetScriptSourceResponse> setScriptSource(SetScriptSourceRequest req) {
        return this.cdtc.methodCall("Debugger.setScriptSource", req).thenApply(s -> (SetScriptSourceResponse)this.cdtc.getGson().fromJson(s, SetScriptSourceResponse.class));
    }

    public CompletionStage<SetSkipAllPausesResponse> setSkipAllPauses(SetSkipAllPausesRequest req) {
        return this.cdtc.methodCall("Debugger.setSkipAllPauses", req).thenApply(s -> (SetSkipAllPausesResponse)this.cdtc.getGson().fromJson(s, SetSkipAllPausesResponse.class));
    }

    public CompletionStage<SetVariableValueResponse> setVariableValue(SetVariableValueRequest req) {
        return this.cdtc.methodCall("Debugger.setVariableValue", req).thenApply(s -> (SetVariableValueResponse)this.cdtc.getGson().fromJson(s, SetVariableValueResponse.class));
    }

    public CompletionStage<StepIntoResponse> stepInto(StepIntoRequest req) {
        return this.cdtc.methodCall("Debugger.stepInto", req).thenApply(s -> (StepIntoResponse)this.cdtc.getGson().fromJson(s, StepIntoResponse.class));
    }

    public CompletionStage<StepOutResponse> stepOut(StepOutRequest req) {
        return this.cdtc.methodCall("Debugger.stepOut", req).thenApply(s -> (StepOutResponse)this.cdtc.getGson().fromJson(s, StepOutResponse.class));
    }

    public CompletionStage<StepOverResponse> stepOver(StepOverRequest req) {
        return this.cdtc.methodCall("Debugger.stepOver", req).thenApply(s -> (StepOverResponse)this.cdtc.getGson().fromJson(s, StepOverResponse.class));
    }

    public Unregisterer onBreakpointResolved(Consumer<BreakpointResolved> handler) {
        Consumer<JsonElement> adapter = je -> {
            BreakpointResolved parsed = (BreakpointResolved)this.cdtc.getGson().fromJson(je, BreakpointResolved.class);
            handler.accept(parsed);
        };
        this.cdtc.registerEventHandler("Debugger.breakpointResolved", adapter);
        return () -> this.cdtc.unregisterEventHandler("Debugger.breakpointResolved", adapter);
    }

    public Unregisterer onPaused(Consumer<Paused> handler) {
        Consumer<JsonElement> adapter = je -> {
            Paused parsed = (Paused)this.cdtc.getGson().fromJson(je, Paused.class);
            handler.accept(parsed);
        };
        this.cdtc.registerEventHandler("Debugger.paused", adapter);
        return () -> this.cdtc.unregisterEventHandler("Debugger.paused", adapter);
    }

    public Unregisterer onResumed(Consumer<Resumed> handler) {
        Consumer<JsonElement> adapter = je -> {
            Resumed parsed = (Resumed)this.cdtc.getGson().fromJson(je, Resumed.class);
            handler.accept(parsed);
        };
        this.cdtc.registerEventHandler("Debugger.resumed", adapter);
        return () -> this.cdtc.unregisterEventHandler("Debugger.resumed", adapter);
    }

    public Unregisterer onScriptParsed(Consumer<ScriptParsed> scriptParsedHandler) {
        Consumer<JsonElement> adapter = je -> {
            ScriptParsed parsed = (ScriptParsed)this.cdtc.getGson().fromJson(je, ScriptParsed.class);
            scriptParsedHandler.accept(parsed);
        };
        this.cdtc.registerEventHandler("Debugger.scriptParsed", adapter);
        return () -> this.cdtc.unregisterEventHandler("Debugger.scriptParsed", adapter);
    }

    public Unregisterer onScriptFailedToParse(Consumer<ScriptFailedToParse> handler) {
        Consumer<JsonElement> adapter = je -> {
            ScriptFailedToParse parsed = (ScriptFailedToParse)this.cdtc.getGson().fromJson(je, ScriptFailedToParse.class);
            handler.accept(parsed);
        };
        this.cdtc.registerEventHandler("Debugger.scriptFailedToParse", adapter);
        return () -> this.cdtc.unregisterEventHandler("Debugger.scriptFailedToParse", adapter);
    }
}

