/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.netbeans.modules.docker.tls.DerParser;

public class Asn1Object {
    private static final int FLAG_CONSTRUCTED = 32;
    private static final int TYPE_INTEGER = 2;
    private static final int TYPE_MASK = 31;
    private final int tag;
    private final int type;
    private final byte[] value;

    public Asn1Object(int tag, byte[] value) {
        this.tag = tag;
        this.type = tag & 0x1F;
        this.value = value;
    }

    public DerParser read() throws IOException {
        if ((this.tag & 0x20) == 0) {
            throw new IOException("This object is not a constructed value");
        }
        return new DerParser(new ByteArrayInputStream(this.value));
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.type != 2) {
            throw new IOException("This object does not represent integer: " + this.type);
        }
        return new BigInteger(this.value);
    }
}

