/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

public class LinkedList<V> {
    private Element<V> head = null;
    private Element<V> tail = null;
    private Element<V> current = null;
    private int size = 0;

    public void addLast(V value) {
        if (this.tail == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            this.tail.next = new Element<V>(value, this.tail, null);
            this.tail = this.tail.next;
        }
        ++this.size;
    }

    public void addFirst(V value) {
        if (this.tail == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            this.head.previous = new Element<V>(value, null, this.head);
            this.head = this.tail.previous;
        }
        ++this.size;
    }

    public V removeLast() {
        if (this.tail == null) {
            return null;
        }
        Element<V> remove = this.tail;
        Object value = this.tail.value;
        if (this.tail.previous != null) {
            this.tail.previous.next = null;
        } else {
            this.head = null;
        }
        if (this.current == this.tail) {
            this.current = this.current.previous;
        }
        this.tail = this.tail.previous;
        remove.clear();
        --this.size;
        return value;
    }

    public V removeFirst() {
        if (this.head == null) {
            return null;
        }
        Element<V> remove = this.head;
        Object value = this.head.value;
        if (this.head.next != null) {
            this.head.next.previous = null;
        } else {
            this.tail = null;
        }
        if (this.current == this.head) {
            this.current = this.current.next;
        }
        this.head = this.head.next;
        remove.clear();
        --this.size;
        return value;
    }

    public void addNext(V value) {
        if (this.current == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            Element<V> add = new Element<V>(value, this.current, this.current.next);
            if (this.current.next != null) {
                this.current.next.previous = add;
            } else {
                this.tail = add;
            }
            this.current.next = add;
        }
        ++this.size;
    }

    public void addPrevious(V value) {
        if (this.current == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            Element<V> add = new Element<V>(value, this.current.previous, this.current);
            if (this.current.previous != null) {
                this.current.previous.next = add;
            } else {
                this.head = add;
            }
            this.current.previous = add;
        }
        ++this.size;
    }

    public V removeAndPrevious() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = this.current.value;
        if (remove.previous != null) {
            remove.previous.next = remove.next;
            this.current = remove.previous;
        } else {
            this.head = remove.next;
            this.current = null;
        }
        if (remove.next != null) {
            remove.next.previous = remove.previous;
        } else {
            this.tail = remove.previous;
        }
        remove.clear();
        --this.size;
        return value;
    }

    public V removeAndNext() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = this.current.value;
        if (remove.next != null) {
            remove.next.previous = remove.previous;
            this.current = remove.next;
        } else {
            this.tail = remove.previous;
            this.current = null;
        }
        if (remove.previous != null) {
            remove.previous.next = remove.next;
        } else {
            this.head = remove.next;
        }
        remove.clear();
        --this.size;
        return value;
    }

    public V removeAndPreviousOrNext() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = this.current.value;
        if (remove.previous != null) {
            remove.previous.next = remove.next;
            this.current = remove.previous;
        } else {
            this.head = remove.next;
            this.current = remove.next;
        }
        if (remove.next != null) {
            remove.next.previous = remove.previous;
        } else {
            this.tail = remove.previous;
        }
        remove.clear();
        --this.size;
        return value;
    }

    public V removeAndNextOrPrevious() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = this.current.value;
        if (remove.next != null) {
            remove.next.previous = remove.previous;
            this.current = remove.next;
        } else {
            this.tail = remove.previous;
            this.current = remove.previous;
        }
        if (remove.previous != null) {
            remove.previous.next = remove.next;
        } else {
            this.head = remove.next;
        }
        remove.clear();
        --this.size;
        return value;
    }

    public boolean first() {
        this.current = this.head;
        return this.current != null;
    }

    public boolean last() {
        this.current = this.tail;
        return this.current != null;
    }

    public boolean next() {
        if (this.current != null && this.current.next != null) {
            this.current = this.current.next;
            return true;
        }
        return false;
    }

    public boolean previous() {
        if (this.current != null && this.current.previous != null) {
            this.current = this.current.previous;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public boolean isCurrent() {
        return this.current != null;
    }

    public boolean isNext() {
        return this.current != null && this.current.next != null;
    }

    public boolean isPrevious() {
        return this.current != null && this.current.previous != null;
    }

    public int size() {
        return this.size;
    }

    public V getCurrent() {
        if (this.current != null) {
            return this.current.value;
        }
        return null;
    }

    public V getFirst() {
        if (this.head != null) {
            return this.head.value;
        }
        return null;
    }

    public V getLast() {
        if (this.tail != null) {
            return this.tail.value;
        }
        return null;
    }

    public V getNext() {
        if (this.current != null && this.current.next != null) {
            return this.current.next.value;
        }
        return null;
    }

    public V getPrevious() {
        if (this.current != null && this.current.previous != null) {
            return this.current.previous.value;
        }
        return null;
    }

    public String toString() {
        Element<V> element = this.head;
        StringBuilder sb = new StringBuilder("[");
        while (element != null) {
            sb.append(element.value != null ? element.value.toString() : "null");
            element = element.next;
            if (element == null) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    public void clear() {
        this.current = this.head;
        while (this.current != null) {
            Element<V> delete = this.current;
            this.current = this.current.next;
            delete.clear();
        }
        this.current = null;
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public static class Element<V> {
        private Element<V> previous;
        private Element<V> next;
        private V value;

        Element(V value) {
            this(value, null, null);
        }

        Element(V value, Element<V> previous, Element<V> next) {
            this.value = value;
            this.previous = previous;
            this.next = next;
        }

        void clear() {
            this.previous = null;
            this.next = null;
            this.value = null;
        }
    }
}

