/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Bundle;
import org.netbeans.modules.lsp.client.bindings.OccurrencesMarkProvider;
import org.netbeans.modules.lsp.client.options.MarkOccurencesSettings;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class MarkOccurrences
implements LSPBindings.BackgroundTask,
CaretListener,
PropertyChangeListener {
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private final JTextComponent component;
    private Document doc;
    private int caretPos;

    public MarkOccurrences(JTextComponent component) {
        this.component = component;
        this.doc = component.getDocument();
        Caret caret = component.getCaret();
        this.caretPos = caret != null ? caret.getDot() : -1;
        component.addCaretListener(this);
        component.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(LSPBindings bindings, FileObject file) {
        int localCaretPos;
        Document localDoc;
        MarkOccurrences markOccurrences = this;
        synchronized (markOccurrences) {
            localDoc = this.doc;
            localCaretPos = this.caretPos;
        }
        if (!MarkOccurencesSettings.getCurrentNode().getBoolean("OnOff", true)) {
            MarkOccurrences.getHighlightsBag(this.doc).setHighlights(HighlightsSequence.EMPTY);
            OccurrencesMarkProvider.get(this.doc).setOccurrences(this.doc, null, ES_COLOR, Bundle.LBL_ES_TOOLTIP());
            return;
        }
        List<int[]> highlights = this.computeHighlights(localDoc, localCaretPos);
        if (highlights != null && !highlights.isEmpty()) {
            AttributeSet attr = this.getColoring(localDoc);
            OffsetsBag occurrenesBag = new OffsetsBag(localDoc);
            highlights.forEach(h -> occurrenesBag.addHighlight(h[0], h[1], attr));
            MarkOccurrences.getHighlightsBag(localDoc).setHighlights(occurrenesBag);
            OccurrencesMarkProvider.get(localDoc).setOccurrences(localDoc, highlights, ES_COLOR, Bundle.LBL_ES_TOOLTIP());
        } else if (!MarkOccurencesSettings.getCurrentNode().getBoolean("KeepMarks", true)) {
            MarkOccurrences.getHighlightsBag(this.doc).setHighlights(HighlightsSequence.EMPTY);
            OccurrencesMarkProvider.get(this.doc).setOccurrences(this.doc, null, ES_COLOR, Bundle.LBL_ES_TOOLTIP());
        }
    }

    private List<int[]> computeHighlights(Document doc, int caretPos) {
        if (caretPos < 0) {
            return null;
        }
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return null;
        }
        LSPBindings server = LSPBindings.getBindings(file);
        if (server == null) {
            return null;
        }
        if (!Utils.isEnabled(server.getInitResult().getCapabilities().getDocumentHighlightProvider())) {
            return null;
        }
        String uri = Utils.toURI(file);
        try {
            List<? extends DocumentHighlight> highlights = server.getTextDocumentService().documentHighlight(new DocumentHighlightParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, caretPos))).get();
            if (highlights != null) {
                return highlights.stream().map(h -> new int[]{Utils.getOffset(doc, h.getRange().getStart()), Utils.getOffset(doc, h.getRange().getEnd())}).collect(Collectors.toList());
            }
            return null;
        }
        catch (InterruptedException | ExecutionException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private AttributeSet getColoring(Document doc) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)NbEditorUtilities.getMimeType((Document)doc)).lookup(FontColorSettings.class);
        if (fcs == null) {
            return AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[0]);
        }
        assert (fcs != null);
        return fcs.getTokenFontColors("mark-occurrences");
    }

    @Override
    public synchronized void caretUpdate(CaretEvent e) {
        this.caretPos = e != null ? e.getDot() : -1;
        FileObject file = NbEditorUtilities.getFileObject((Document)this.doc);
        if (file != null) {
            LSPBindings.rescheduleBackgroundTask(file, this);
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "document".equals(evt.getPropertyName())) {
            this.doc = this.component.getDocument();
        }
    }

    static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MarkOccurrences.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, false);
            doc.putProperty(MarkOccurrences.class, bag);
            Object stream = doc.getProperty("stream");
            final OffsetsBag bagFin = bag;
            DocumentListener l = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(l);
            if (stream instanceof DataObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "LSP Client MarkOccurrences Highlights Bag", new Object[]{((DataObject)stream).getPrimaryFile(), bag});
                Logger.getLogger("TIMER").log(Level.FINE, "LSP Client MarkOccurrences Highlights Bag Listener", new Object[]{((DataObject)stream).getPrimaryFile(), l});
            }
        }
        return bag;
    }

    public static class HighlightsLayerFactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)MarkOccurrences.class.getName(), (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(20), (boolean)true, (HighlightsContainer)MarkOccurrences.getHighlightsBag(context.getDocument()))};
        }
    }
}

