/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRemotePeeringConnectionRequest
extends BmcRequest<Void> {
    private String remotePeeringConnectionId;

    public String getRemotePeeringConnectionId() {
        return this.remotePeeringConnectionId;
    }

    public Builder toBuilder() {
        return new Builder().remotePeeringConnectionId(this.remotePeeringConnectionId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",remotePeeringConnectionId=").append(String.valueOf(this.remotePeeringConnectionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRemotePeeringConnectionRequest)) {
            return false;
        }
        GetRemotePeeringConnectionRequest other = (GetRemotePeeringConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.remotePeeringConnectionId, other.remotePeeringConnectionId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.remotePeeringConnectionId == null ? 43 : this.remotePeeringConnectionId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRemotePeeringConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String remotePeeringConnectionId = null;

        public Builder remotePeeringConnectionId(String remotePeeringConnectionId) {
            this.remotePeeringConnectionId = remotePeeringConnectionId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRemotePeeringConnectionRequest o) {
            this.remotePeeringConnectionId(o.getRemotePeeringConnectionId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRemotePeeringConnectionRequest build() {
            GetRemotePeeringConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRemotePeeringConnectionRequest buildWithoutInvocationCallback() {
            GetRemotePeeringConnectionRequest request = new GetRemotePeeringConnectionRequest();
            request.remotePeeringConnectionId = this.remotePeeringConnectionId;
            return request;
        }
    }
}

