/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCpeRequest
extends BmcRequest<Void> {
    private String cpeId;

    public String getCpeId() {
        return this.cpeId;
    }

    public Builder toBuilder() {
        return new Builder().cpeId(this.cpeId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cpeId=").append(String.valueOf(this.cpeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCpeRequest)) {
            return false;
        }
        GetCpeRequest other = (GetCpeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cpeId, other.cpeId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cpeId == null ? 43 : this.cpeId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCpeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cpeId = null;

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCpeRequest o) {
            this.cpeId(o.getCpeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCpeRequest build() {
            GetCpeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCpeRequest buildWithoutInvocationCallback() {
            GetCpeRequest request = new GetCpeRequest();
            request.cpeId = this.cpeId;
            return request;
        }
    }
}

