/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeCrossConnectCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeCrossConnectCompartmentRequest
extends BmcRequest<ChangeCrossConnectCompartmentDetails> {
    private String crossConnectId;
    private ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public ChangeCrossConnectCompartmentDetails getChangeCrossConnectCompartmentDetails() {
        return this.changeCrossConnectCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeCrossConnectCompartmentDetails getBody$() {
        return this.changeCrossConnectCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().crossConnectId(this.crossConnectId).changeCrossConnectCompartmentDetails(this.changeCrossConnectCompartmentDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",crossConnectId=").append(String.valueOf(this.crossConnectId));
        sb.append(",changeCrossConnectCompartmentDetails=").append(String.valueOf((Object)this.changeCrossConnectCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeCrossConnectCompartmentRequest)) {
            return false;
        }
        ChangeCrossConnectCompartmentRequest other = (ChangeCrossConnectCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.crossConnectId, other.crossConnectId) && Objects.equals((Object)this.changeCrossConnectCompartmentDetails, (Object)other.changeCrossConnectCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.crossConnectId == null ? 43 : this.crossConnectId.hashCode());
        result = result * 59 + (this.changeCrossConnectCompartmentDetails == null ? 43 : this.changeCrossConnectCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String crossConnectId = null;
        private ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            return this;
        }

        public Builder changeCrossConnectCompartmentDetails(ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails) {
            this.changeCrossConnectCompartmentDetails = changeCrossConnectCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeCrossConnectCompartmentRequest o) {
            this.crossConnectId(o.getCrossConnectId());
            this.changeCrossConnectCompartmentDetails(o.getChangeCrossConnectCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeCrossConnectCompartmentRequest build() {
            ChangeCrossConnectCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeCrossConnectCompartmentDetails body) {
            this.changeCrossConnectCompartmentDetails(body);
            return this;
        }

        public ChangeCrossConnectCompartmentRequest buildWithoutInvocationCallback() {
            ChangeCrossConnectCompartmentRequest request = new ChangeCrossConnectCompartmentRequest();
            request.crossConnectId = this.crossConnectId;
            request.changeCrossConnectCompartmentDetails = this.changeCrossConnectCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

