/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.JdbcUtils;

public class MSSQLDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Microsoft SQL Server";
    protected Set<String> systemTablesAndViews = new HashSet<String>();
    private static Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("(?im)^\\s*(CREATE|ALTER)\\s+VIEW\\s+(\\S+)\\s+?AS\\s*", 34);
    private Boolean sendsStringParametersAsUnicode = null;

    @Override
    public String getShortName() {
        return "mssql";
    }

    public MSSQLDatabase() {
        super.setCurrentDateTimeFunction("GETDATE()");
        this.sequenceNextValueFunction = "NEXT VALUE FOR %s";
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("syscomments");
        this.systemTablesAndViews.add("sysdepends");
        this.systemTablesAndViews.add("sysfilegroups");
        this.systemTablesAndViews.add("sysfiles");
        this.systemTablesAndViews.add("sysfiles1");
        this.systemTablesAndViews.add("sysforeignkeys");
        this.systemTablesAndViews.add("sysfulltextcatalogs");
        this.systemTablesAndViews.add("sysfulltextnotify");
        this.systemTablesAndViews.add("sysindexes");
        this.systemTablesAndViews.add("sysindexkeys");
        this.systemTablesAndViews.add("sysmembers");
        this.systemTablesAndViews.add("sysobjects");
        this.systemTablesAndViews.add("syspermissions");
        this.systemTablesAndViews.add("sysproperties");
        this.systemTablesAndViews.add("sysprotects");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("systypes");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("sysdiagrams");
        this.systemTablesAndViews.add("syssegments");
        this.systemTablesAndViews.add("sysconstraints");
        this.quotingStartCharacter = "[";
        this.quotingEndCharacter = "]";
        this.quotingEndReplacement = "]]";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "SQL Server";
    }

    @Override
    public Integer getDefaultPort() {
        return 1433;
    }

    @Override
    public Set<String> getSystemViews() {
        return this.systemTablesAndViews;
    }

    @Override
    protected Set<String> getSystemTables() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        try {
            if (this.isAzureDb()) {
                return false;
            }
            if (this.getDatabaseMajorVersion() >= 11) {
                return true;
            }
        }
        catch (DatabaseException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        String databaseProductName = conn.getDatabaseProductName();
        return PRODUCT_NAME.equalsIgnoreCase(databaseProductName) || "SQLOLEDB".equalsIgnoreCase(databaseProductName);
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sqlserver")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.startsWith("jdbc:jtds:sqlserver")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        return null;
    }

    @Override
    protected String getAutoIncrementClause() {
        return "IDENTITY";
    }

    @Override
    protected boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return true;
    }

    @Override
    protected boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return true;
    }

    @Override
    protected String getAutoIncrementStartWithClause() {
        return "%d";
    }

    @Override
    protected String getAutoIncrementByClause() {
        return "%d";
    }

    @Override
    public String getDefaultCatalogName() {
        if (this.getConnection() == null) {
            return null;
        }
        try {
            return this.getConnection().getCatalog();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    @Override
    protected String getConnectionSchemaNameCallStatement() {
        return "select schema_name()";
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" + ");
        }
        return returnString.toString().replaceFirst(" \\+ $", "");
    }

    @Override
    public String escapeTableName(String catalogName, String schemaName, String tableName) {
        return this.escapeObjectName(catalogName, schemaName, tableName, Table.class);
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean isSystemObject(DatabaseObject example) {
        if (example.getSchema() == null || example.getSchema().getName() == null) {
            return super.isSystemObject(example);
        }
        if (example instanceof Table && example.getSchema().getName().equals("sys")) {
            return true;
        }
        if (example instanceof View && example.getSchema().getName().equals("sys")) {
            return true;
        }
        return super.isSystemObject(example);
    }

    public String generateDefaultConstraintName(String tableName, String columnName) {
        return "DF_" + tableName + "_" + columnName;
    }

    @Override
    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null) {
            return null;
        }
        if (objectName.contains("(")) {
            return objectName;
        }
        return this.quoteObject(objectName, objectType);
    }

    @Override
    public String getDateLiteral(String isoDate) {
        return super.getDateLiteral(isoDate).replace(' ', 'T');
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public boolean supportsDropTableCascadeConstraints() {
        return false;
    }

    @Override
    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return Relation.class.isAssignableFrom(type);
    }

    @Override
    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        schema = schema.customize(this);
        List defLines = ExecutorService.getInstance().getExecutor(this).queryForList((SqlStatement)new GetViewDefinitionStatement(schema.getCatalogName(), schema.getSchemaName(), viewName), String.class);
        StringBuffer sb = new StringBuffer();
        for (String defLine : defLines) {
            sb.append(defLine);
        }
        String definition = sb.toString();
        String finalDef = definition.replaceAll("\\r\\n", "\n").trim();
        String selectOnly = CREATE_VIEW_AS_PATTERN.matcher(finalDef).replaceFirst("");
        if (selectOnly.equals(finalDef)) {
            return "FULL_DEFINITION: " + finalDef;
        }
        if ((selectOnly = selectOnly.trim()).startsWith("(") && (selectOnly.endsWith(")") || selectOnly.endsWith(");"))) {
            selectOnly = selectOnly.replaceFirst("^\\(", "");
            selectOnly = selectOnly.replaceFirst("\\);?$", "");
        }
        return selectOnly;
    }

    @Override
    public String escapeObjectName(String catalogName, String schemaName, String objectName, Class<? extends DatabaseObject> objectType) {
        if (View.class.isAssignableFrom(objectType)) {
            String name = this.escapeObjectName(objectName, objectType);
            if (schemaName != null) {
                name = this.escapeObjectName(schemaName, Schema.class) + "." + name;
            }
            return name;
        }
        if (Index.class.isAssignableFrom(objectType)) {
            return super.escapeObjectName(objectName, objectType);
        }
        if (catalogName != null && !catalogName.equalsIgnoreCase(this.getDefaultCatalogName())) {
            return super.escapeObjectName(catalogName, schemaName, objectName, objectType);
        }
        String name = this.escapeObjectName(objectName, objectType);
        if (schemaName != null) {
            name = this.escapeObjectName(schemaName, Schema.class) + "." + name;
        }
        return name;
    }

    @Override
    public String getJdbcSchemaName(CatalogAndSchema schema) {
        String schemaName = super.getJdbcSchemaName(schema);
        if (schemaName != null && !this.isCaseSensitive()) {
            schemaName = schemaName.toLowerCase();
        }
        return schemaName;
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.caseSensitive == null) {
            try {
                if (this.getConnection() instanceof JdbcConnection) {
                    String catalog = this.getConnection().getCatalog();
                    String sql = "SELECT CONVERT([sysname], DATABASEPROPERTYEX(N'" + this.escapeStringForDatabase(catalog) + "', 'Collation'))";
                    String collation = ExecutorService.getInstance().getExecutor(this).queryForObject(new RawSqlStatement(sql), String.class);
                    this.caseSensitive = collation != null && !collation.contains("_CI_");
                } else if (this.getConnection() instanceof OfflineConnection) {
                    this.caseSensitive = ((OfflineConnection)this.getConnection()).isCaseSensitive();
                }
            }
            catch (Exception e) {
                LogFactory.getLogger().warning("Cannot determine case sensitivity from MSSQL", e);
            }
        }
        return this.caseSensitive != null && this.caseSensitive != false;
    }

    @Override
    public int getDataTypeMaxParameters(String dataTypeName) {
        if ("bigint".equalsIgnoreCase(dataTypeName) || "bit".equalsIgnoreCase(dataTypeName) || "date".equalsIgnoreCase(dataTypeName) || "datetime".equalsIgnoreCase(dataTypeName) || "geography".equalsIgnoreCase(dataTypeName) || "geometry".equalsIgnoreCase(dataTypeName) || "hierarchyid".equalsIgnoreCase(dataTypeName) || "image".equalsIgnoreCase(dataTypeName) || "int".equalsIgnoreCase(dataTypeName) || "money".equalsIgnoreCase(dataTypeName) || "ntext".equalsIgnoreCase(dataTypeName) || "real".equalsIgnoreCase(dataTypeName) || "smalldatetime".equalsIgnoreCase(dataTypeName) || "smallint".equalsIgnoreCase(dataTypeName) || "smallmoney".equalsIgnoreCase(dataTypeName) || "text".equalsIgnoreCase(dataTypeName) || "timestamp".equalsIgnoreCase(dataTypeName) || "tinyint".equalsIgnoreCase(dataTypeName) || "rowversion".equalsIgnoreCase(dataTypeName) || "sql_variant".equalsIgnoreCase(dataTypeName) || "sysname".equalsIgnoreCase(dataTypeName) || "uniqueidentifier".equalsIgnoreCase(dataTypeName)) {
            return 0;
        }
        if ("binary".equalsIgnoreCase(dataTypeName) || "char".equalsIgnoreCase(dataTypeName) || "datetime2".equalsIgnoreCase(dataTypeName) || "datetimeoffset".equalsIgnoreCase(dataTypeName) || "float".equalsIgnoreCase(dataTypeName) || "nchar".equalsIgnoreCase(dataTypeName) || "nvarchar".equalsIgnoreCase(dataTypeName) || "time".equalsIgnoreCase(dataTypeName) || "varbinary".equalsIgnoreCase(dataTypeName) || "varchar".equalsIgnoreCase(dataTypeName) || "xml".equalsIgnoreCase(dataTypeName)) {
            return 1;
        }
        return 2;
    }

    @Override
    public String escapeDataTypeName(String dataTypeName) {
        int indexOfPeriod = dataTypeName.indexOf(46);
        if (indexOfPeriod < 0) {
            if (!dataTypeName.startsWith(this.quotingStartCharacter)) {
                dataTypeName = this.escapeObjectName(dataTypeName, DatabaseObject.class);
            }
            return dataTypeName;
        }
        String schemaName = dataTypeName.substring(0, indexOfPeriod);
        if (!schemaName.startsWith(this.quotingStartCharacter)) {
            schemaName = this.escapeObjectName(schemaName, Schema.class);
        }
        if (!(dataTypeName = dataTypeName.substring(indexOfPeriod + 1, dataTypeName.length())).startsWith(this.quotingStartCharacter)) {
            dataTypeName = this.escapeObjectName(dataTypeName, DatabaseObject.class);
        }
        return schemaName + "." + dataTypeName;
    }

    @Override
    public String unescapeDataTypeName(String dataTypeName) {
        int indexOfPeriod = dataTypeName.indexOf(46);
        if (indexOfPeriod < 0) {
            if (dataTypeName.matches("\\[[^]\\[]++\\]")) {
                dataTypeName = dataTypeName.substring(1, dataTypeName.length() - 1);
            }
            return dataTypeName;
        }
        String schemaName = dataTypeName.substring(0, indexOfPeriod);
        if (schemaName.matches("\\[[^]\\[]++\\]")) {
            schemaName = schemaName.substring(1, schemaName.length() - 1);
        }
        if ((dataTypeName = dataTypeName.substring(indexOfPeriod + 1, dataTypeName.length())).matches("\\[[^]\\[]++\\]")) {
            dataTypeName = dataTypeName.substring(1, dataTypeName.length() - 1);
        }
        return schemaName + "." + dataTypeName;
    }

    @Override
    public String unescapeDataTypeString(String dataTypeString) {
        int indexOfLeftParen = dataTypeString.indexOf(40);
        if (indexOfLeftParen < 0) {
            return this.unescapeDataTypeName(dataTypeString);
        }
        return this.unescapeDataTypeName(dataTypeString.substring(0, indexOfLeftParen)) + dataTypeString.substring(indexOfLeftParen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendsStringParametersAsUnicode() {
        block8: {
            if (this.sendsStringParametersAsUnicode == null) {
                try {
                    if (this.getConnection() instanceof JdbcConnection) {
                        PreparedStatement ps = null;
                        ResultSet rs = null;
                        try {
                            String sql = "SELECT CONVERT([sysname], SQL_VARIANT_PROPERTY(?, 'BaseType'))";
                            ps = ((JdbcConnection)this.getConnection()).prepareStatement(sql);
                            ps.setString(1, "Liquibase");
                            rs = ps.executeQuery();
                            String baseType = null;
                            if (rs.next()) {
                                baseType = rs.getString(1);
                            }
                            this.sendsStringParametersAsUnicode = baseType == null || baseType.startsWith("n");
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.close(rs, ps);
                            throw throwable;
                        }
                        JdbcUtils.close(rs, ps);
                        break block8;
                    }
                    if (this.getConnection() instanceof OfflineConnection) {
                        this.sendsStringParametersAsUnicode = ((OfflineConnection)this.getConnection()).getSendsStringParametersAsUnicode();
                    }
                }
                catch (Exception e) {
                    LogFactory.getLogger().warning("Cannot determine whether String parameters are sent as Unicode for MSSQL", e);
                }
            }
        }
        return this.sendsStringParametersAsUnicode == null ? true : this.sendsStringParametersAsUnicode;
    }

    public boolean isAzureDb() {
        return "Azure".equalsIgnoreCase(this.getEngineEdition());
    }

    public String getEngineEdition() {
        try {
            if (this.getConnection() instanceof JdbcConnection) {
                String sql = "SELECT CASE ServerProperty('EngineEdition')\n         WHEN 1 THEN 'Personal'\n         WHEN 2 THEN 'Standard'\n         WHEN 3 THEN 'Enterprise'\n         WHEN 4 THEN 'Express'\n         WHEN 5 THEN 'Azure'\n         ELSE 'Unknown'\n       END";
                return ExecutorService.getInstance().getExecutor(this).queryForObject(new RawSqlStatement(sql), String.class);
            }
        }
        catch (DatabaseException e) {
            LogFactory.getLogger().warning("Could not determine engine edition", e);
        }
        return "Unknown";
    }
}

