/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.definition;

import io.quarkus.deployment.configuration.definition.Definition;
import io.quarkus.deployment.configuration.definition.GroupDefinition;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.util.StringUtil;
import io.smallrye.common.constraint.Assert;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ClassDefinition
extends Definition {
    private final Class<?> configurationClass;
    private final Map<String, ClassMember> members;

    ClassDefinition(Builder builder) {
        Class<?> configurationClass = builder.configurationClass;
        if (configurationClass == null) {
            throw new IllegalArgumentException("No configuration class given");
        }
        this.configurationClass = configurationClass;
        LinkedHashMap<String, ClassMember> map = new LinkedHashMap<String, ClassMember>(builder.members.size());
        for (Map.Entry<String, ClassMember.Specification> entry : builder.members.entrySet()) {
            map.put(entry.getKey(), entry.getValue().construct(this));
        }
        this.members = Collections.unmodifiableMap(map);
    }

    public final int getMemberCount() {
        return this.members.size();
    }

    public final Iterable<String> getMemberNames() {
        return this.members.keySet();
    }

    public final Iterable<ClassMember> getMembers() {
        return this.members.values();
    }

    public Class<?> getConfigurationClass() {
        return this.configurationClass;
    }

    public final ClassMember getMember(String name) {
        ClassMember member = this.members.get(name);
        if (member == null) {
            throw new IllegalArgumentException("No member named \"" + name + "\" is present on " + String.valueOf(this.configurationClass));
        }
        return member;
    }

    public static abstract class Builder
    extends Definition.Builder {
        private Class<?> configurationClass;
        private final Map<String, ClassMember.Specification> members = new LinkedHashMap<String, ClassMember.Specification>();

        Builder() {
        }

        public Builder setConfigurationClass(Class<?> configurationClass) {
            this.configurationClass = configurationClass;
            return this;
        }

        public Class<?> getConfigurationClass() {
            return this.configurationClass;
        }

        public void addMember(ClassMember.Specification spec) {
            Assert.checkNotNullParam((String)"spec", (Object)spec);
            this.members.put(spec.getField().getName(), spec);
        }

        @Override
        public abstract ClassDefinition build();
    }

    public static abstract class ClassMember
    extends Definition.Member {
        @Override
        public abstract ClassDefinition getEnclosingDefinition();

        public final String getName() {
            return this.getField().getName();
        }

        public abstract Field getField();

        public abstract FieldDescriptor getDescriptor();

        public abstract String getPropertyName();

        public static abstract class Specification {
            Specification() {
            }

            abstract Field getField();

            abstract ClassMember construct(ClassDefinition var1);
        }
    }

    public static final class MapMember
    extends ClassMember {
        private final ClassMember nested;

        MapMember(ClassMember nested) {
            this.nested = nested;
        }

        public ClassMember getNested() {
            return this.nested;
        }

        @Override
        public ClassDefinition getEnclosingDefinition() {
            return this.nested.getEnclosingDefinition();
        }

        @Override
        public Field getField() {
            return this.nested.getField();
        }

        @Override
        public FieldDescriptor getDescriptor() {
            return this.nested.getDescriptor();
        }

        @Override
        public String getPropertyName() {
            return this.nested.getPropertyName();
        }

        public static final class Specification
        extends ClassMember.Specification {
            private final ClassMember.Specification nested;

            public Specification(ClassMember.Specification nested) {
                this.nested = (ClassMember.Specification)Assert.checkNotNullParam((String)"nested", (Object)nested);
            }

            @Override
            Field getField() {
                return this.nested.getField();
            }

            @Override
            ClassMember construct(ClassDefinition enclosing) {
                return new MapMember(this.nested.construct(enclosing));
            }
        }
    }

    public static final class ItemMember
    extends LeafMember {
        private final String defaultValue;

        ItemMember(ClassDefinition classDefinition, Field field, String defaultValue) {
            super(classDefinition, field);
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public static final class Specification
        extends LeafMember.Specification {
            private final String defaultValue;

            public Specification(Field field, String defaultValue) {
                super(field);
                this.defaultValue = defaultValue;
            }

            @Override
            ClassMember construct(ClassDefinition enclosing) {
                return new ItemMember(enclosing, this.field, this.defaultValue);
            }
        }
    }

    public static final class GroupMember
    extends LeafMember {
        private final GroupDefinition groupDefinition;
        private final boolean optional;

        GroupMember(ClassDefinition classDefinition, Field field, GroupDefinition groupDefinition, boolean optional) {
            super(classDefinition, field);
            this.groupDefinition = groupDefinition;
            this.optional = optional;
        }

        public GroupDefinition getGroupDefinition() {
            return this.groupDefinition;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public static final class Specification
        extends LeafMember.Specification {
            private final GroupDefinition groupDefinition;
            private final boolean optional;

            public Specification(Field field, GroupDefinition groupDefinition, boolean optional) {
                super(field);
                this.groupDefinition = (GroupDefinition)Assert.checkNotNullParam((String)"groupDefinition", (Object)groupDefinition);
                this.optional = optional;
            }

            public boolean isOptional() {
                return this.optional;
            }

            @Override
            ClassMember construct(ClassDefinition enclosing) {
                return new GroupMember(enclosing, this.field, this.groupDefinition, this.optional);
            }
        }
    }

    static abstract class LeafMember
    extends ClassMember {
        private final ClassDefinition classDefinition;
        private final Field field;
        private final FieldDescriptor descriptor;
        private final String propertyName;

        LeafMember(ClassDefinition classDefinition, Field field) {
            this.classDefinition = (ClassDefinition)Assert.checkNotNullParam((String)"classDefinition", (Object)classDefinition);
            this.field = (Field)Assert.checkNotNullParam((String)"field", (Object)field);
            Class<?> declaringClass = field.getDeclaringClass();
            Class<?> configurationClass = classDefinition.configurationClass;
            if (!declaringClass.isAssignableFrom(configurationClass)) {
                throw new IllegalArgumentException("Member declaring " + String.valueOf(declaringClass) + " does not match configuration " + String.valueOf(configurationClass));
            }
            this.descriptor = FieldDescriptor.of((Field)field);
            ConfigItem configItem = field.getAnnotation(ConfigItem.class);
            String propertyName = "<<hyphenated element name>>";
            if (configItem != null && (propertyName = configItem.name()).isEmpty()) {
                throw Definition.reportError(field, "Invalid empty property name");
            }
            this.propertyName = propertyName.equals("<<hyphenated element name>>") ? StringUtil.hyphenate((String)field.getName()) : (propertyName.equals("<<element name>>") ? field.getName() : (propertyName.equals("<<parent>>") ? "" : propertyName));
        }

        @Override
        public Field getField() {
            return this.field;
        }

        @Override
        public FieldDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public ClassDefinition getEnclosingDefinition() {
            return this.classDefinition;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        public static abstract class Specification
        extends ClassMember.Specification {
            final Field field;

            Specification(Field field) {
                this.field = (Field)Assert.checkNotNullParam((String)"field", (Object)field);
            }

            @Override
            Field getField() {
                return this.field;
            }
        }
    }
}

