/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class CBProperties
extends Properties {
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public CBProperties(Properties props) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = props.get(key);
            this.put(key, val);
        }
    }

    public Enumeration keys() {
        Vector<String> sortedKeys = new Vector<String>();
        Enumeration<Object> baseKeys = super.keys();
        while (baseKeys.hasMoreElements()) {
            String key = (String)baseKeys.nextElement();
            sortedKeys.addElement(key);
        }
        Collections.sort(sortedKeys);
        for (int i = 1; i < sortedKeys.size(); ++i) {
            String key = (String)sortedKeys.get(i);
            if (!key.endsWith(".comment")) continue;
            String newkey = "#" + key.substring(0, key.length() - 8);
            String value = super.getProperty(key);
            super.remove(key);
            super.setProperty(newkey, value);
            String previousKey = (String)sortedKeys.get(i - 1);
            if (key.startsWith(previousKey)) {
                sortedKeys.set(i - 1, newkey);
                sortedKeys.set(i, previousKey);
                continue;
            }
            sortedKeys.set(i, newkey);
        }
        return sortedKeys.elements();
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            CBProperties.writeln(awriter, "#" + header);
        }
        CBProperties.writeln(awriter, "#" + new Date().toString());
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.get(key);
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            if (key.charAt(0) == '#') {
                CBProperties.writeln(awriter, "");
                CBProperties.writeln(awriter, key + "  " + val);
                continue;
            }
            CBProperties.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block9: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block9;
                }
                case '#': {
                    if (x != 0) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append('#');
                    continue block9;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block9;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block9;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block9;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block9;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block9;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(CBProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(CBProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(CBProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(CBProperties.toHex(aChar & 0xF));
                        continue block9;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

