/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridEditorPanel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.grid.GridEditorPanelBase;
import com.intellij.grid.core.impl.icons.GridCoreImplIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSortingPanel
extends GridEditorPanelBase {
    private final GridSortingModel<GridRow, GridColumn> mySortingModel;
    private JBPopup myFilterHistoryPopup;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    GridSortingPanel(@NotNull Project project, final @NotNull DataGrid grid, @NotNull GridSortingModel<GridRow, GridColumn> sortingModel, @NotNull Document document) {
        if (project == null) {
            GridSortingPanel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridSortingPanel.$$$reportNull$$$0(1);
        }
        if (sortingModel == null) {
            GridSortingPanel.$$$reportNull$$$0(2);
        }
        if (document == null) {
            GridSortingPanel.$$$reportNull$$$0(3);
        }
        super(project, grid, grid.getDataHookup().getSortingPrefix(), grid.getDataHookup().getSortingEmptyText(), document);
        this.mySortingModel = sortingModel;
        sortingModel.addListener(new GridSortingModel.Listener(){

            public void onPsiUpdated() {
                GridSortingPanel.this.setHighlighter();
            }

            public void onPrefixUpdated() {
                GridSortingPanel.this.updatePrefix(grid.getDataHookup().getSortingPrefix(), grid.getDataHookup().getSortingEmptyText());
            }
        }, (Disposable)this.myGrid);
        @NotNull @Nullable Function getPanel = g -> g.getFilterComponent().getSortingPanel();
        new GridEditorPanelBase.ApplyAction((Function<DataGrid, GridEditorPanel>)getPanel).registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getComponent());
        new GridEditorPanelBase.CancelAction((Function<DataGrid, GridEditorPanel>)getPanel).registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.myEditor.getComponent());
        new GridEditorPanelBase.ShowHistoryAction((Function<DataGrid, GridEditorPanel>)getPanel).registerCustomShortcutSet((ShortcutSet)GridSortingPanel.getShowHistoryShortcut(), this.myEditor.getComponent());
        this.add((Component)((Object)new GridEditorPanelBase.HistoryIcon(GridCoreImplIcons.SortHistory)), "West");
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, -1);
    }

    @Override
    void clearText() {
        boolean wasApplied = this.mySortingModel != null && !this.mySortingModel.getAppliedSortingText().isEmpty();
        ApplicationManager.getApplication().runWriteAction(() -> this.myEditor.getDocument().setText((CharSequence)""));
        if (wasApplied) {
            this.apply();
        }
    }

    @Override
    @NlsContexts.PopupContent
    @NotNull
    public String getInvalidTextErrorMessage() {
        String string = DataGridBundle.message((String)"popup.content.invalid.table.sorting", (Object[])new Object[0]);
        if (string == null) {
            GridSortingPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void showHistoryPopup() {
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        this.myFilterHistoryPopup = GridSortingPanel.createHistoryPopup(this.mySortingModel.getHistory(), this.myProject, (Editor)this.myEditor, () -> this.apply());
        this.myFilterHistoryPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                GridSortingPanel.this.myFilterHistoryPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridSortingPanel$2", "onClosed"));
            }
        });
        if (this.myGrid.getPanel().getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)this);
        }
    }

    @Override
    public void apply() {
        super.apply();
        GridUtil.activeGridListener().onSortingApplied(this.myGrid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridSortingPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridSortingPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidTextErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

