/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.MapEntry;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterable;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterator;
import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Paired;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderedMultiMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    @NotNull
    private final OrderedSet<K> keySet;
    @NotNull
    private final OrderedSet<V> valueSet;
    @Nullable
    private final CollectionHost<Paired<K, V>> host;
    boolean isInKeyUpdate;
    boolean isInValueUpdate;
    @Nullable
    private Indexed<Map.Entry<K, V>> indexedProxy;

    public OrderedMultiMap() {
        this(0, null);
    }

    public OrderedMultiMap(int capacity) {
        this(capacity, null);
    }

    public OrderedMultiMap(@NotNull CollectionHost<Paired<K, V>> host) {
        this(0, host);
    }

    public OrderedMultiMap(int capacity, @Nullable CollectionHost<Paired<K, V>> host) {
        this.host = host;
        this.indexedProxy = null;
        this.valueSet = new OrderedSet(capacity, new CollectionHost<V>(){

            @Override
            public void adding(int index, @Nullable V v, @Nullable Object k) {
                OrderedMultiMap.this.addingValue(index, v, k);
            }

            @Override
            public Object removing(int index, @Nullable V v) {
                return OrderedMultiMap.this.removingValue(index, v);
            }

            @Override
            public void clearing() {
                OrderedMultiMap.this.clear();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMultiMap.this.addingNullValue(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMultiMap.this.isInKeyUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        });
        this.keySet = new OrderedSet(capacity, new CollectionHost<K>(){

            @Override
            public void adding(int index, @Nullable K k, @Nullable Object v) {
                OrderedMultiMap.this.addingKey(index, k, v);
            }

            @Override
            public Object removing(int index, @Nullable K k) {
                return OrderedMultiMap.this.removingKey(index, k);
            }

            @Override
            public void clearing() {
                OrderedMultiMap.this.clear();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMultiMap.this.addingNullKey(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMultiMap.this.isInValueUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        });
    }

    public Indexed<Map.Entry<K, V>> getIndexedProxy() {
        if (this.indexedProxy != null) {
            return this.indexedProxy;
        }
        this.indexedProxy = new Indexed<Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> get(int index) {
                return OrderedMultiMap.this.getEntry(index);
            }

            @Override
            public void set(int index, Map.Entry<K, V> item) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAt(int index) {
                OrderedMultiMap.this.removeEntryIndex(index);
            }

            @Override
            public int size() {
                return OrderedMultiMap.this.size();
            }

            @Override
            public int modificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        };
        return this.indexedProxy;
    }

    Map.Entry<K, V> getEntry(int index) {
        return new MapEntry<K, V>(this.keySet.getValueOrNull(index), this.valueSet.getValueOrNull(index));
    }

    public int getModificationCount() {
        return (int)((long)this.keySet.getModificationCount() + (long)this.valueSet.getModificationCount());
    }

    void addingKey(int index, @Nullable K k, @Nullable Object v) {
        assert (!this.isInValueUpdate);
        this.isInValueUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.adding(index, new Pair<K, Object>(k, v), null);
        }
        if (v == null) {
            this.valueSet.addNulls(index);
        } else {
            this.valueSet.add(v);
        }
        this.isInValueUpdate = false;
    }

    void addingNullKey(int index) {
        assert (!this.isInValueUpdate);
        this.isInValueUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.addingNulls(index);
        }
        while (this.valueSet().size() <= index) {
            this.valueSet.add(null);
        }
        this.isInValueUpdate = false;
    }

    Object removingKey(int index, @Nullable K k) {
        assert (!this.isInValueUpdate);
        this.isInValueUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.removing(index, new Pair<K, Object>(k, null));
        }
        Object r = this.valueSet.removeIndexHosted(index);
        this.isInValueUpdate = false;
        return r;
    }

    void addingValue(int index, @Nullable V v, @Nullable Object k) {
        assert (!this.isInKeyUpdate);
        this.isInKeyUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.adding(index, new Pair<Object, V>(k, v), null);
        }
        if (k == null) {
            this.keySet.addNulls(index);
        } else {
            this.keySet.add(k);
        }
        this.isInKeyUpdate = false;
    }

    void addingNullValue(int index) {
        assert (!this.isInKeyUpdate);
        this.isInKeyUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.addingNulls(index);
        }
        while (this.keySet.size() <= index) {
            this.keySet.add(null);
        }
        this.isInKeyUpdate = false;
    }

    Object removingValue(int index, @Nullable V v) {
        assert (!this.isInKeyUpdate);
        this.isInKeyUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.removing(index, new Pair<Object, V>(null, v));
        }
        Object r = this.keySet.removeIndexHosted(index);
        this.isInKeyUpdate = false;
        return r;
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        return this.keySet.contains(o);
    }

    @Override
    public boolean containsValue(@Nullable Object o) {
        int index = this.valueSet.indexOf(o);
        return this.keySet.isValidIndex(index);
    }

    @Override
    @Nullable
    public V get(@Nullable Object o) {
        return this.getKeyValue(o);
    }

    @Nullable
    public V getKeyValue(@Nullable Object o) {
        int index = this.keySet.indexOf(o);
        return index == -1 ? null : (V)this.valueSet.getValue(index);
    }

    @Nullable
    public K getValueKey(@Nullable Object o) {
        int index = this.valueSet.indexOf(o);
        return index == -1 ? null : (K)this.keySet.getValue(index);
    }

    @Override
    @Nullable
    public V put(@Nullable K k, @Nullable V v) {
        return this.putKeyValue(k, v);
    }

    public void addNullEntry(int index) {
        this.isInKeyUpdate = true;
        this.isInValueUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.addingNulls(index);
        }
        this.keySet.addNulls(index);
        this.valueSet.addNulls(index);
        this.isInValueUpdate = false;
        this.isInKeyUpdate = false;
    }

    public boolean putEntry(@NotNull Map.Entry<K, V> e) {
        return this.addKeyValue(e.getKey(), e.getValue());
    }

    public boolean putKeyValueEntry(@NotNull Map.Entry<K, V> e) {
        return this.addKeyValue(e.getKey(), e.getValue());
    }

    public boolean putValueKeyEntry(@NotNull Map.Entry<V, K> e) {
        return this.addKeyValue(e.getValue(), e.getKey());
    }

    public boolean putKeyValuePair(@NotNull Paired<K, V> e) {
        return this.addKeyValue(e.getFirst(), e.getSecond());
    }

    public boolean putValueKeyPair(@NotNull Paired<V, K> e) {
        return this.addKeyValue(e.getSecond(), e.getFirst());
    }

    public V putKeyValue(@Nullable K k, @Nullable V v) {
        return (V)(!this.addKeyValue(k, v) ? v : null);
    }

    public K putValueKey(@Nullable V v, @Nullable K k) {
        return (K)(!this.addKeyValue(k, v) ? k : null);
    }

    private boolean addKeyValue(@Nullable K k, @Nullable V v) {
        int keyIndex = this.keySet.indexOf(k);
        int valueIndex = this.valueSet.indexOf(v);
        if (keyIndex == -1 && valueIndex == -1) {
            this.isInKeyUpdate = true;
            this.isInValueUpdate = true;
            if (this.host != null && !this.host.skipHostUpdate()) {
                this.host.adding(this.keySet.getValueList().size(), new Pair<K, V>(k, v), null);
            }
            if (k == null) {
                this.keySet.addNull();
            } else {
                this.keySet.add(k, v);
            }
            if (k == null) {
                this.valueSet.addNull();
            } else {
                this.valueSet.add(v, k);
            }
            this.isInValueUpdate = false;
            this.isInKeyUpdate = false;
            return true;
        }
        if (keyIndex == -1) {
            this.isInKeyUpdate = true;
            this.isInValueUpdate = true;
            if (this.host != null && !this.host.skipHostUpdate()) {
                this.host.adding(valueIndex, new Pair<K, V>(k, v), null);
            }
            if (k == null) {
                this.keySet.removeIndex(valueIndex);
            } else {
                this.keySet.setValueAt(valueIndex, k, v);
            }
            this.isInValueUpdate = false;
            this.isInKeyUpdate = false;
            return true;
        }
        if (valueIndex == -1) {
            this.isInKeyUpdate = true;
            this.isInValueUpdate = true;
            if (this.host != null && !this.host.skipHostUpdate()) {
                this.host.adding(keyIndex, new Pair<K, V>(k, v), null);
            }
            if (k == null) {
                this.valueSet.removeIndex(valueIndex);
            } else {
                this.valueSet.setValueAt(keyIndex, v, k);
            }
            this.isInValueUpdate = false;
            return true;
        }
        if (valueIndex != keyIndex) {
            throw new IllegalStateException("keySet[" + keyIndex + "]=" + k + " and valueSet[" + valueIndex + "]=" + v + " are out of sync");
        }
        return false;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object o) {
        return this.removeKey(o);
    }

    @Nullable
    public Map.Entry<K, V> removeEntry(@NotNull Map.Entry<K, V> e) {
        boolean b = this.removeEntryIndex(-1, e.getKey(), e.getValue());
        return b ? e : null;
    }

    boolean removeEntryIndex(int index) {
        return this.removeEntryIndex(index, this.keySet.getValueOrNull(index), this.valueSet.getValueOrNull(index));
    }

    private boolean removeEntryIndex(int index, @Nullable K k, @Nullable V v) {
        int valueIndex;
        int keyIndex = this.keySet.indexOf(k);
        if (keyIndex != (valueIndex = this.valueSet.indexOf(v))) {
            throw new IllegalStateException("keySet[" + keyIndex + "]=" + k + " and valueSet[" + valueIndex + "]=" + v + " are out of sync");
        }
        if (index != -1 && keyIndex != index) {
            throw new IllegalStateException("removeEntryIndex " + index + " does not match keySet[" + keyIndex + "]=" + k + " and valueSet[" + valueIndex + "]=" + v + " are out of sync");
        }
        if (keyIndex != -1) {
            this.isInKeyUpdate = true;
            this.isInValueUpdate = true;
            if (this.host != null && !this.host.skipHostUpdate()) {
                this.host.removing(keyIndex, new Pair<K, V>(k, v));
            }
            this.keySet.removeHosted(k);
            this.valueSet.removeHosted(v);
            this.isInValueUpdate = false;
            this.isInKeyUpdate = false;
            return true;
        }
        return false;
    }

    public V removeKey(Object o) {
        int index;
        this.isInKeyUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate() && (index = this.keySet.indexOf(o)) != -1) {
            this.host.removing(index, new Pair<Object, Object>(o, (this.valueSet.isValidIndex(index) ? (Object)this.valueSet.getValue(index) : null)));
        }
        Object r = this.keySet.removeHosted(o);
        this.isInKeyUpdate = false;
        return (V)r;
    }

    public K removeValue(Object o) {
        this.isInValueUpdate = true;
        int index = this.valueSet.indexOf(o);
        if (this.host != null && !this.host.skipHostUpdate() && index != -1) {
            this.host.removing(index, new Pair<Object, Object>((this.keySet.isValidIndex(index) ? (Object)this.keySet.getValue(index) : null), o));
        }
        Object r = this.valueSet.removeHosted(o);
        this.isInValueUpdate = false;
        return (K)r;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.putAllKeyValues(map);
    }

    public void putAllKeyValues(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAllValueKeys(Map<? extends V, ? extends K> map) {
        for (Map.Entry<V, K> entry : map.entrySet()) {
            this.putValueKey(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.isInValueUpdate = true;
        this.isInKeyUpdate = true;
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.clearing();
        }
        this.keySet.clear();
        this.valueSet.clear();
        this.isInKeyUpdate = false;
        this.isInValueUpdate = false;
    }

    @Override
    @NotNull
    public OrderedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (!this.keySet.isSparse()) {
            return this.valueSet;
        }
        ArrayList<V> values = new ArrayList<V>(this.keySet.size());
        values.addAll(this.valueSet);
        return values;
    }

    public OrderedSet<V> valueSet() {
        return this.valueSet;
    }

    public Collection<K> keys() {
        if (!this.keySet.isSparse()) {
            return this.keySet;
        }
        ArrayList<K> values = new ArrayList<K>(this.valueSet.size());
        values.addAll(this.keySet);
        return values;
    }

    public K getKey(int index) {
        if (!this.keySet.isValidIndex(index)) {
            return null;
        }
        return this.keySet.getValueList().get(index);
    }

    public V getValue(int index) {
        if (!this.valueSet.isValidIndex(index)) {
            return null;
        }
        return this.valueSet.getValue(index);
    }

    @Override
    @NotNull
    public OrderedSet<Map.Entry<K, V>> entrySet() {
        return this.keyValueEntrySet();
    }

    public ReversibleIndexedIterator<V> valueIterator() {
        return this.valueSet.iterator();
    }

    public ReversibleIndexedIterator<V> reversedValueIterator() {
        return this.valueSet.reversedIterator();
    }

    public ReversibleIterable<V> valueIterable() {
        return new IndexedIterable(this.valueSet.getIndexedProxy(), this.valueSet.indexIterable());
    }

    public ReversibleIterable<V> reversedValueIterable() {
        return new IndexedIterable(this.valueSet.getIndexedProxy(), this.valueSet.reversedIndexIterable());
    }

    public ReversibleIndexedIterator<K> keyIterator() {
        return ((OrderedSet)this.keySet()).iterator();
    }

    public ReversibleIndexedIterator<K> reversedKeyIterator() {
        return ((OrderedSet)this.keySet()).reversedIterator();
    }

    public ReversibleIterable<K> keyIterable() {
        return new IndexedIterable(this.keySet.getIndexedProxy(), this.keySet.indexIterable());
    }

    public ReversibleIterable<K> reversedKeyIterable() {
        return new IndexedIterable(this.keySet.getIndexedProxy(), this.keySet.reversedIndexIterable());
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> entrySetIterator() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterator(this.getIndexedProxy(), new BitSetIterator(bitSet));
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> reversedEntrySetIterator() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterator(this.getIndexedProxy(), new BitSetIterator(bitSet, true));
    }

    public ReversibleIterable<Map.Entry<K, V>> entrySetIterable() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterable(this.getIndexedProxy(), new BitSetIterable(bitSet));
    }

    public ReversibleIterable<Map.Entry<K, V>> reversedEntrySetIterable() {
        BitSet bitSet = this.getKeyValueUnionSet();
        return new IndexedIterable(this.getIndexedProxy(), new BitSetIterable(bitSet));
    }

    private BitSet getKeyValueUnionSet() {
        BitSet bitSet = new BitSet(this.keySet.size());
        bitSet.or(this.keySet.getValidIndices());
        bitSet.or(this.valueSet.getValidIndices());
        return bitSet;
    }

    private BitSet getKeyValueIntersectionSet() {
        BitSet bitSet = new BitSet(this.keySet.size());
        bitSet.or(this.keySet.getValidIndices());
        bitSet.and(this.valueSet.getValidIndices());
        return bitSet;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySetIterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
        ReversibleIndexedIterator<Map.Entry<K, V>> iterator = this.entrySetIterator();
        while (iterator.hasNext()) {
            consumer.accept((Map.Entry<K, V>)iterator.next());
        }
    }

    public OrderedSet<Map.Entry<K, V>> keyValueEntrySet() {
        this.isInValueUpdate = true;
        this.isInKeyUpdate = true;
        OrderedSet<Map.Entry<K, V>> values = new OrderedSet<Map.Entry<K, V>>(this.keySet.size(), new CollectionHost<Map.Entry<K, V>>(){

            @Override
            public void adding(int index, @Nullable Map.Entry<K, V> entry, @Nullable Object v) {
                assert (v == null);
                OrderedMultiMap.this.putKeyValue(entry.getKey(), entry.getValue());
            }

            @Override
            public Object removing(int index, @Nullable Map.Entry<K, V> entry) {
                boolean b = OrderedMultiMap.this.removeEntryIndex(index, entry.getKey(), entry.getValue());
                return b ? entry : null;
            }

            @Override
            public void clearing() {
                OrderedMultiMap.this.clear();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMultiMap.this.addNullEntry(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMultiMap.this.isInKeyUpdate || OrderedMultiMap.this.isInValueUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMultiMap.this.getModificationCount();
            }
        });
        ReversibleIndexedIterator<Map.Entry<K, V>> iterator = this.entrySetIterator();
        while (iterator.hasNext()) {
            values.add((Map.Entry)iterator.next());
        }
        this.isInValueUpdate = false;
        this.isInKeyUpdate = false;
        return values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedMultiMap set = (OrderedMultiMap)o;
        if (this.size() != set.size()) {
            return false;
        }
        return ((OrderedSet)this.entrySet()).equals(set.entrySet());
    }

    @Override
    public int hashCode() {
        int result = this.keySet.hashCode();
        result = 31 * result + this.valueSet.hashCode();
        return result;
    }
}

