/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.ide.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogShrinkingSuppressor;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.ViewableExKt;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0011\u001a\u00020\u000bJ\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0015J$\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bJ\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "fullSuppressionPolicies", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "deletionSuppressionPolicies", "fullSuppress", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "", "deletionSuppress", "shouldSuppressAddition", "properties", "Lcom/jetbrains/ide/model/highlighterRegistration/HighlighterProperties;", "shouldSuppressDeletion", "shouldSuppressUpdate", "released", "", "action", "Lkotlin/Function1;", "addSuppressionRule", "ruleLifetime", "kind", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "provider", "Lcom/jetbrains/rd/util/reactive/IViewable;", "suppress", "lf", "isSuppressed", "isSuppressed$intellij_rd_client", "()Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupSuppressor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n24#2,2:83\n14#3:85\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupSuppressor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor\n*L\n65#1:83,2\n19#1:85\n*E\n"})
public final class FrontendMarkupSuppressor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ViewableSet<Object> fullSuppressionPolicies;
    @NotNull
    private final ViewableSet<Object> deletionSuppressionPolicies;
    @NotNull
    private final IPropertyView<Boolean> fullSuppress;
    @NotNull
    private final IPropertyView<Boolean> deletionSuppress;
    @NotNull
    private static final Logger LOG;

    public FrontendMarkupSuppressor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.fullSuppressionPolicies = new ViewableSet(null, 1, null);
        this.deletionSuppressionPolicies = new ViewableSet(null, 1, null);
        this.fullSuppress = ViewableExKt.createIsNotEmpty((IViewableSet)((IViewableSet)this.fullSuppressionPolicies), (Lifetime)this.lifetime);
        this.deletionSuppress = BoolPropertyExKt.or((IPropertyView)ViewableExKt.createIsNotEmpty((IViewableSet)((IViewableSet)this.deletionSuppressionPolicies), (Lifetime)this.lifetime), this.fullSuppress);
        LOG.debug("Creating markup suppressor");
        this.released(this.lifetime, (Function1<? super Lifetime, Unit>)((Function1)FrontendMarkupSuppressor::_init_$lambda$0));
        DocumentLog.Companion.registerSuppressor(this.lifetime, new DocumentLogShrinkingSuppressor(){

            public boolean canShrink(RdDocumentVersion documentVersion) {
                Intrinsics.checkNotNullParameter((Object)documentVersion, (String)"documentVersion");
                return this.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE;
            }
        });
    }

    public final boolean shouldSuppressAddition(@NotNull HighlighterProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if (((Boolean)this.fullSuppress.getValue()).booleanValue()) {
            return true;
        }
        return properties.isBulkUpdatable();
    }

    public final boolean shouldSuppressDeletion(@Nullable HighlighterProperties properties) {
        if (((Boolean)this.fullSuppress.getValue()).booleanValue()) {
            return true;
        }
        HighlighterProperties highlighterProperties = properties;
        if (highlighterProperties != null) {
            return highlighterProperties.isBulkUpdatable();
        }
        return false;
    }

    public final boolean shouldSuppressUpdate() {
        return (Boolean)this.fullSuppress.getValue();
    }

    public final void released(@NotNull Lifetime lifetime, @NotNull Function1<? super Lifetime, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BoolPropertyExKt.whenFalse((IViewable)((IViewable)this.deletionSuppress), (Lifetime)lifetime, action);
    }

    public final void addSuppressionRule(@NotNull Lifetime ruleLifetime, @NotNull MarkupSuppressionKind kind, @NotNull IViewable<Boolean> provider2) {
        Intrinsics.checkNotNullParameter((Object)ruleLifetime, (String)"ruleLifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        RLifetimeKt.assertAlive((Lifetime)this.lifetime);
        provider2.view(RLifetimeKt.intersect((Lifetime)ruleLifetime, (Lifetime)this.lifetime), (arg_0, arg_1) -> FrontendMarkupSuppressor.addSuppressionRule$lambda$1(this, kind, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void suppress(@NotNull Lifetime lf, @NotNull MarkupSuppressionKind kind) {
        void $this$traceBracket$iv;
        Intrinsics.checkNotNullParameter((Object)lf, (String)"lf");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (kind == MarkupSuppressionKind.NONE) {
            return;
        }
        RLifetimeKt.assertAlive((Lifetime)this.lifetime);
        Lifetime intersection = RLifetimeKt.intersect((Lifetime)lf, (Lifetime)this.lifetime);
        Logger logger = LOG;
        Lifetime lifetime$iv = intersection;
        boolean $i$f$traceBracket = false;
        if ($this$traceBracket$iv.isTraceEnabled()) {
            lifetime$iv.bracket((Function0)new Function0<Unit>((Logger)$this$traceBracket$iv, kind){
                final /* synthetic */ Logger $this_traceBracket;
                final /* synthetic */ MarkupSuppressionKind $kind$inlined;
                {
                    this.$this_traceBracket = $receiver;
                    this.$kind$inlined = markupSuppressionKind;
                }

                public final void invoke() {
                    Logger logger = this.$this_traceBracket;
                    boolean bl = false;
                    logger.trace("started suppression: " + this.$kind$inlined);
                }
            }, (Function0)new Function0<Unit>((Logger)$this$traceBracket$iv, kind){
                final /* synthetic */ Logger $this_traceBracket;
                final /* synthetic */ MarkupSuppressionKind $kind$inlined;
                {
                    this.$this_traceBracket = $receiver;
                    this.$kind$inlined = markupSuppressionKind;
                }

                public final void invoke() {
                    Logger logger = this.$this_traceBracket;
                    boolean bl = false;
                    logger.trace("stopped suppression: " + this.$kind$inlined);
                }
            });
        }
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                CollectionExKt.addUnique((Collection)((Collection)this.deletionSuppressionPolicies), (Lifetime)intersection, (Object)new Object());
                break;
            }
            case 2: {
                CollectionExKt.addUnique((Collection)((Collection)this.fullSuppressionPolicies), (Lifetime)intersection, (Object)new Object());
            }
        }
    }

    @NotNull
    public final MarkupSuppressionKind isSuppressed$intellij_rd_client() {
        return (Boolean)this.fullSuppress.getValue() != false ? MarkupSuppressionKind.FULL : ((Boolean)this.deletionSuppress.getValue() != false ? MarkupSuppressionKind.DELETION : MarkupSuppressionKind.NONE);
    }

    private static final Unit _init_$lambda$0(Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LOG.debug("Suppressor released!");
        return Unit.INSTANCE;
    }

    private static final Unit addSuppressionRule$lambda$1(FrontendMarkupSuppressor this$0, MarkupSuppressionKind $kind, Lifetime lt, boolean v) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        if (v) {
            this$0.suppress(lt, $kind);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupSuppressor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MarkupSuppressionKind.values().length];
            try {
                nArray[MarkupSuppressionKind.DELETION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkupSuppressionKind.FULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

