/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyFactory;
import net.i2p.crypto.KeyPair;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.Elg2KeyPair;
import net.i2p.router.crypto.ratchet.Elligator2;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class Elg2KeyFactory
extends I2PThread
implements KeyFactory {
    private final RouterContext _context;
    private final Log _log;
    private final Elligator2 _elg2;
    private final int _minSize;
    private final int _maxSize;
    private final int _calcDelay;
    private final LinkedBlockingQueue<Elg2KeyPair> _keys;
    private volatile boolean _isRunning;
    private long _checkDelay = 10000L;
    private static final String PROP_DH_PRECALC_MIN = "crypto.edh.precalc.min";
    private static final String PROP_DH_PRECALC_MAX = "crypto.edh.precalc.max";
    private static final String PROP_DH_PRECALC_DELAY = "crypto.edh.precalc.delay";
    private static final int DEFAULT_DH_PRECALC_MIN = 20;
    private static final int DEFAULT_DH_PRECALC_MAX = 60;
    private static final int DEFAULT_DH_PRECALC_DELAY = 25;
    private final boolean RETURN_UNUSED_TO_XDH;

    public Elg2KeyFactory(RouterContext ctx) {
        super("EDH Precalc");
        boolean slow;
        this._context = ctx;
        this._log = ctx.logManager().getLog(Elg2KeyFactory.class);
        this._elg2 = new Elligator2(ctx);
        ctx.statManager().createRateStat("crypto.EDHGenerateTime", "How long it takes to create x and X", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.EDHUsed", "Need a DH from the queue", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.EDHReused", "Unused DH requeued", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.EDHEmpty", "DH queue empty", "Encryption", new long[]{3600000L});
        long maxMemory = SystemVersion.getMaxMemory();
        int factor = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x8000000L));
        this.RETURN_UNUSED_TO_XDH = slow = SystemVersion.isSlow();
        if (slow) {
            factor *= 2;
        }
        int defaultMin = 20 * factor;
        int defaultMax = 60 * factor;
        this._minSize = ctx.getProperty(PROP_DH_PRECALC_MIN, defaultMin);
        this._maxSize = ctx.getProperty(PROP_DH_PRECALC_MAX, defaultMax);
        this._calcDelay = ctx.getProperty(PROP_DH_PRECALC_DELAY, 25);
        if (this._log.shouldLog(10)) {
            this._log.debug("EDH Precalc (minimum: " + this._minSize + " max: " + this._maxSize + ", delay: " + this._calcDelay + ")");
        }
        this._keys = new LinkedBlockingQueue(this._maxSize);
        if (!SystemVersion.isWindows()) {
            this.setPriority(4);
        }
    }

    public void shutdown() {
        this._isRunning = false;
        this.interrupt();
        this._keys.clear();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.run2();
            }
            catch (IllegalStateException ise) {
                if (!this._isRunning) break block2;
                throw ise;
            }
        }
    }

    private void run2() {
        this._isRunning = true;
        while (this._isRunning) {
            int startSize = this.getSize();
            if (startSize <= this._minSize * 2 / 3 && this._checkDelay > 1000L) {
                this._checkDelay -= 1000L;
            } else if (startSize > this._minSize * 3 / 2 && this._checkDelay < 60000L) {
                this._checkDelay += 1000L;
            }
            if (startSize < this._minSize) {
                while (this.getSize() < this._maxSize && this._isRunning) {
                    long curStart = System.currentTimeMillis();
                    if (!this.addKeys(this.precalc())) break;
                    long curCalc = System.currentTimeMillis() - curStart;
                    if (Elg2KeyFactory.interrupted()) continue;
                    try {
                        Thread.sleep(Math.min(200L, Math.max(10L, (long)this._calcDelay + curCalc * 3L)));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this._isRunning) break;
            try {
                Thread.sleep(this._checkDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Elg2KeyPair getKeys() {
        this._context.statManager().addRateData("crypto.EDHUsed", 1L);
        Elg2KeyPair rv = this._keys.poll();
        if (rv == null) {
            this._context.statManager().addRateData("crypto.EDHEmpty", 1L);
            rv = this.precalc();
            this.interrupt();
        }
        return rv;
    }

    private Elg2KeyPair precalc() {
        KeyPair rv;
        byte[] enc;
        long start = System.currentTimeMillis();
        int i = 0;
        do {
            rv = this._context.keyGenerator().generatePKIKeys(EncType.ECIES_X25519);
            enc = this._elg2.encode(rv.getPublic());
            ++i;
            if (enc != null || !this.RETURN_UNUSED_TO_XDH) continue;
            this._context.commSystem().getXDHFactory().returnUnused(rv);
        } while (enc == null);
        long diff = System.currentTimeMillis() - start;
        this._context.statManager().addRateData("crypto.EDHGenerateTime", diff);
        if (this._log.shouldLog(10)) {
            this._log.debug("Took " + i + " tries and " + diff + "ms to generate local DH value");
        }
        return new Elg2KeyPair(rv.getPublic(), rv.getPrivate(), enc);
    }

    public void returnUnused(Elg2KeyPair kp) {
    }

    private final boolean addKeys(Elg2KeyPair kp) {
        return this._keys.offer(kp);
    }

    private final int getSize() {
        return this._keys.size();
    }
}

