/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.ECConstants;
import net.i2p.crypto.RSASigningPrivateCrtKey;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.LHMCache;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.SystemVersion;

public final class SigUtil {
    private static final int FACTOR = SystemVersion.isAndroid() ? 1 : 4;
    private static final Map<SigningPublicKey, ECPublicKey> _ECPubkeyCache = new LHMCache<SigningPublicKey, ECPublicKey>(FACTOR * 8);
    private static final Map<SigningPrivateKey, ECPrivateKey> _ECPrivkeyCache = new LHMCache<SigningPrivateKey, ECPrivateKey>(8);
    private static final Map<SigningPublicKey, EdDSAPublicKey> _EdPubkeyCache = new LHMCache<SigningPublicKey, EdDSAPublicKey>(FACTOR * 64);
    private static final Map<SigningPrivateKey, EdDSAPrivateKey> _EdPrivkeyCache = new LHMCache<SigningPrivateKey, EdDSAPrivateKey>(FACTOR * 4);

    private SigUtil() {
    }

    public static PublicKey toJavaKey(SigningPublicKey pk) throws GeneralSecurityException {
        switch (pk.getType().getBaseAlgorithm()) {
            case DSA: {
                return SigUtil.toJavaDSAKey(pk);
            }
            case EC: {
                return SigUtil.toJavaECKey(pk);
            }
            case EdDSA: {
                return SigUtil.toJavaEdDSAKey(pk);
            }
            case RSA: {
                return SigUtil.toJavaRSAKey(pk);
            }
        }
        throw new InvalidKeyException("unsupported key: " + pk);
    }

    public static PrivateKey toJavaKey(SigningPrivateKey pk) throws GeneralSecurityException {
        switch (pk.getType().getBaseAlgorithm()) {
            case DSA: {
                return SigUtil.toJavaDSAKey(pk);
            }
            case EC: {
                return SigUtil.toJavaECKey(pk);
            }
            case EdDSA: {
                return SigUtil.toJavaEdDSAKey(pk);
            }
            case RSA: {
                return SigUtil.toJavaRSAKey(pk);
            }
        }
        throw new InvalidKeyException("unsupported key: " + pk);
    }

    public static SigningPublicKey fromJavaKey(PublicKey pk) throws GeneralSecurityException {
        byte[] enc;
        if (pk instanceof DSAPublicKey) {
            return SigUtil.fromJavaKey((DSAPublicKey)pk);
        }
        if (pk instanceof ECPublicKey) {
            SigType type;
            ECPublicKey k = (ECPublicKey)pk;
            ECParameterSpec spec = k.getParams();
            if (ECConstants.equals(spec, ECConstants.P256_SPEC)) {
                type = SigType.ECDSA_SHA256_P256;
            } else if (ECConstants.equals(spec, ECConstants.P384_SPEC)) {
                type = SigType.ECDSA_SHA384_P384;
            } else if (ECConstants.equals(spec, ECConstants.P521_SPEC)) {
                type = SigType.ECDSA_SHA512_P521;
            } else {
                throw new InvalidKeyException("Unknown EC type");
            }
            return SigUtil.fromJavaKey(k, type);
        }
        if (pk instanceof EdDSAPublicKey) {
            return SigUtil.fromJavaKey((EdDSAPublicKey)pk, SigType.EdDSA_SHA512_Ed25519);
        }
        if (pk instanceof RSAPublicKey) {
            SigType type;
            RSAPublicKey k = (RSAPublicKey)pk;
            int sz = k.getModulus().bitLength();
            if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA256_2048.getParams()).getKeysize()) {
                type = SigType.RSA_SHA256_2048;
            } else if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA384_3072.getParams()).getKeysize()) {
                type = SigType.RSA_SHA384_3072;
            } else if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA512_4096.getParams()).getKeysize()) {
                type = SigType.RSA_SHA512_4096;
            } else {
                throw new InvalidKeyException("Unknown RSA type");
            }
            return SigUtil.fromJavaKey(k, type);
        }
        String algo = pk.getAlgorithm();
        if ("EdDSA".equals(algo) && (enc = pk.getEncoded()) != null) {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(enc);
            try {
                EdDSAPublicKey edpk = new EdDSAPublicKey(spec);
                return SigUtil.fromJavaKey(edpk, SigType.EdDSA_SHA512_Ed25519);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        throw new InvalidKeyException("Unknown type: " + pk.getClass());
    }

    public static SigningPublicKey fromJavaKey(PublicKey pk, SigType type) throws GeneralSecurityException {
        switch (type.getBaseAlgorithm()) {
            case DSA: {
                return SigUtil.fromJavaKey((DSAPublicKey)pk);
            }
            case EC: {
                return SigUtil.fromJavaKey((ECPublicKey)pk, type);
            }
            case EdDSA: {
                return SigUtil.fromJavaKey((EdDSAPublicKey)pk, type);
            }
            case RSA: {
                return SigUtil.fromJavaKey((RSAPublicKey)pk, type);
            }
        }
        throw new InvalidKeyException("Unknown type: " + (Object)((Object)type));
    }

    public static SigningPrivateKey fromJavaKey(PrivateKey pk) throws GeneralSecurityException {
        byte[] enc;
        if (pk instanceof DSAPrivateKey) {
            return SigUtil.fromJavaKey((DSAPrivateKey)pk);
        }
        if (pk instanceof ECPrivateKey) {
            SigType type;
            ECPrivateKey k = (ECPrivateKey)pk;
            ECParameterSpec spec = k.getParams();
            if (ECConstants.equals(spec, ECConstants.P256_SPEC)) {
                type = SigType.ECDSA_SHA256_P256;
            } else if (ECConstants.equals(spec, ECConstants.P384_SPEC)) {
                type = SigType.ECDSA_SHA384_P384;
            } else if (ECConstants.equals(spec, ECConstants.P521_SPEC)) {
                type = SigType.ECDSA_SHA512_P521;
            } else {
                throw new InvalidKeyException("Unknown EC type: " + pk.getClass() + " spec: " + spec.getClass());
            }
            return SigUtil.fromJavaKey(k, type);
        }
        if (pk instanceof EdDSAPrivateKey) {
            return SigUtil.fromJavaKey((EdDSAPrivateKey)pk, SigType.EdDSA_SHA512_Ed25519);
        }
        if (pk instanceof RSAPrivateKey) {
            SigType type;
            RSAPrivateKey k = (RSAPrivateKey)pk;
            int sz = k.getModulus().bitLength();
            if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA256_2048.getParams()).getKeysize()) {
                type = SigType.RSA_SHA256_2048;
            } else if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA384_3072.getParams()).getKeysize()) {
                type = SigType.RSA_SHA384_3072;
            } else if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA512_4096.getParams()).getKeysize()) {
                type = SigType.RSA_SHA512_4096;
            } else {
                throw new InvalidKeyException("Unknown RSA type");
            }
            return SigUtil.fromJavaKey(k, type);
        }
        String algo = pk.getAlgorithm();
        if ("EdDSA".equals(algo) && (enc = pk.getEncoded()) != null) {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(enc);
            try {
                EdDSAPrivateKey edpk = new EdDSAPrivateKey(spec);
                return SigUtil.fromJavaKey(edpk, SigType.EdDSA_SHA512_Ed25519);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        throw new InvalidKeyException("Unknown type: " + pk.getClass());
    }

    public static SigningPrivateKey fromJavaKey(PrivateKey pk, SigType type) throws GeneralSecurityException {
        switch (type.getBaseAlgorithm()) {
            case DSA: {
                return SigUtil.fromJavaKey((DSAPrivateKey)pk);
            }
            case EC: {
                return SigUtil.fromJavaKey((ECPrivateKey)pk, type);
            }
            case EdDSA: {
                return SigUtil.fromJavaKey((EdDSAPrivateKey)pk, type);
            }
            case RSA: {
                return SigUtil.fromJavaKey((RSAPrivateKey)pk, type);
            }
        }
        throw new InvalidKeyException("Unknown type: " + (Object)((Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ECPublicKey toJavaECKey(SigningPublicKey pk) throws GeneralSecurityException {
        ECPublicKey rv;
        Map<SigningPublicKey, ECPublicKey> map = _ECPubkeyCache;
        synchronized (map) {
            rv = _ECPubkeyCache.get(pk);
        }
        if (rv != null) {
            return rv;
        }
        rv = SigUtil.cvtToJavaECKey(pk);
        map = _ECPubkeyCache;
        synchronized (map) {
            _ECPubkeyCache.put(pk, rv);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ECPrivateKey toJavaECKey(SigningPrivateKey pk) throws GeneralSecurityException {
        ECPrivateKey rv;
        Map<SigningPrivateKey, ECPrivateKey> map = _ECPrivkeyCache;
        synchronized (map) {
            rv = _ECPrivkeyCache.get(pk);
        }
        if (rv != null) {
            return rv;
        }
        rv = SigUtil.cvtToJavaECKey(pk);
        map = _ECPrivkeyCache;
        synchronized (map) {
            _ECPrivkeyCache.put(pk, rv);
        }
        return rv;
    }

    private static ECPublicKey cvtToJavaECKey(SigningPublicKey pk) throws GeneralSecurityException {
        SigType type = pk.getType();
        NativeBigInteger[] xy = SigUtil.split(pk.getData());
        ECPoint w = new ECPoint(xy[0], xy[1]);
        ECPublicKeySpec ks = new ECPublicKeySpec(w, (ECParameterSpec)type.getParams());
        KeyFactory kf = KeyFactory.getInstance("EC");
        return (ECPublicKey)kf.generatePublic(ks);
    }

    private static ECPrivateKey cvtToJavaECKey(SigningPrivateKey pk) throws GeneralSecurityException {
        SigType type = pk.getType();
        byte[] b = pk.getData();
        BigInteger s = new BigInteger(1, b);
        ECPrivateKeySpec ks = new ECPrivateKeySpec(s, (ECParameterSpec)type.getParams());
        KeyFactory kf = KeyFactory.getInstance("EC");
        return (ECPrivateKey)kf.generatePrivate(ks);
    }

    public static SigningPublicKey fromJavaKey(ECPublicKey pk, SigType type) throws GeneralSecurityException {
        ECPoint w = pk.getW();
        BigInteger x = w.getAffineX();
        BigInteger y = w.getAffineY();
        int len = type.getPubkeyLen();
        byte[] b = SigUtil.combine(x, y, len);
        return new SigningPublicKey(type, b);
    }

    public static SigningPrivateKey fromJavaKey(ECPrivateKey pk, SigType type) throws GeneralSecurityException {
        BigInteger s = pk.getS();
        int len = type.getPrivkeyLen();
        byte[] bs = SigUtil.rectify(s, len);
        return new SigningPrivateKey(type, bs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdDSAPublicKey toJavaEdDSAKey(SigningPublicKey pk) throws GeneralSecurityException {
        EdDSAPublicKey rv;
        Map<SigningPublicKey, EdDSAPublicKey> map = _EdPubkeyCache;
        synchronized (map) {
            rv = _EdPubkeyCache.get(pk);
        }
        if (rv != null) {
            return rv;
        }
        rv = SigUtil.cvtToJavaEdDSAKey(pk);
        map = _EdPubkeyCache;
        synchronized (map) {
            _EdPubkeyCache.put(pk, rv);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdDSAPrivateKey toJavaEdDSAKey(SigningPrivateKey pk) throws GeneralSecurityException {
        EdDSAPrivateKey rv;
        Map<SigningPrivateKey, EdDSAPrivateKey> map = _EdPrivkeyCache;
        synchronized (map) {
            rv = _EdPrivkeyCache.get(pk);
        }
        if (rv != null) {
            return rv;
        }
        rv = SigUtil.cvtToJavaEdDSAKey(pk);
        map = _EdPrivkeyCache;
        synchronized (map) {
            _EdPrivkeyCache.put(pk, rv);
        }
        return rv;
    }

    private static EdDSAPublicKey cvtToJavaEdDSAKey(SigningPublicKey pk) throws GeneralSecurityException {
        try {
            return new EdDSAPublicKey(new EdDSAPublicKeySpec(pk.getData(), (EdDSAParameterSpec)pk.getType().getParams()));
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidKeyException(iae);
        }
    }

    private static EdDSAPrivateKey cvtToJavaEdDSAKey(SigningPrivateKey pk) throws GeneralSecurityException {
        try {
            EdDSAPrivateKeySpec pkspec;
            EdDSAParameterSpec paramspec = (EdDSAParameterSpec)pk.getType().getParams();
            SigType type = pk.getType();
            if (type == SigType.EdDSA_SHA512_Ed25519 || type == SigType.EdDSA_SHA512_Ed25519ph) {
                pkspec = new EdDSAPrivateKeySpec(pk.getData(), paramspec);
            } else if (type == SigType.RedDSA_SHA512_Ed25519) {
                pkspec = new EdDSAPrivateKeySpec(pk.getData(), null, paramspec);
            } else {
                throw new InvalidKeyException();
            }
            return new EdDSAPrivateKey(pkspec);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidKeyException(iae);
        }
    }

    public static SigningPublicKey fromJavaKey(EdDSAPublicKey pk, SigType type) throws GeneralSecurityException {
        return new SigningPublicKey(type, pk.getAbyte());
    }

    public static SigningPrivateKey fromJavaKey(EdDSAPrivateKey pk, SigType type) throws GeneralSecurityException {
        byte[] data;
        if (type == SigType.EdDSA_SHA512_Ed25519 || type == SigType.EdDSA_SHA512_Ed25519ph) {
            data = pk.getSeed();
        } else if (type == SigType.RedDSA_SHA512_Ed25519) {
            data = pk.geta();
        } else {
            throw new InvalidKeyException();
        }
        return new SigningPrivateKey(type, data);
    }

    public static DSAPublicKey toJavaDSAKey(SigningPublicKey pk) throws GeneralSecurityException {
        KeyFactory kf = KeyFactory.getInstance("DSA");
        DSAPublicKeySpec ks = new DSAPublicKeySpec(new NativeBigInteger(1, pk.getData()), CryptoConstants.dsap, CryptoConstants.dsaq, CryptoConstants.dsag);
        return (DSAPublicKey)kf.generatePublic(ks);
    }

    public static DSAPrivateKey toJavaDSAKey(SigningPrivateKey pk) throws GeneralSecurityException {
        KeyFactory kf = KeyFactory.getInstance("DSA");
        DSAPrivateKeySpec ks = new DSAPrivateKeySpec(new BigInteger(1, pk.getData()), CryptoConstants.dsap, CryptoConstants.dsaq, CryptoConstants.dsag);
        return (DSAPrivateKey)kf.generatePrivate(ks);
    }

    public static SigningPublicKey fromJavaKey(DSAPublicKey pk) throws GeneralSecurityException {
        BigInteger y = pk.getY();
        SigType type = SigType.DSA_SHA1;
        int len = type.getPubkeyLen();
        byte[] by = SigUtil.rectify(y, len);
        return new SigningPublicKey(type, by);
    }

    public static SigningPrivateKey fromJavaKey(DSAPrivateKey pk) throws GeneralSecurityException {
        BigInteger x = pk.getX();
        SigType type = SigType.DSA_SHA1;
        int len = type.getPrivkeyLen();
        byte[] bx = SigUtil.rectify(x, len);
        return new SigningPrivateKey(type, bx);
    }

    @Deprecated
    public static RSAPublicKey toJavaRSAKey(SigningPublicKey pk) throws GeneralSecurityException {
        SigType type = pk.getType();
        KeyFactory kf = KeyFactory.getInstance("RSA");
        NativeBigInteger n = new NativeBigInteger(1, pk.getData());
        BigInteger e = ((RSAKeyGenParameterSpec)type.getParams()).getPublicExponent();
        RSAPublicKeySpec ks = new RSAPublicKeySpec(n, e);
        return (RSAPublicKey)kf.generatePublic(ks);
    }

    public static RSAPrivateKey toJavaRSAKey(SigningPrivateKey pk) throws GeneralSecurityException {
        if (pk instanceof RSASigningPrivateCrtKey) {
            return ((RSASigningPrivateCrtKey)pk).toJavaKey();
        }
        KeyFactory kf = KeyFactory.getInstance("RSA");
        NativeBigInteger[] nd = SigUtil.split(pk.getData());
        RSAPrivateKeySpec ks = new RSAPrivateKeySpec(nd[0], nd[1]);
        return (RSAPrivateKey)kf.generatePrivate(ks);
    }

    public static SigningPublicKey fromJavaKey(RSAPublicKey pk, SigType type) throws GeneralSecurityException {
        BigInteger n = pk.getModulus();
        int len = type.getPubkeyLen();
        byte[] bn = SigUtil.rectify(n, len);
        return new SigningPublicKey(type, bn);
    }

    public static SigningPrivateKey fromJavaKey(RSAPrivateKey pk, SigType type) throws GeneralSecurityException {
        BigInteger n = pk.getModulus();
        BigInteger d = pk.getPrivateExponent();
        byte[] b = SigUtil.combine(n, d, type.getPrivkeyLen());
        if (pk instanceof RSAPrivateCrtKey) {
            return RSASigningPrivateCrtKey.fromJavaKey((RSAPrivateCrtKey)pk);
        }
        return new SigningPrivateKey(type, b);
    }

    public static byte[] toJavaSig(Signature sig) {
        if (sig.getType().getBaseAlgorithm() == SigAlgo.RSA || sig.getType().getBaseAlgorithm() == SigAlgo.EdDSA) {
            return sig.getData();
        }
        return SigUtil.sigBytesToASN1(sig.getData());
    }

    public static Signature fromJavaSig(byte[] asn, SigType type) throws SignatureException {
        if (type.getBaseAlgorithm() == SigAlgo.RSA || type.getBaseAlgorithm() == SigAlgo.EdDSA) {
            return new Signature(type, asn);
        }
        return new Signature(type, SigUtil.aSN1ToSigBytes(asn, type.getSigLen()));
    }

    public static PublicKey importJavaPublicKey(File file, SigType type) throws GeneralSecurityException, IOException {
        byte[] data = SigUtil.getData(file);
        X509EncodedKeySpec ks = new X509EncodedKeySpec(data);
        String algo = type.getBaseAlgorithm().getName();
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(ks);
    }

    public static PrivateKey importJavaPrivateKey(File file, SigType type) throws GeneralSecurityException, IOException {
        byte[] data = SigUtil.getData(file);
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(data);
        String algo = type.getBaseAlgorithm().getName();
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePrivate(ks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getData(File file) throws IOException {
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            in = new FileInputStream(file);
            int read = 0;
            int tot = 0;
            while ((read = ((InputStream)in).read(buf)) != -1) {
                out.write(buf, 0, read);
                if ((tot += read) <= 16384) continue;
                throw new IOException("too big");
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static NativeBigInteger[] split(byte[] b) {
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("length must be even");
        }
        int sublen = b.length / 2;
        byte[] bx = new byte[sublen];
        byte[] by = new byte[sublen];
        System.arraycopy(b, 0, bx, 0, sublen);
        System.arraycopy(b, sublen, by, 0, sublen);
        NativeBigInteger x = new NativeBigInteger(1, bx);
        NativeBigInteger y = new NativeBigInteger(1, by);
        return new NativeBigInteger[]{x, y};
    }

    static byte[] combine(BigInteger x, BigInteger y, int len) throws InvalidKeyException {
        if ((len & 1) != 0) {
            throw new InvalidKeyException("length must be even");
        }
        int sublen = len / 2;
        byte[] b = new byte[len];
        byte[] bx = SigUtil.rectify(x, sublen);
        byte[] by = SigUtil.rectify(y, sublen);
        System.arraycopy(bx, 0, b, 0, sublen);
        System.arraycopy(by, 0, b, sublen, sublen);
        return b;
    }

    public static byte[] rectify(BigInteger bi, int len) throws InvalidKeyException {
        byte[] b = bi.toByteArray();
        if (b.length == len) {
            return b;
        }
        if (b.length > len + 1) {
            throw new InvalidKeyException("key too big (" + b.length + ") max is " + (len + 1));
        }
        byte[] rv = new byte[len];
        if (b.length == 0) {
            return rv;
        }
        if ((b[0] & 0x80) != 0) {
            throw new InvalidKeyException("negative");
        }
        if (b.length > len) {
            if (b[0] != 0) {
                throw new InvalidKeyException("key too big (" + b.length + ") max is " + len);
            }
            System.arraycopy(b, 1, rv, 0, len);
        } else {
            System.arraycopy(b, 0, rv, len - b.length, b.length);
        }
        return rv;
    }

    private static byte[] sigBytesToASN1(byte[] sig) {
        NativeBigInteger[] rs = SigUtil.split(sig);
        return SigUtil.sigBytesToASN1(rs[0], rs[1]);
    }

    public static byte[] sigBytesToASN1(BigInteger r, BigInteger s) {
        byte[] sb;
        int extra = 4;
        byte[] rb = r.toByteArray();
        if (rb.length > 127) {
            ++extra;
            if (rb.length > 255) {
                ++extra;
            }
        }
        if ((sb = s.toByteArray()).length > 127) {
            ++extra;
            if (sb.length > 255) {
                ++extra;
            }
        }
        int seqlen = rb.length + sb.length + extra;
        int totlen = seqlen + 2;
        if (seqlen > 127) {
            ++totlen;
            if (seqlen > 255) {
                ++totlen;
            }
        }
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, seqlen);
        rv[idx++] = 2;
        idx = SigUtil.intToASN1(rv, idx, rb.length);
        System.arraycopy(rb, 0, rv, idx, rb.length);
        idx += rb.length;
        rv[idx++] = 2;
        idx = SigUtil.intToASN1(rv, idx, sb.length);
        System.arraycopy(sb, 0, rv, idx, sb.length);
        return rv;
    }

    public static int intToASN1(byte[] d, int idx, int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("fixme length " + val);
        }
        if (val > 127) {
            if (val > 255) {
                d[idx++] = -126;
                d[idx++] = (byte)(val >> 8);
            } else {
                d[idx++] = -127;
            }
        }
        d[idx++] = (byte)val;
        return idx;
    }

    private static byte[] aSN1ToSigBytes(byte[] asn, int len) throws SignatureException {
        int slen;
        int rlen;
        if (asn[0] != 48) {
            throw new SignatureException("asn[0] = " + (asn[0] & 0xFF));
        }
        int idx = 2;
        if ((asn[1] & 0x80) != 0) {
            idx += asn[1] & 0x7F;
        }
        if (asn[idx] != 2) {
            throw new SignatureException("asn[2] = " + (asn[idx] & 0xFF));
        }
        byte[] rv = new byte[len];
        int sublen = len / 2;
        if (((rlen = asn[++idx]) & 0x80) != 0) {
            if ((rlen & 0xFF) == 129) {
                rlen = asn[++idx] & 0xFF;
            } else if ((rlen & 0xFF) == 130) {
                rlen = asn[++idx] & 0xFF;
                rlen <<= 8;
                rlen |= asn[++idx] & 0xFF;
            } else {
                throw new SignatureException("FIXME R length > 65535");
            }
        }
        if ((asn[++idx] & 0x80) != 0) {
            throw new SignatureException("R is negative");
        }
        if (rlen > sublen + 1) {
            throw new SignatureException("R too big " + rlen);
        }
        if (rlen == sublen + 1) {
            System.arraycopy(asn, idx + 1, rv, 0, sublen);
        } else {
            System.arraycopy(asn, idx, rv, sublen - rlen, rlen);
        }
        if (asn[idx += rlen] != 2) {
            throw new SignatureException("asn[s] = " + (asn[idx] & 0xFF));
        }
        if (((slen = asn[++idx]) & 0x80) != 0) {
            if ((slen & 0xFF) == 129) {
                slen = asn[++idx] & 0xFF;
            } else if ((slen & 0xFF) == 130) {
                slen = asn[++idx] & 0xFF;
                slen <<= 8;
                slen |= asn[++idx] & 0xFF;
            } else {
                throw new SignatureException("FIXME S length > 65535");
            }
        }
        if ((asn[++idx] & 0x80) != 0) {
            throw new SignatureException("S is negative");
        }
        if (slen > sublen + 1) {
            throw new SignatureException("S too big " + slen);
        }
        if (slen == sublen + 1) {
            System.arraycopy(asn, idx + 1, rv, sublen, sublen);
        } else {
            System.arraycopy(asn, idx, rv, len - slen, slen);
        }
        return rv;
    }

    public static NativeBigInteger[] aSN1ToBigInteger(byte[] asn, int len) throws SignatureException {
        byte[] sig = SigUtil.aSN1ToSigBytes(asn, len * 2);
        return SigUtil.split(sig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<SimpleDataStructure, Key> map = _ECPubkeyCache;
        synchronized (map) {
            _ECPubkeyCache.clear();
        }
        map = _ECPrivkeyCache;
        synchronized (map) {
            _ECPrivkeyCache.clear();
        }
        map = _EdPubkeyCache;
        synchronized (map) {
            _EdPubkeyCache.clear();
        }
        map = _EdPrivkeyCache;
        synchronized (map) {
            _EdPrivkeyCache.clear();
        }
    }
}

