/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.SigningPublicKey;

public final class I2PDatagramDissector {
    private static final int DGRAM_BUFSIZE = 32768;
    private static final int MIN_DGRAM_SIZE = 427;
    private final DSAEngine dsaEng = DSAEngine.getInstance();
    private final SHA256Generator hashGen = SHA256Generator.getInstance();
    private byte[] rxHash;
    private Signature rxSign;
    private Destination rxDest;
    private final byte[] rxPayload = new byte[32768];
    private int rxPayloadLen;
    private boolean valid;

    public void loadI2PDatagram(byte[] dgram) throws DataFormatException {
        this.valid = false;
        if (dgram.length < 427) {
            throw new DataFormatException("repliable datagram too small: " + dgram.length);
        }
        ByteArrayInputStream dgStream = new ByteArrayInputStream(dgram);
        try {
            this.rxDest = Destination.create(dgStream);
            SigType type = this.rxDest.getSigningPublicKey().getType();
            if (type == null) {
                throw new DataFormatException("unsupported sig type");
            }
            this.rxSign = new Signature(type);
            this.rxSign.readBytes(dgStream);
            this.rxPayloadLen = dgStream.read(this.rxPayload);
            if (type == SigType.DSA_SHA1) {
                if (this.rxHash == null) {
                    this.rxHash = new byte[32];
                }
                this.hashGen.calculateHash(this.rxPayload, 0, this.rxPayloadLen, this.rxHash, 0);
            } else {
                this.rxHash = null;
            }
        }
        catch (IOException e) {
            throw new DataFormatException("Error loading datagram", e);
        }
    }

    public byte[] getPayload() throws I2PInvalidDatagramException {
        this.verifySignature();
        return this.extractPayload();
    }

    public Destination getSender() throws I2PInvalidDatagramException {
        this.verifySignature();
        return this.extractSender();
    }

    public Hash getHash() throws I2PInvalidDatagramException {
        this.verifySignature();
        return this.extractHash();
    }

    public byte[] extractPayload() {
        byte[] retPayload = new byte[this.rxPayloadLen];
        System.arraycopy(this.rxPayload, 0, retPayload, 0, this.rxPayloadLen);
        return retPayload;
    }

    public Destination extractSender() {
        return this.rxDest;
    }

    public Hash extractHash() {
        if (this.rxHash == null) {
            return null;
        }
        byte[] hash = new byte[32];
        System.arraycopy(this.rxHash, 0, hash, 0, 32);
        return new Hash(hash);
    }

    public void verifySignature() throws I2PInvalidDatagramException {
        if (this.valid) {
            return;
        }
        if (this.rxSign == null || this.rxSign.getData() == null || this.rxDest == null) {
            throw new I2PInvalidDatagramException("Datagram not yet read");
        }
        SigningPublicKey spk = this.rxDest.getSigningPublicKey();
        SigType type = spk.getType();
        if (type == null) {
            throw new I2PInvalidDatagramException("unsupported sig type");
        }
        if (type == SigType.DSA_SHA1 ? !this.dsaEng.verifySignature(this.rxSign, this.rxHash, spk) : !this.dsaEng.verifySignature(this.rxSign, this.rxPayload, 0, this.rxPayloadLen, spk)) {
            throw new I2PInvalidDatagramException("Incorrect I2P repliable datagram signature");
        }
        this.valid = true;
    }
}

