/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.Utils;

public class ModOption
extends AbstractOption<FreeColModFile> {
    private static final Logger logger = Logger.getLogger(ModOption.class.getName());
    public static final String TAG = "modOption";
    private FreeColModFile value = null;

    public ModOption(Specification specification) {
        super(specification);
    }

    public final List<FreeColModFile> getChoices() {
        return new ArrayList<FreeColModFile>(FreeColModFile.getModsList());
    }

    @Override
    public ModOption cloneOption() {
        ModOption result = new ModOption(this.getSpecification());
        result.setId(this.getId());
        result.value = this.value;
        return result;
    }

    @Override
    public FreeColModFile getValue() {
        return this.value;
    }

    @Override
    public void setValue(FreeColModFile value) {
        FreeColModFile oldValue = this.value;
        this.value = value;
        this.setId(value.getId());
        if (this.isDefined && value != oldValue) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) throws XMLStreamException {
        String id = valueString != null ? valueString : defaultValueString;
        FreeColModFile fcmf = FreeColModFile.getFreeColModFile(id);
        if (fcmf == null) {
            throw new XMLStreamException("Could not find mod for: " + id);
        }
        this.setValue(fcmf);
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value.getId());
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModOption) {
            ModOption other = (ModOption)o;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Utils.hashCode(this.getId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[').append(this.getId()).append(']');
        return sb.toString();
    }
}

