/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.Domain;
import io.mola.galimatias.GalimatiasParseException;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DomainTest {
    @Test
    public void equals() throws GalimatiasParseException {
        Domain sameDomain = Domain.parseDomain("example.com");
        Assertions.assertThat((Object)sameDomain).isEqualTo((Object)sameDomain);
        Assertions.assertThat((Object)sameDomain).isEqualTo((Object)Domain.parseDomain("example.com"));
        Assertions.assertThat((Object)sameDomain).isEqualTo((Object)Domain.parseDomain("EXAMPLE.COM"));
        Assertions.assertThat((Object)sameDomain).isNotEqualTo((Object)Domain.parseDomain("other.com"));
        Assertions.assertThat((Object)sameDomain).isNotEqualTo((Object)Domain.parseDomain("other.example.com"));
        Assertions.assertThat((Object)sameDomain).isNotEqualTo((Object)"foo");
        Assertions.assertThat((Object)sameDomain).isNotEqualTo(null);
    }

    @Test
    public void parseDomainIDNA() throws GalimatiasParseException {
        Assertions.assertThat((String)Domain.parseDomain("\u30b8\u30a7\u30fc\u30d4\u30fc\u30cb\u30c3\u30af.jp").toString()).isEqualTo((Object)"xn--hckqz9bzb1cyrb.jp");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseDomainEmpty() throws GalimatiasParseException {
        Domain.parseDomain("");
    }

    @Test(expected=NullPointerException.class)
    public void parseDomainNull() throws GalimatiasParseException {
        Domain.parseDomain(null);
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseDomainDot() throws GalimatiasParseException {
        Domain.parseDomain(".");
    }
}

