<?php
// This file was auto-generated from sdk-root/src/data/s3tables/2018-05-10/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-05-10', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 's3tables', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Amazon S3 Tables', 'serviceId' => 'S3Tables', 'signatureVersion' => 'v4', 'signingName' => 's3tables', 'uid' => 's3tables-2018-05-10', ], 'operations' => [ 'CreateNamespace' => [ 'name' => 'CreateNamespace', 'http' => [ 'method' => 'PUT', 'requestUri' => '/namespaces/{tableBucketARN}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateNamespaceRequest', ], 'output' => [ 'shape' => 'CreateNamespaceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], 'CreateTable' => [ 'name' => 'CreateTable', 'http' => [ 'method' => 'PUT', 'requestUri' => '/tables/{tableBucketARN}/{namespace}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateTableRequest', ], 'output' => [ 'shape' => 'CreateTableResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], 'CreateTableBucket' => [ 'name' => 'CreateTableBucket', 'http' => [ 'method' => 'PUT', 'requestUri' => '/buckets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateTableBucketRequest', ], 'output' => [ 'shape' => 'CreateTableBucketResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], 'DeleteNamespace' => [ 'name' => 'DeleteNamespace', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/namespaces/{tableBucketARN}/{namespace}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteNamespaceRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTable' => [ 'name' => 'DeleteTable', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTableBucket' => [ 'name' => 'DeleteTableBucket', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/buckets/{tableBucketARN}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableBucketRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTableBucketEncryption' => [ 'name' => 'DeleteTableBucketEncryption', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/buckets/{tableBucketARN}/encryption', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableBucketEncryptionRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTableBucketMetricsConfiguration' => [ 'name' => 'DeleteTableBucketMetricsConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/buckets/{tableBucketARN}/metrics', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableBucketMetricsConfigurationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTableBucketPolicy' => [ 'name' => 'DeleteTableBucketPolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/buckets/{tableBucketARN}/policy', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableBucketPolicyRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTableBucketReplication' => [ 'name' => 'DeleteTableBucketReplication', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/table-bucket-replication', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableBucketReplicationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTablePolicy' => [ 'name' => 'DeleteTablePolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/policy', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTablePolicyRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'DeleteTableReplication' => [ 'name' => 'DeleteTableReplication', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/table-replication', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTableReplicationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'GetNamespace' => [ 'name' => 'GetNamespace', 'http' => [ 'method' => 'GET', 'requestUri' => '/namespaces/{tableBucketARN}/{namespace}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetNamespaceRequest', ], 'output' => [ 'shape' => 'GetNamespaceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTable' => [ 'name' => 'GetTable', 'http' => [ 'method' => 'GET', 'requestUri' => '/get-table', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableRequest', ], 'output' => [ 'shape' => 'GetTableResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucket' => [ 'name' => 'GetTableBucket', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets/{tableBucketARN}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketRequest', ], 'output' => [ 'shape' => 'GetTableBucketResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucketEncryption' => [ 'name' => 'GetTableBucketEncryption', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets/{tableBucketARN}/encryption', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketEncryptionRequest', ], 'output' => [ 'shape' => 'GetTableBucketEncryptionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucketMaintenanceConfiguration' => [ 'name' => 'GetTableBucketMaintenanceConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets/{tableBucketARN}/maintenance', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketMaintenanceConfigurationRequest', ], 'output' => [ 'shape' => 'GetTableBucketMaintenanceConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucketMetricsConfiguration' => [ 'name' => 'GetTableBucketMetricsConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets/{tableBucketARN}/metrics', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketMetricsConfigurationRequest', ], 'output' => [ 'shape' => 'GetTableBucketMetricsConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucketPolicy' => [ 'name' => 'GetTableBucketPolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets/{tableBucketARN}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketPolicyRequest', ], 'output' => [ 'shape' => 'GetTableBucketPolicyResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucketReplication' => [ 'name' => 'GetTableBucketReplication', 'http' => [ 'method' => 'GET', 'requestUri' => '/table-bucket-replication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketReplicationRequest', ], 'output' => [ 'shape' => 'GetTableBucketReplicationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableBucketStorageClass' => [ 'name' => 'GetTableBucketStorageClass', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets/{tableBucketARN}/storage-class', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableBucketStorageClassRequest', ], 'output' => [ 'shape' => 'GetTableBucketStorageClassResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableEncryption' => [ 'name' => 'GetTableEncryption', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/encryption', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableEncryptionRequest', ], 'output' => [ 'shape' => 'GetTableEncryptionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableMaintenanceConfiguration' => [ 'name' => 'GetTableMaintenanceConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/maintenance', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableMaintenanceConfigurationRequest', ], 'output' => [ 'shape' => 'GetTableMaintenanceConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableMaintenanceJobStatus' => [ 'name' => 'GetTableMaintenanceJobStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/maintenance-job-status', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableMaintenanceJobStatusRequest', ], 'output' => [ 'shape' => 'GetTableMaintenanceJobStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableMetadataLocation' => [ 'name' => 'GetTableMetadataLocation', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/metadata-location', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableMetadataLocationRequest', ], 'output' => [ 'shape' => 'GetTableMetadataLocationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTablePolicy' => [ 'name' => 'GetTablePolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTablePolicyRequest', ], 'output' => [ 'shape' => 'GetTablePolicyResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableRecordExpirationConfiguration' => [ 'name' => 'GetTableRecordExpirationConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/table-record-expiration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableRecordExpirationConfigurationRequest', ], 'output' => [ 'shape' => 'GetTableRecordExpirationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'MethodNotAllowedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableRecordExpirationJobStatus' => [ 'name' => 'GetTableRecordExpirationJobStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/table-record-expiration-job-status', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableRecordExpirationJobStatusRequest', ], 'output' => [ 'shape' => 'GetTableRecordExpirationJobStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'MethodNotAllowedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableReplication' => [ 'name' => 'GetTableReplication', 'http' => [ 'method' => 'GET', 'requestUri' => '/table-replication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableReplicationRequest', ], 'output' => [ 'shape' => 'GetTableReplicationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableReplicationStatus' => [ 'name' => 'GetTableReplicationStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/replication-status', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableReplicationStatusRequest', ], 'output' => [ 'shape' => 'GetTableReplicationStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'GetTableStorageClass' => [ 'name' => 'GetTableStorageClass', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/storage-class', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTableStorageClassRequest', ], 'output' => [ 'shape' => 'GetTableStorageClassResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'ListNamespaces' => [ 'name' => 'ListNamespaces', 'http' => [ 'method' => 'GET', 'requestUri' => '/namespaces/{tableBucketARN}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListNamespacesRequest', ], 'output' => [ 'shape' => 'ListNamespacesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'ListTableBuckets' => [ 'name' => 'ListTableBuckets', 'http' => [ 'method' => 'GET', 'requestUri' => '/buckets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTableBucketsRequest', ], 'output' => [ 'shape' => 'ListTableBucketsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'ListTables' => [ 'name' => 'ListTables', 'http' => [ 'method' => 'GET', 'requestUri' => '/tables/{tableBucketARN}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTablesRequest', ], 'output' => [ 'shape' => 'ListTablesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tag/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'readonly' => true, ], 'PutTableBucketEncryption' => [ 'name' => 'PutTableBucketEncryption', 'http' => [ 'method' => 'PUT', 'requestUri' => '/buckets/{tableBucketARN}/encryption', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTableBucketEncryptionRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableBucketMaintenanceConfiguration' => [ 'name' => 'PutTableBucketMaintenanceConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/buckets/{tableBucketARN}/maintenance/{type}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'PutTableBucketMaintenanceConfigurationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutTableBucketMetricsConfiguration' => [ 'name' => 'PutTableBucketMetricsConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/buckets/{tableBucketARN}/metrics', 'responseCode' => 204, ], 'input' => [ 'shape' => 'PutTableBucketMetricsConfigurationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableBucketPolicy' => [ 'name' => 'PutTableBucketPolicy', 'http' => [ 'method' => 'PUT', 'requestUri' => '/buckets/{tableBucketARN}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTableBucketPolicyRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableBucketReplication' => [ 'name' => 'PutTableBucketReplication', 'http' => [ 'method' => 'PUT', 'requestUri' => '/table-bucket-replication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTableBucketReplicationRequest', ], 'output' => [ 'shape' => 'PutTableBucketReplicationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableBucketStorageClass' => [ 'name' => 'PutTableBucketStorageClass', 'http' => [ 'method' => 'PUT', 'requestUri' => '/buckets/{tableBucketARN}/storage-class', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTableBucketStorageClassRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableMaintenanceConfiguration' => [ 'name' => 'PutTableMaintenanceConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/maintenance/{type}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'PutTableMaintenanceConfigurationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutTablePolicy' => [ 'name' => 'PutTablePolicy', 'http' => [ 'method' => 'PUT', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/policy', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTablePolicyRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableRecordExpirationConfiguration' => [ 'name' => 'PutTableRecordExpirationConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/table-record-expiration', 'responseCode' => 204, ], 'input' => [ 'shape' => 'PutTableRecordExpirationConfigurationRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'MethodNotAllowedException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'PutTableReplication' => [ 'name' => 'PutTableReplication', 'http' => [ 'method' => 'PUT', 'requestUri' => '/table-replication', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutTableReplicationRequest', ], 'output' => [ 'shape' => 'PutTableReplicationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'RenameTable' => [ 'name' => 'RenameTable', 'http' => [ 'method' => 'PUT', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/rename', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RenameTableRequest', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tag/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tag/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], 'idempotent' => true, ], 'UpdateTableMetadataLocation' => [ 'name' => 'UpdateTableMetadataLocation', 'http' => [ 'method' => 'PUT', 'requestUri' => '/tables/{tableBucketARN}/{namespace}/{name}/metadata-location', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateTableMetadataLocationRequest', ], 'output' => [ 'shape' => 'UpdateTableMetadataLocationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'BadRequestException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '[0-9].*', ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreateNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'CreateNamespaceRequestNamespaceList', ], ], ], 'CreateNamespaceRequestNamespaceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NamespaceName', ], 'max' => 1, 'min' => 1, ], 'CreateNamespaceResponse' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceList', ], ], ], 'CreateTableBucketRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'TableBucketName', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 'storageClassConfiguration' => [ 'shape' => 'StorageClassConfiguration', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateTableBucketResponse' => [ 'type' => 'structure', 'required' => [ 'arn', ], 'members' => [ 'arn' => [ 'shape' => 'TableBucketARN', ], ], ], 'CreateTableRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', 'format', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', ], 'format' => [ 'shape' => 'OpenTableFormat', ], 'metadata' => [ 'shape' => 'TableMetadata', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 'storageClassConfiguration' => [ 'shape' => 'StorageClassConfiguration', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateTableResponse' => [ 'type' => 'structure', 'required' => [ 'tableARN', 'versionToken', ], 'members' => [ 'tableARN' => [ 'shape' => 'TableARN', ], 'versionToken' => [ 'shape' => 'VersionToken', ], ], ], 'DeleteNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], ], ], 'DeleteTableBucketEncryptionRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'DeleteTableBucketMetricsConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'DeleteTableBucketPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'DeleteTableBucketReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'querystring', 'locationName' => 'tableBucketARN', ], 'versionToken' => [ 'shape' => 'VersionToken', 'location' => 'querystring', 'locationName' => 'versionToken', ], ], ], 'DeleteTableBucketRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'DeleteTablePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'DeleteTableReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', 'versionToken', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], 'versionToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'versionToken', ], ], ], 'DeleteTableRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], 'versionToken' => [ 'shape' => 'VersionToken', 'location' => 'querystring', 'locationName' => 'versionToken', ], ], ], 'EncryptionConfiguration' => [ 'type' => 'structure', 'required' => [ 'sseAlgorithm', ], 'members' => [ 'sseAlgorithm' => [ 'shape' => 'SSEAlgorithm', ], 'kmsKeyArn' => [ 'shape' => 'EncryptionConfigurationKmsKeyArnString', ], ], ], 'EncryptionConfigurationKmsKeyArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws[-a-z0-9]*:kms:[-a-z0-9]*:[0-9]{12}:key/.+)', ], 'ErrorMessage' => [ 'type' => 'string', ], 'ForbiddenException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'GetNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], ], ], 'GetNamespaceResponse' => [ 'type' => 'structure', 'required' => [ 'namespace', 'createdAt', 'createdBy', 'ownerAccountId', ], 'members' => [ 'namespace' => [ 'shape' => 'NamespaceList', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'createdBy' => [ 'shape' => 'AccountId', ], 'ownerAccountId' => [ 'shape' => 'AccountId', ], 'namespaceId' => [ 'shape' => 'NamespaceId', ], 'tableBucketId' => [ 'shape' => 'TableBucketId', ], ], ], 'GetTableBucketEncryptionRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketEncryptionResponse' => [ 'type' => 'structure', 'required' => [ 'encryptionConfiguration', ], 'members' => [ 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], ], ], 'GetTableBucketMaintenanceConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketMaintenanceConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'configuration', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', ], 'configuration' => [ 'shape' => 'TableBucketMaintenanceConfiguration', ], ], ], 'GetTableBucketMetricsConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketMetricsConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', ], 'id' => [ 'shape' => 'String', ], ], ], 'GetTableBucketPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketPolicyResponse' => [ 'type' => 'structure', 'required' => [ 'resourcePolicy', ], 'members' => [ 'resourcePolicy' => [ 'shape' => 'ResourcePolicy', ], ], ], 'GetTableBucketReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'querystring', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketReplicationResponse' => [ 'type' => 'structure', 'required' => [ 'versionToken', 'configuration', ], 'members' => [ 'versionToken' => [ 'shape' => 'VersionToken', ], 'configuration' => [ 'shape' => 'TableBucketReplicationConfiguration', ], ], ], 'GetTableBucketRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketResponse' => [ 'type' => 'structure', 'required' => [ 'arn', 'name', 'ownerAccountId', 'createdAt', ], 'members' => [ 'arn' => [ 'shape' => 'TableBucketARN', ], 'name' => [ 'shape' => 'TableBucketName', ], 'ownerAccountId' => [ 'shape' => 'AccountId', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'tableBucketId' => [ 'shape' => 'TableBucketId', ], 'type' => [ 'shape' => 'TableBucketType', ], ], ], 'GetTableBucketStorageClassRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'GetTableBucketStorageClassResponse' => [ 'type' => 'structure', 'required' => [ 'storageClassConfiguration', ], 'members' => [ 'storageClassConfiguration' => [ 'shape' => 'StorageClassConfiguration', ], ], ], 'GetTableEncryptionRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetTableEncryptionResponse' => [ 'type' => 'structure', 'required' => [ 'encryptionConfiguration', ], 'members' => [ 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], ], ], 'GetTableMaintenanceConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetTableMaintenanceConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'tableARN', 'configuration', ], 'members' => [ 'tableARN' => [ 'shape' => 'TableARN', ], 'configuration' => [ 'shape' => 'TableMaintenanceConfiguration', ], ], ], 'GetTableMaintenanceJobStatusRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetTableMaintenanceJobStatusResponse' => [ 'type' => 'structure', 'required' => [ 'tableARN', 'status', ], 'members' => [ 'tableARN' => [ 'shape' => 'TableARN', ], 'status' => [ 'shape' => 'TableMaintenanceJobStatus', ], ], ], 'GetTableMetadataLocationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetTableMetadataLocationResponse' => [ 'type' => 'structure', 'required' => [ 'versionToken', 'warehouseLocation', ], 'members' => [ 'versionToken' => [ 'shape' => 'VersionToken', ], 'metadataLocation' => [ 'shape' => 'MetadataLocation', ], 'warehouseLocation' => [ 'shape' => 'WarehouseLocation', ], ], ], 'GetTablePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetTablePolicyResponse' => [ 'type' => 'structure', 'required' => [ 'resourcePolicy', ], 'members' => [ 'resourcePolicy' => [ 'shape' => 'ResourcePolicy', ], ], ], 'GetTableRecordExpirationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], ], ], 'GetTableRecordExpirationConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'configuration', ], 'members' => [ 'configuration' => [ 'shape' => 'TableRecordExpirationConfigurationValue', ], ], ], 'GetTableRecordExpirationJobStatusRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], ], ], 'GetTableRecordExpirationJobStatusResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'TableRecordExpirationJobStatus', ], 'lastRunTimestamp' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'failureMessage' => [ 'shape' => 'String', ], 'metrics' => [ 'shape' => 'TableRecordExpirationJobMetrics', ], ], ], 'GetTableReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], ], ], 'GetTableReplicationResponse' => [ 'type' => 'structure', 'required' => [ 'versionToken', 'configuration', ], 'members' => [ 'versionToken' => [ 'shape' => 'String', ], 'configuration' => [ 'shape' => 'TableReplicationConfiguration', ], ], ], 'GetTableReplicationStatusRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], ], ], 'GetTableReplicationStatusResponse' => [ 'type' => 'structure', 'required' => [ 'sourceTableArn', 'destinations', ], 'members' => [ 'sourceTableArn' => [ 'shape' => 'TableARN', ], 'destinations' => [ 'shape' => 'ReplicationDestinationStatuses', ], ], ], 'GetTableRequest' => [ 'type' => 'structure', 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'querystring', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'querystring', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'querystring', 'locationName' => 'name', ], 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], ], ], 'GetTableResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'type', 'tableARN', 'namespace', 'versionToken', 'warehouseLocation', 'createdAt', 'createdBy', 'modifiedAt', 'modifiedBy', 'ownerAccountId', 'format', ], 'members' => [ 'name' => [ 'shape' => 'TableName', ], 'type' => [ 'shape' => 'TableType', ], 'tableARN' => [ 'shape' => 'TableARN', ], 'namespace' => [ 'shape' => 'NamespaceList', ], 'namespaceId' => [ 'shape' => 'NamespaceId', ], 'versionToken' => [ 'shape' => 'VersionToken', ], 'metadataLocation' => [ 'shape' => 'MetadataLocation', ], 'warehouseLocation' => [ 'shape' => 'WarehouseLocation', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'createdBy' => [ 'shape' => 'AccountId', ], 'managedByService' => [ 'shape' => 'String', ], 'modifiedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'modifiedBy' => [ 'shape' => 'AccountId', ], 'ownerAccountId' => [ 'shape' => 'AccountId', ], 'format' => [ 'shape' => 'OpenTableFormat', ], 'tableBucketId' => [ 'shape' => 'TableBucketId', ], 'managedTableInformation' => [ 'shape' => 'ManagedTableInformation', ], ], ], 'GetTableStorageClassRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetTableStorageClassResponse' => [ 'type' => 'structure', 'required' => [ 'storageClassConfiguration', ], 'members' => [ 'storageClassConfiguration' => [ 'shape' => 'StorageClassConfiguration', ], ], ], 'IAMRole' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:.+:iam::[0-9]{12}:role/.+', ], 'IcebergCompactionSettings' => [ 'type' => 'structure', 'members' => [ 'targetFileSizeMB' => [ 'shape' => 'PositiveInteger', ], 'strategy' => [ 'shape' => 'IcebergCompactionStrategy', ], ], ], 'IcebergCompactionStrategy' => [ 'type' => 'string', 'enum' => [ 'auto', 'binpack', 'sort', 'z-order', ], ], 'IcebergMetadata' => [ 'type' => 'structure', 'required' => [ 'schema', ], 'members' => [ 'schema' => [ 'shape' => 'IcebergSchema', ], 'properties' => [ 'shape' => 'TableProperties', ], ], ], 'IcebergSchema' => [ 'type' => 'structure', 'required' => [ 'fields', ], 'members' => [ 'fields' => [ 'shape' => 'SchemaFieldList', ], ], ], 'IcebergSnapshotManagementSettings' => [ 'type' => 'structure', 'members' => [ 'minSnapshotsToKeep' => [ 'shape' => 'PositiveInteger', ], 'maxSnapshotAgeHours' => [ 'shape' => 'PositiveInteger', ], ], ], 'IcebergUnreferencedFileRemovalSettings' => [ 'type' => 'structure', 'members' => [ 'unreferencedDays' => [ 'shape' => 'PositiveInteger', ], 'nonCurrentDays' => [ 'shape' => 'PositiveInteger', ], ], ], 'InternalServerErrorException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'JobStatus' => [ 'type' => 'string', 'enum' => [ 'Not_Yet_Run', 'Successful', 'Failed', 'Disabled', ], ], 'LastSuccessfulReplicatedUpdate' => [ 'type' => 'structure', 'required' => [ 'metadataLocation', 'timestamp', ], 'members' => [ 'metadataLocation' => [ 'shape' => 'MetadataLocation', ], 'timestamp' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'ListNamespacesLimit' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ListNamespacesRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'prefix' => [ 'shape' => 'ListNamespacesRequestPrefixString', 'location' => 'querystring', 'locationName' => 'prefix', ], 'continuationToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'continuationToken', ], 'maxNamespaces' => [ 'shape' => 'ListNamespacesLimit', 'location' => 'querystring', 'locationName' => 'maxNamespaces', ], ], ], 'ListNamespacesRequestPrefixString' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'ListNamespacesResponse' => [ 'type' => 'structure', 'required' => [ 'namespaces', ], 'members' => [ 'namespaces' => [ 'shape' => 'NamespaceSummaryList', ], 'continuationToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTableBucketsLimit' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ListTableBucketsRequest' => [ 'type' => 'structure', 'members' => [ 'prefix' => [ 'shape' => 'ListTableBucketsRequestPrefixString', 'location' => 'querystring', 'locationName' => 'prefix', ], 'continuationToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'continuationToken', ], 'maxBuckets' => [ 'shape' => 'ListTableBucketsLimit', 'location' => 'querystring', 'locationName' => 'maxBuckets', ], 'type' => [ 'shape' => 'TableBucketType', 'location' => 'querystring', 'locationName' => 'type', ], ], ], 'ListTableBucketsRequestPrefixString' => [ 'type' => 'string', 'max' => 63, 'min' => 1, ], 'ListTableBucketsResponse' => [ 'type' => 'structure', 'required' => [ 'tableBuckets', ], 'members' => [ 'tableBuckets' => [ 'shape' => 'TableBucketSummaryList', ], 'continuationToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTablesLimit' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ListTablesRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'querystring', 'locationName' => 'namespace', ], 'prefix' => [ 'shape' => 'ListTablesRequestPrefixString', 'location' => 'querystring', 'locationName' => 'prefix', ], 'continuationToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'continuationToken', ], 'maxTables' => [ 'shape' => 'ListTablesLimit', 'location' => 'querystring', 'locationName' => 'maxTables', ], ], ], 'ListTablesRequestPrefixString' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'ListTablesResponse' => [ 'type' => 'structure', 'required' => [ 'tables', ], 'members' => [ 'tables' => [ 'shape' => 'TableSummaryList', ], 'continuationToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'Tags', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'MaintenanceStatus' => [ 'type' => 'string', 'enum' => [ 'enabled', 'disabled', ], ], 'ManagedTableInformation' => [ 'type' => 'structure', 'members' => [ 'replicationInformation' => [ 'shape' => 'ReplicationInformation', ], ], ], 'MetadataLocation' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'MethodNotAllowedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 405, 'senderFault' => true, ], 'exception' => true, ], 'NamespaceId' => [ 'type' => 'string', ], 'NamespaceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NamespaceName', ], ], 'NamespaceName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '[0-9a-z_]*', ], 'NamespaceSummary' => [ 'type' => 'structure', 'required' => [ 'namespace', 'createdAt', 'createdBy', 'ownerAccountId', ], 'members' => [ 'namespace' => [ 'shape' => 'NamespaceList', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'createdBy' => [ 'shape' => 'AccountId', ], 'ownerAccountId' => [ 'shape' => 'AccountId', ], 'namespaceId' => [ 'shape' => 'NamespaceId', ], 'tableBucketId' => [ 'shape' => 'TableBucketId', ], ], ], 'NamespaceSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NamespaceSummary', ], ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'OpenTableFormat' => [ 'type' => 'string', 'enum' => [ 'ICEBERG', ], ], 'PositiveInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 2147483647, 'min' => 1, ], 'PutTableBucketEncryptionRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'encryptionConfiguration', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], ], ], 'PutTableBucketMaintenanceConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'type', 'value', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'type' => [ 'shape' => 'TableBucketMaintenanceType', 'location' => 'uri', 'locationName' => 'type', ], 'value' => [ 'shape' => 'TableBucketMaintenanceConfigurationValue', ], ], ], 'PutTableBucketMetricsConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], ], ], 'PutTableBucketPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'resourcePolicy', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'resourcePolicy' => [ 'shape' => 'ResourcePolicy', ], ], ], 'PutTableBucketReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'configuration', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'querystring', 'locationName' => 'tableBucketARN', ], 'versionToken' => [ 'shape' => 'VersionToken', 'location' => 'querystring', 'locationName' => 'versionToken', ], 'configuration' => [ 'shape' => 'TableBucketReplicationConfiguration', ], ], ], 'PutTableBucketReplicationResponse' => [ 'type' => 'structure', 'required' => [ 'versionToken', 'status', ], 'members' => [ 'versionToken' => [ 'shape' => 'VersionToken', ], 'status' => [ 'shape' => 'String', ], ], ], 'PutTableBucketStorageClassRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'storageClassConfiguration', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'storageClassConfiguration' => [ 'shape' => 'StorageClassConfiguration', ], ], ], 'PutTableMaintenanceConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', 'type', 'value', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], 'type' => [ 'shape' => 'TableMaintenanceType', 'location' => 'uri', 'locationName' => 'type', ], 'value' => [ 'shape' => 'TableMaintenanceConfigurationValue', ], ], ], 'PutTablePolicyRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', 'resourcePolicy', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], 'resourcePolicy' => [ 'shape' => 'ResourcePolicy', ], ], ], 'PutTableRecordExpirationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', 'value', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], 'value' => [ 'shape' => 'TableRecordExpirationConfigurationValue', ], ], ], 'PutTableReplicationRequest' => [ 'type' => 'structure', 'required' => [ 'tableArn', 'configuration', ], 'members' => [ 'tableArn' => [ 'shape' => 'TableARN', 'location' => 'querystring', 'locationName' => 'tableArn', ], 'versionToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'versionToken', ], 'configuration' => [ 'shape' => 'TableReplicationConfiguration', ], ], ], 'PutTableReplicationResponse' => [ 'type' => 'structure', 'required' => [ 'versionToken', 'status', ], 'members' => [ 'versionToken' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'String', ], ], ], 'RenameTableRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], 'newNamespaceName' => [ 'shape' => 'NamespaceName', ], 'newName' => [ 'shape' => 'TableName', ], 'versionToken' => [ 'shape' => 'VersionToken', ], ], ], 'ReplicationDestination' => [ 'type' => 'structure', 'required' => [ 'destinationTableBucketARN', ], 'members' => [ 'destinationTableBucketARN' => [ 'shape' => 'TableBucketARN', ], ], ], 'ReplicationDestinationStatusModel' => [ 'type' => 'structure', 'required' => [ 'replicationStatus', 'destinationTableBucketArn', ], 'members' => [ 'replicationStatus' => [ 'shape' => 'ReplicationStatus', ], 'destinationTableBucketArn' => [ 'shape' => 'TableBucketARN', ], 'destinationTableArn' => [ 'shape' => 'TableARN', ], 'lastSuccessfulReplicatedUpdate' => [ 'shape' => 'LastSuccessfulReplicatedUpdate', ], 'failureMessage' => [ 'shape' => 'String', ], ], ], 'ReplicationDestinationStatuses' => [ 'type' => 'list', 'member' => [ 'shape' => 'ReplicationDestinationStatusModel', ], 'max' => 5, 'min' => 1, ], 'ReplicationDestinations' => [ 'type' => 'list', 'member' => [ 'shape' => 'ReplicationDestination', ], 'max' => 5, 'min' => 1, ], 'ReplicationInformation' => [ 'type' => 'structure', 'required' => [ 'sourceTableARN', ], 'members' => [ 'sourceTableARN' => [ 'shape' => 'TableARN', ], ], ], 'ReplicationStatus' => [ 'type' => 'string', 'enum' => [ 'pending', 'completed', 'failed', ], ], 'ResourceArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:aws[-a-z0-9]*:[a-z0-9]+:[-a-z0-9]*:[0-9]{12}:bucket/.+', ], 'ResourcePolicy' => [ 'type' => 'string', 'max' => 20480, 'min' => 1, ], 'SSEAlgorithm' => [ 'type' => 'string', 'enum' => [ 'AES256', 'aws:kms', ], ], 'SchemaField' => [ 'type' => 'structure', 'required' => [ 'name', 'type', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], 'required' => [ 'shape' => 'Boolean', ], ], ], 'SchemaFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SchemaField', ], ], 'StorageClass' => [ 'type' => 'string', 'enum' => [ 'STANDARD', 'INTELLIGENT_TIERING', ], ], 'StorageClassConfiguration' => [ 'type' => 'structure', 'required' => [ 'storageClass', ], 'members' => [ 'storageClass' => [ 'shape' => 'StorageClass', ], ], ], 'String' => [ 'type' => 'string', ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TableARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws[-a-z0-9]*:[a-z0-9]+:[-a-z0-9]*:[0-9]{12}:bucket/[a-z0-9_-]{3,63}/table/[a-zA-Z0-9-_]{1,255})', ], 'TableBucketARN' => [ 'type' => 'string', 'pattern' => '(arn:aws[-a-z0-9]*:[a-z0-9]+:[-a-z0-9]*:[0-9]{12}:bucket/[a-z0-9_-]{3,63})', ], 'TableBucketId' => [ 'type' => 'string', ], 'TableBucketMaintenanceConfiguration' => [ 'type' => 'map', 'key' => [ 'shape' => 'TableBucketMaintenanceType', ], 'value' => [ 'shape' => 'TableBucketMaintenanceConfigurationValue', ], ], 'TableBucketMaintenanceConfigurationValue' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'MaintenanceStatus', ], 'settings' => [ 'shape' => 'TableBucketMaintenanceSettings', ], ], ], 'TableBucketMaintenanceSettings' => [ 'type' => 'structure', 'members' => [ 'icebergUnreferencedFileRemoval' => [ 'shape' => 'IcebergUnreferencedFileRemovalSettings', ], ], 'union' => true, ], 'TableBucketMaintenanceType' => [ 'type' => 'string', 'enum' => [ 'icebergUnreferencedFileRemoval', ], ], 'TableBucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '[0-9a-z-]*', ], 'TableBucketReplicationConfiguration' => [ 'type' => 'structure', 'required' => [ 'role', 'rules', ], 'members' => [ 'role' => [ 'shape' => 'IAMRole', ], 'rules' => [ 'shape' => 'TableBucketReplicationRules', ], ], ], 'TableBucketReplicationRule' => [ 'type' => 'structure', 'required' => [ 'destinations', ], 'members' => [ 'destinations' => [ 'shape' => 'ReplicationDestinations', ], ], ], 'TableBucketReplicationRules' => [ 'type' => 'list', 'member' => [ 'shape' => 'TableBucketReplicationRule', ], 'max' => 1, 'min' => 1, ], 'TableBucketSummary' => [ 'type' => 'structure', 'required' => [ 'arn', 'name', 'ownerAccountId', 'createdAt', ], 'members' => [ 'arn' => [ 'shape' => 'TableBucketARN', ], 'name' => [ 'shape' => 'TableBucketName', ], 'ownerAccountId' => [ 'shape' => 'AccountId', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'tableBucketId' => [ 'shape' => 'TableBucketId', ], 'type' => [ 'shape' => 'TableBucketType', ], ], ], 'TableBucketSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TableBucketSummary', ], ], 'TableBucketType' => [ 'type' => 'string', 'enum' => [ 'customer', 'aws', ], ], 'TableMaintenanceConfiguration' => [ 'type' => 'map', 'key' => [ 'shape' => 'TableMaintenanceType', ], 'value' => [ 'shape' => 'TableMaintenanceConfigurationValue', ], ], 'TableMaintenanceConfigurationValue' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'MaintenanceStatus', ], 'settings' => [ 'shape' => 'TableMaintenanceSettings', ], ], ], 'TableMaintenanceJobStatus' => [ 'type' => 'map', 'key' => [ 'shape' => 'TableMaintenanceJobType', ], 'value' => [ 'shape' => 'TableMaintenanceJobStatusValue', ], ], 'TableMaintenanceJobStatusValue' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'JobStatus', ], 'lastRunTimestamp' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'failureMessage' => [ 'shape' => 'String', ], ], ], 'TableMaintenanceJobType' => [ 'type' => 'string', 'enum' => [ 'icebergCompaction', 'icebergSnapshotManagement', 'icebergUnreferencedFileRemoval', ], ], 'TableMaintenanceSettings' => [ 'type' => 'structure', 'members' => [ 'icebergCompaction' => [ 'shape' => 'IcebergCompactionSettings', ], 'icebergSnapshotManagement' => [ 'shape' => 'IcebergSnapshotManagementSettings', ], ], 'union' => true, ], 'TableMaintenanceType' => [ 'type' => 'string', 'enum' => [ 'icebergCompaction', 'icebergSnapshotManagement', ], ], 'TableMetadata' => [ 'type' => 'structure', 'members' => [ 'iceberg' => [ 'shape' => 'IcebergMetadata', ], ], 'union' => true, ], 'TableName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '[0-9a-z_]*', ], 'TableProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'TableRecordExpirationConfigurationValue' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'TableRecordExpirationStatus', ], 'settings' => [ 'shape' => 'TableRecordExpirationSettings', ], ], ], 'TableRecordExpirationJobMetrics' => [ 'type' => 'structure', 'members' => [ 'deletedDataFiles' => [ 'shape' => 'Long', ], 'deletedRecords' => [ 'shape' => 'Long', ], 'removedFilesSize' => [ 'shape' => 'Long', ], ], ], 'TableRecordExpirationJobStatus' => [ 'type' => 'string', 'enum' => [ 'NotYetRun', 'Successful', 'Failed', 'Disabled', ], ], 'TableRecordExpirationSettings' => [ 'type' => 'structure', 'members' => [ 'days' => [ 'shape' => 'PositiveInteger', ], ], ], 'TableRecordExpirationStatus' => [ 'type' => 'string', 'enum' => [ 'enabled', 'disabled', ], ], 'TableReplicationConfiguration' => [ 'type' => 'structure', 'required' => [ 'role', 'rules', ], 'members' => [ 'role' => [ 'shape' => 'IAMRole', ], 'rules' => [ 'shape' => 'TableReplicationRules', ], ], ], 'TableReplicationRule' => [ 'type' => 'structure', 'required' => [ 'destinations', ], 'members' => [ 'destinations' => [ 'shape' => 'ReplicationDestinations', ], ], ], 'TableReplicationRules' => [ 'type' => 'list', 'member' => [ 'shape' => 'TableReplicationRule', ], 'max' => 1, 'min' => 1, ], 'TableSummary' => [ 'type' => 'structure', 'required' => [ 'namespace', 'name', 'type', 'tableARN', 'createdAt', 'modifiedAt', ], 'members' => [ 'namespace' => [ 'shape' => 'NamespaceList', ], 'name' => [ 'shape' => 'TableName', ], 'type' => [ 'shape' => 'TableType', ], 'tableARN' => [ 'shape' => 'TableARN', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'modifiedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'managedByService' => [ 'shape' => 'String', ], 'namespaceId' => [ 'shape' => 'NamespaceId', ], 'tableBucketId' => [ 'shape' => 'TableBucketId', ], ], ], 'TableSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TableSummary', ], ], 'TableType' => [ 'type' => 'string', 'enum' => [ 'customer', 'aws', ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'Tags' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], 'TooManyRequestsException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateTableMetadataLocationRequest' => [ 'type' => 'structure', 'required' => [ 'tableBucketARN', 'namespace', 'name', 'versionToken', 'metadataLocation', ], 'members' => [ 'tableBucketARN' => [ 'shape' => 'TableBucketARN', 'location' => 'uri', 'locationName' => 'tableBucketARN', ], 'namespace' => [ 'shape' => 'NamespaceName', 'location' => 'uri', 'locationName' => 'namespace', ], 'name' => [ 'shape' => 'TableName', 'location' => 'uri', 'locationName' => 'name', ], 'versionToken' => [ 'shape' => 'VersionToken', ], 'metadataLocation' => [ 'shape' => 'MetadataLocation', ], ], ], 'UpdateTableMetadataLocationResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'tableARN', 'namespace', 'versionToken', 'metadataLocation', ], 'members' => [ 'name' => [ 'shape' => 'TableName', ], 'tableARN' => [ 'shape' => 'TableARN', ], 'namespace' => [ 'shape' => 'NamespaceList', ], 'versionToken' => [ 'shape' => 'VersionToken', ], 'metadataLocation' => [ 'shape' => 'MetadataLocation', ], ], ], 'VersionToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'WarehouseLocation' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], ],];
