/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import org.xml.sax.Attributes;

public final class PermutingAttributesWrapper
implements Attributes {
    private final Attributes delegate;
    private final int[] permutation;

    public PermutingAttributesWrapper(Attributes delegate) {
        this.delegate = delegate;
        this.permutation = new int[delegate.getLength()];
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
    }

    private int findIndex(int index) {
        if (index < 0) {
            return -1;
        }
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] != index) continue;
            return i;
        }
        throw new IllegalArgumentException("Index not in range.");
    }

    public void pullUp(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        if (index <= 0) {
            return;
        }
        int temp = this.permutation[index];
        System.arraycopy(this.permutation, 0, this.permutation, 1, index);
        this.permutation[0] = temp;
    }

    public void pushDown(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        if (index < 0 || index == this.permutation.length - 1) {
            return;
        }
        int temp = this.permutation[index];
        System.arraycopy(this.permutation, index + 1, this.permutation, index, this.permutation.length - 1 - index);
        this.permutation[this.permutation.length - 1] = temp;
    }

    @Override
    public int getIndex(String uri, String localName) {
        return this.findIndex(this.delegate.getIndex(uri, localName));
    }

    @Override
    public int getIndex(String qName) {
        return this.findIndex(this.delegate.getIndex(qName));
    }

    @Override
    public int getLength() {
        return this.permutation.length;
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 && index >= this.permutation.length) {
            return null;
        }
        return this.delegate.getLocalName(this.permutation[index]);
    }

    @Override
    public String getQName(int index) {
        if (index < 0 && index >= this.permutation.length) {
            return null;
        }
        return this.delegate.getQName(this.permutation[index]);
    }

    @Override
    public String getType(int index) {
        if (index < 0 && index >= this.permutation.length) {
            return null;
        }
        return this.delegate.getType(this.permutation[index]);
    }

    @Override
    public String getType(String uri, String localName) {
        return this.delegate.getType(uri, localName);
    }

    @Override
    public String getType(String qName) {
        return this.delegate.getType(qName);
    }

    @Override
    public String getURI(int index) {
        if (index < 0 && index >= this.permutation.length) {
            return null;
        }
        return this.delegate.getURI(this.permutation[index]);
    }

    @Override
    public String getValue(int index) {
        if (index < 0 && index >= this.permutation.length) {
            return null;
        }
        return this.delegate.getValue(this.permutation[index]);
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.delegate.getValue(uri, localName);
    }

    @Override
    public String getValue(String qName) {
        return this.delegate.getValue(qName);
    }
}

