/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.StrictErrorHandler;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import java.io.IOException;
import java.io.InputStream;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.io.DataUri;
import nu.validator.io.DataUriException;
import org.relaxng.datatype.DatatypeException;

public class IriRef
extends AbstractDatatype {
    private static final int ELIDE_LIMIT = 50;
    public static final IriRef THE_INSTANCE = new IriRef();
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");

    protected IriRef() {
    }

    private final CharSequencePair splitScheme(CharSequence iri) {
        StringBuilder sb = new StringBuilder();
        Boolean atSchemeBeginning = true;
        for (int i = 0; i < iri.length(); ++i) {
            char c = IriRef.toAsciiLowerCase(iri.charAt(i));
            if (atSchemeBeginning.booleanValue()) {
                if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
                if ('a' <= c && 'z' >= c) {
                    atSchemeBeginning = false;
                    sb.append(c);
                    continue;
                }
                return null;
            }
            if ('a' <= c && 'z' >= c || '0' <= c && '9' >= c || c == '+' || c == '.') {
                sb.append(c);
                continue;
            }
            if (c == ':') {
                return new CharSequencePair(sb, iri.subSequence(i + 1, iri.length()));
            }
            return null;
        }
        return null;
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        String messagePrologue = "";
        int length = literal.length();
        String urlString = literal.toString();
        if (this.reportValue()) {
            if (length < 50) {
                messagePrologue = "\u201c" + literal + "\u201d: ";
            } else {
                StringBuilder sb = new StringBuilder(51);
                sb.append(literal, 0, 25);
                sb.append('\u2026');
                sb.append(literal, length - 25, length);
                messagePrologue = "\u201c" + sb.toString() + "\u201d: ";
            }
        }
        if ("".equals(IriRef.trimHtmlSpaces(urlString))) {
            throw this.newDatatypeException("Must be non-empty.");
        }
        URL url = null;
        URLParsingSettings settings = URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance());
        boolean data = false;
        try {
            CharSequencePair pair = this.splitScheme(literal);
            if (pair == null) {
                if (this.isAbsolute()) {
                    throw this.newDatatypeException("The string \u201c" + literal + "\u201d is not an absolute URL.");
                }
                if (this.mustBeHttpOrHttps()) {
                    throw this.newDatatypeException("Must contain only \u201chttp\u201d or \u201chttps\u201d URLs.");
                }
                url = URL.parse(settings, URL.parse("http://example.org/foo/bar"), urlString);
            } else {
                StringBuilder sb;
                CharSequence scheme = pair.getHead();
                CharSequence tail = pair.getTail();
                if (this.mustBeHttpOrHttps() && !this.isHttpOrHttps(scheme)) {
                    throw this.newDatatypeException("Must contain only \u201chttp\u201d or \u201chttps\u201d URLs.");
                }
                if (this.isWellKnown(scheme)) {
                    url = URL.parse(settings, urlString);
                } else if ("javascript".contentEquals(scheme)) {
                    url = null;
                } else if ("data".contentEquals(scheme)) {
                    data = true;
                    url = URL.parse(settings, urlString);
                } else if (this.isHttpAlias(scheme)) {
                    sb = new StringBuilder(5 + tail.length());
                    sb.append("http:").append(tail);
                    url = URL.parse(settings, sb.toString());
                } else {
                    sb = new StringBuilder(2 + literal.length());
                    sb.append("x-").append(literal);
                    url = URL.parse(settings, sb.toString());
                }
            }
        }
        catch (GalimatiasParseException e) {
            throw this.newDatatypeException(messagePrologue + e.getMessage() + ".");
        }
        if (url != null && data) {
            try {
                DataUri dataUri = new DataUri(url);
                InputStream is = dataUri.getInputStream();
                while (is.read() >= 0) {
                }
            }
            catch (DataUriException e) {
                throw this.newDatatypeException(e.getIndex(), e.getHead(), e.getLiteral(), e.getTail());
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (WARN && "Fragment is not allowed for data: URIs according to RFC 2397.".equals(msg)) {
                    throw this.newDatatypeException(messagePrologue + msg, WARN);
                }
                throw this.newDatatypeException(messagePrologue + msg);
            }
        }
    }

    private final boolean isHttpOrHttps(CharSequence scheme) {
        return "http".contentEquals(scheme) || "https".contentEquals(scheme);
    }

    private final boolean isHttpAlias(CharSequence scheme) {
        return "feed".contentEquals(scheme) || "webcal".contentEquals(scheme);
    }

    private final boolean isWellKnown(CharSequence scheme) {
        return "http".contentEquals(scheme) || "https".contentEquals(scheme) || "ftp".contentEquals(scheme) || "mailto".contentEquals(scheme) || "file".contentEquals(scheme);
    }

    protected boolean isAbsolute() {
        return false;
    }

    protected boolean reportValue() {
        return false;
    }

    protected static final String trimHtmlSpaces(String str) {
        return IriRef.trimHtmlLeadingSpaces(IriRef.trimHtmlTrailingSpaces(str));
    }

    protected static final String trimHtmlLeadingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length(); i > 0; --i) {
            char c = str.charAt(str.length() - i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(str.length() - i, str.length());
        }
        return "";
    }

    protected static final String trimHtmlTrailingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    protected boolean mustBeHttpOrHttps() {
        return false;
    }

    @Override
    public String getName() {
        return "URL";
    }

    private class CharSequencePair {
        private final CharSequence head;
        private final CharSequence tail;

        public CharSequencePair(CharSequence head, CharSequence tail) {
            this.head = head;
            this.tail = tail;
        }

        public CharSequence getHead() {
            return this.head;
        }

        public CharSequence getTail() {
            return this.tail;
        }
    }
}

