/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.SingleNodeExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class ParentNodeExpression
extends SingleNodeExpression {
    public NodeInfo getNode(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set", "XPDY0002", context);
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getParent();
        }
        this.dynamicError("The context item for the parent axis (..) is not a node", "XPTY0020", context);
        return null;
    }

    public Expression copy() {
        return new ParentNodeExpression();
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        AxisExpression parent = new AxisExpression(9, AnyNodeTest.getInstance());
        parent.setContainer(this.getContainer());
        return parent.addToPathMap(pathMap, pathMapNodeSet);
    }

    public boolean equals(Object other) {
        return other instanceof ParentNodeExpression;
    }

    public int hashCode() {
        return "ParentNodeExpression".hashCode();
    }

    public String toString() {
        return "..";
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("parent");
        destination.endElement();
    }
}

