/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.URLUtils;
import io.mola.galimatias.canonicalize.CharacterPredicate;
import io.mola.galimatias.canonicalize.URLCanonicalizer;

abstract class BaseURLCanonicalizer
implements URLCanonicalizer {
    BaseURLCanonicalizer() {
    }

    protected static String canonicalize(String input, CharacterPredicate unencodedPredicate) {
        int c;
        StringBuilder result = new StringBuilder();
        int length = input.length();
        for (int offset = 0; offset < length; offset += Character.charCount(c)) {
            byte[] bytes;
            c = input.codePointAt(offset);
            if (c == 37 && input.length() > offset + 2 && URLUtils.isASCIIHexDigit(input.charAt(offset + 1)) && URLUtils.isASCIIHexDigit(input.charAt(offset + 2)) || unencodedPredicate.test(c)) {
                result.append((char)c);
                continue;
            }
            for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
                URLUtils.percentEncode(b, result);
            }
        }
        return result.toString();
    }
}

