/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.totp.TOTPAuthenticationProviderModule;
import org.apache.guacamole.auth.totp.user.CodeUsageTrackingService;
import org.apache.guacamole.auth.totp.user.TOTPUserContext;
import org.apache.guacamole.auth.totp.user.UserVerificationService;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;

public class TOTPAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final Injector injector = Guice.createInjector((Module[])new Module[]{new TOTPAuthenticationProviderModule((AuthenticationProvider)this)});

    public String getIdentifier() {
        return "totp";
    }

    public UserContext decorate(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        UserVerificationService verificationService = (UserVerificationService)this.injector.getInstance(UserVerificationService.class);
        verificationService.verifyIdentity(context, authenticatedUser);
        return new TOTPUserContext(context);
    }

    public UserContext redecorate(UserContext decorated, UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        return new TOTPUserContext(context);
    }

    public void shutdown() {
        ((CodeUsageTrackingService)this.injector.getInstance(CodeUsageTrackingService.class)).shutdown();
    }
}

