/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 923268084968181479L;

    @Deprecated
    public static KeyDeserializer constructStringKeyDeserializer(DeserializationConfig config, JavaType type) {
        return StdKeyDeserializer.StringKD.forType(type.getRawClass());
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type) {
        Object beanDesc = config.introspect(type);
        Constructor<?> ctor = ((BeanDescription)beanDesc).findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor);
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = ((BeanDescription)beanDesc).findFactoryMethod(String.class);
        if (m != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m);
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw == String.class || raw == Object.class) {
            return StdKeyDeserializer.StringKD.forType(raw);
        }
        if (raw == UUID.class) {
            return new StdKeyDeserializer.UuidKD();
        }
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        if (raw == Integer.class) {
            return new StdKeyDeserializer.IntKD();
        }
        if (raw == Long.class) {
            return new StdKeyDeserializer.LongKD();
        }
        if (raw == Date.class) {
            return new StdKeyDeserializer.DateKD();
        }
        if (raw == Calendar.class) {
            return new StdKeyDeserializer.CalendarKD();
        }
        if (raw == Boolean.class) {
            return new StdKeyDeserializer.BoolKD();
        }
        if (raw == Byte.class) {
            return new StdKeyDeserializer.ByteKD();
        }
        if (raw == Character.class) {
            return new StdKeyDeserializer.CharKD();
        }
        if (raw == Short.class) {
            return new StdKeyDeserializer.ShortKD();
        }
        if (raw == Float.class) {
            return new StdKeyDeserializer.FloatKD();
        }
        if (raw == Double.class) {
            return new StdKeyDeserializer.DoubleKD();
        }
        if (raw == Locale.class) {
            return new StdKeyDeserializer.LocaleKD();
        }
        return null;
    }
}

