/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceStatus;
import com.amazonaws.services.ec2.model.transform.InstanceStateStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.InstanceStatusEventStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.InstanceStatusSummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class InstanceStatusStaxUnmarshaller
implements Unmarshaller<InstanceStatus, StaxUnmarshallerContext> {
    private static InstanceStatusStaxUnmarshaller instance;

    public InstanceStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceStatus instanceStatus = new InstanceStatus();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return instanceStatus;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("instanceId", targetDepth)) {
                    instanceStatus.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    instanceStatus.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventsSet/item", targetDepth)) {
                    instanceStatus.getEvents().add(InstanceStatusEventStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceState", targetDepth)) {
                    instanceStatus.setInstanceState(InstanceStateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("systemStatus", targetDepth)) {
                    instanceStatus.setSystemStatus(InstanceStatusSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceStatus", targetDepth)) continue;
                instanceStatus.setInstanceStatus(InstanceStatusSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceStatus;
    }

    public static InstanceStatusStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceStatusStaxUnmarshaller();
        }
        return instance;
    }
}

