/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class RetrievalMethodTest
extends TestCase {
    private KeyInfoFactory fac;

    public RetrievalMethodTest() {
        super("RetrievalMethodTest");
    }

    public RetrievalMethodTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.fac = KeyInfoFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testgetURI() {
        RetrievalMethod retrievalMethod = this.fac.newRetrievalMethod("#X509Data");
        RetrievalMethodTest.assertNotNull((Object)retrievalMethod.getURI());
    }

    public void testgetTransforms() {
        RetrievalMethod retrievalMethod = this.fac.newRetrievalMethod("#X509Data");
        RetrievalMethodTest.assertNotNull(retrievalMethod.getTransforms());
    }

    public void testgetType() {
        RetrievalMethod retrievalMethod = this.fac.newRetrievalMethod("#X509Data");
        RetrievalMethodTest.assertNull((Object)retrievalMethod.getType());
    }

    public void testConstructors() {
        RetrievalMethod retrievalMethod = this.fac.newRetrievalMethod("#X509CertChain");
        RetrievalMethodTest.assertEquals((String)"#X509CertChain", (String)retrievalMethod.getURI());
        try {
            retrievalMethod = this.fac.newRetrievalMethod(null);
            RetrievalMethodTest.fail((String)"Should raise a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            retrievalMethod = this.fac.newRetrievalMethod(null, null, null);
            RetrievalMethodTest.fail((String)"Should raise a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        retrievalMethod = this.fac.newRetrievalMethod("#X509CertChain", "http://www.w3.org/2000/09/xmldsig#X509Data", null);
        RetrievalMethodTest.assertEquals((String)"#X509CertChain", (String)retrievalMethod.getURI());
        RetrievalMethodTest.assertEquals((String)"http://www.w3.org/2000/09/xmldsig#X509Data", (String)retrievalMethod.getType());
    }

    public void testisFeatureSupported() throws Exception {
        String string = "#X509CertChain";
        String string2 = "http://www.w3.org/2000/09/xmldsig#X509Data";
        XMLStructure xMLStructure = null;
        for (int i = 0; i < 2; ++i) {
            switch (i) {
                case 0: {
                    xMLStructure = this.fac.newRetrievalMethod(string);
                    break;
                }
                case 1: {
                    xMLStructure = this.fac.newRetrievalMethod(string, string2, null);
                }
            }
            try {
                xMLStructure.isFeatureSupported(null);
                RetrievalMethodTest.fail((String)"Should raise a NPE for null feature");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            RetrievalMethodTest.assertTrue((!xMLStructure.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }
}

