/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

public class Frequency {
    private double _avgInterval;
    private double _minAverageInterval;
    private final long _period;
    private long _lastEvent;
    private final long _start = Frequency.now();
    private long _count;

    public Frequency(long period) {
        this._period = period;
        this._minAverageInterval = this._avgInterval = (double)(period + 1L);
    }

    public long getPeriod() {
        return this._period;
    }

    @Deprecated
    public synchronized long getLastEvent() {
        return this._lastEvent;
    }

    public synchronized double getAverageInterval() {
        return this._avgInterval;
    }

    @Deprecated
    public synchronized double getMinAverageInterval() {
        return this._minAverageInterval;
    }

    public synchronized double getAverageEventsPerPeriod() {
        if (this._avgInterval > 0.0) {
            return (double)this._period / this._avgInterval;
        }
        return 0.0;
    }

    public synchronized double getMaxAverageEventsPerPeriod() {
        if (this._minAverageInterval > 0.0 && this._minAverageInterval <= (double)this._period) {
            return (double)this._period / this._minAverageInterval;
        }
        return 0.0;
    }

    public synchronized double getStrictAverageInterval() {
        long duration = Frequency.now() - this._start;
        if (duration <= 0L || this._count <= 0L) {
            return Double.MAX_VALUE;
        }
        return (double)duration / (double)this._count;
    }

    public synchronized double getStrictAverageEventsPerPeriod() {
        double avgInterval = this.getStrictAverageInterval();
        if (avgInterval > 0.0) {
            return (double)this._period / avgInterval;
        }
        return 0.0;
    }

    public synchronized long getEventCount() {
        return this._count;
    }

    public void eventOccurred() {
        this.recalculate(true);
    }

    public void recalculate() {
        this.recalculate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculate(boolean eventOccurred) {
        Frequency frequency = this;
        synchronized (frequency) {
            long now = Frequency.now();
            long interval = now - this._lastEvent;
            if (interval > this._period) {
                interval = this._period;
            } else if (interval <= 0L) {
                interval = 1L;
            }
            if (interval >= this._period && !eventOccurred) {
                this._avgInterval = this._period + 1L;
            } else {
                double oldWeight = 1.0f - (float)interval / (float)this._period;
                double newWeight = (float)interval / (float)this._period;
                double oldInterval = this._avgInterval * oldWeight;
                double newInterval = (double)interval * newWeight;
                this._avgInterval = oldInterval + newInterval;
            }
            if (this._avgInterval < this._minAverageInterval || this._minAverageInterval <= 0.0) {
                this._minAverageInterval = this._avgInterval;
            }
            if (eventOccurred) {
                this._lastEvent = now;
                ++this._count;
            }
        }
    }

    private static final long now() {
        return System.currentTimeMillis();
    }

    synchronized void store(StringBuilder dest) {
        dest.append("avgInterval:").append(this._avgInterval).append(',');
        dest.append("minAverageInterval").append(this._minAverageInterval).append(',');
        dest.append("lastEvent").append(this._lastEvent).append(",");
        dest.append("count").append(this._count);
    }
}

