/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.DHClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDhClientKeyExchangePreparator
extends DHClientKeyExchangePreparator<PskDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskDhClientKeyExchangeMessage msg;
    private ByteArrayOutputStream outputStream;

    public PskDhClientKeyExchangePreparator(Chooser chooser, PskDhClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        super.prepareHandshakeMessageContents();
    }

    @Override
    protected byte[] calculatePremasterSecret(BigInteger modulus, BigInteger privateKey, BigInteger publicKey) {
        byte[] otherSecret = super.calculatePremasterSecret(modulus, privateKey, publicKey);
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.outputStream.write(ArrayConverter.intToBytes((int)otherSecret.length, (int)2));
            LOGGER.debug("OtherSecret Length: " + otherSecret.length);
            this.outputStream.write(otherSecret);
            LOGGER.debug("OtherSecret: " + ArrayConverter.bytesToHexString((byte[])otherSecret));
            this.outputStream.write(ArrayConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
            this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        }
        catch (IOException ex) {
            LOGGER.warn("Encountered exception while writing to ByteArrayOutputStream.");
            LOGGER.debug((Object)ex);
        }
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        LOGGER.debug("PSK PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])tempPremasterSecret));
        return tempPremasterSecret;
    }
}

