/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.values;

import java.util.Collection;
import org.jfree.layouting.input.style.values.CSSValue;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class CSSValueList
implements CSSValue,
Cloneable {
    private CSSValue[] values;

    public CSSValueList(Collection collection) {
        CSSValue[] cSSValueArray = new CSSValue[collection.size()];
        this.values = collection.toArray(cSSValueArray);
    }

    public CSSValueList(CSSValue[] cSSValueArray) {
        this.values = cSSValueArray;
    }

    public int getLength() {
        return this.values.length;
    }

    public CSSValue getItem(int n) {
        return this.values[n];
    }

    @Override
    public String getCSSText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            CSSValue cSSValue = this.values[i];
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(cSSValue);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getCSSText();
    }

    public boolean contains(CSSValue cSSValue) {
        for (int i = 0; i < this.values.length; ++i) {
            CSSValue cSSValue2 = this.values[i];
            if (!ObjectUtilities.equal((Object)cSSValue2, (Object)cSSValue)) continue;
            return true;
        }
        return false;
    }

    public static CSSValueList createList(CSSValue cSSValue) {
        return new CSSValueList(new CSSValue[]{cSSValue});
    }

    public static CSSValueList createDuoList(CSSValue cSSValue) {
        return CSSValueList.createDuoList(cSSValue, cSSValue);
    }

    public static CSSValueList createDuoList(CSSValue cSSValue, CSSValue cSSValue2) {
        CSSValue[] cSSValueArray = new CSSValue[]{cSSValue, cSSValue2};
        return new CSSValueList(cSSValueArray);
    }

    public static CSSValueList createQuadList(CSSValue cSSValue) {
        return CSSValueList.createQuadList(cSSValue, cSSValue);
    }

    public static CSSValueList createQuadList(CSSValue cSSValue, CSSValue cSSValue2) {
        return CSSValueList.createQuadList(cSSValue, cSSValue2, cSSValue, cSSValue2);
    }

    public static CSSValueList createQuadList(CSSValue cSSValue, CSSValue cSSValue2, CSSValue cSSValue3, CSSValue cSSValue4) {
        CSSValue[] cSSValueArray = new CSSValue[]{cSSValue, cSSValue2, cSSValue3, cSSValue4};
        return new CSSValueList(cSSValueArray);
    }

    public static CSSValueList insertFirst(CSSValueList cSSValueList, CSSValue cSSValue) {
        int n = cSSValueList.values.length;
        CSSValue[] cSSValueArray = new CSSValue[n + 1];
        cSSValueArray[0] = cSSValue;
        System.arraycopy(cSSValueList.values, 0, cSSValueArray, 1, n);
        return new CSSValueList(cSSValueArray);
    }

    public static CSSValueList insertLast(CSSValueList cSSValueList, CSSValue cSSValue) {
        int n = cSSValueList.values.length;
        CSSValue[] cSSValueArray = new CSSValue[n + 1];
        System.arraycopy(cSSValueList.values, 0, cSSValueArray, 0, n);
        cSSValueArray[n] = cSSValue;
        return new CSSValueList(cSSValueArray);
    }

    public Object clone() {
        try {
            CSSValueList cSSValueList = (CSSValueList)super.clone();
            cSSValueList.values = (CSSValue[])this.values.clone();
            return cSSValueList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalAccessError("Clone cannot be unsupported.");
        }
    }
}

