/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.keycloak.common.crypto.CryptoIntegration;

public class PemUtils {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String END_RSA_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";

    public static X509Certificate decodeCertificate(String cert) {
        return CryptoIntegration.getProvider().getPemUtils().decodeCertificate(cert);
    }

    public static PublicKey decodePublicKey(String pem) {
        return CryptoIntegration.getProvider().getPemUtils().decodePublicKey(pem);
    }

    public static PublicKey decodePublicKey(String pem, String type) {
        return CryptoIntegration.getProvider().getPemUtils().decodePublicKey(pem, type);
    }

    public static PrivateKey decodePrivateKey(String pem) {
        return CryptoIntegration.getProvider().getPemUtils().decodePrivateKey(pem);
    }

    public static String encodeKey(Key key) {
        return CryptoIntegration.getProvider().getPemUtils().encodeKey(key);
    }

    public static String encodeCertificate(Certificate certificate) {
        return CryptoIntegration.getProvider().getPemUtils().encodeCertificate(certificate);
    }

    public static byte[] pemToDer(String pem) {
        return CryptoIntegration.getProvider().getPemUtils().pemToDer(pem);
    }

    public static String removeBeginEnd(String pem) {
        return CryptoIntegration.getProvider().getPemUtils().removeBeginEnd(pem);
    }

    public static String addPrivateKeyBeginEnd(String privateKeyPem) {
        return "-----BEGIN PRIVATE KEY-----\n" + privateKeyPem + "\n-----END PRIVATE KEY-----";
    }

    public static String addRsaPrivateKeyBeginEnd(String privateKeyPem) {
        return "-----BEGIN RSA PRIVATE KEY-----\n" + privateKeyPem + "\n-----END RSA PRIVATE KEY-----";
    }

    public static String generateThumbprint(String[] certChain, String encoding) throws NoSuchAlgorithmException {
        return CryptoIntegration.getProvider().getPemUtils().generateThumbprint(certChain, encoding);
    }
}

