/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NamingUtil.class);

    public static Context bind(Context ctx, String nameStr, Object obj) throws NamingException {
        Name name = ctx.getNameParser("").parse(nameStr);
        if (name.size() == 0) {
            return null;
        }
        Context subCtx = ctx;
        for (int i = 0; i < name.size() - 1; ++i) {
            try {
                subCtx = (Context)subCtx.lookup(name.get(i));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Subcontext {} already exists", (Object)name.get(i));
                continue;
            }
            catch (NameNotFoundException e) {
                subCtx = subCtx.createSubcontext(name.get(i));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Subcontext {} created", (Object)name.get(i));
            }
        }
        subCtx.rebind(name.get(name.size() - 1), obj);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bound object to {}", (Object)name.get(name.size() - 1));
        }
        return subCtx;
    }

    public static void unbind(Context ctx) throws NamingException {
        NamingEnumeration<Binding> ne = ctx.listBindings(ctx.getNameInNamespace());
        while (ne.hasMoreElements()) {
            Binding b = (Binding)ne.nextElement();
            if (b.getObject() instanceof Context) {
                NamingUtil.unbind((Context)b.getObject());
                continue;
            }
            ctx.unbind(b.getName());
        }
    }

    public static Map flattenBindings(Context ctx, String name) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Context c = (Context)ctx.lookup(name);
        NameParser parser2 = c.getNameParser("");
        NamingEnumeration<Binding> enm = ctx.listBindings(name);
        while (enm.hasMore()) {
            Binding b = enm.next();
            if (b.getObject() instanceof Context) {
                map.putAll(NamingUtil.flattenBindings(c, b.getName()));
                continue;
            }
            Name compoundName = parser2.parse(c.getNameInNamespace());
            compoundName.add(b.getName());
            map.put(compoundName.toString(), b.getObject());
        }
        return map;
    }
}

