/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRenderingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderingUtils.kt\norg/jetbrains/kotlin/renderer/RenderingUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,75:1\n1083#2,2:76\n*S KotlinDebug\n*F\n+ 1 RenderingUtils.kt\norg/jetbrains/kotlin/renderer/RenderingUtilsKt\n*L\n29#1:76,2\n*E\n"})
public final class RenderingUtilsKt {
    @NotNull
    public static final String render(@NotNull Name $this$render) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        if (RenderingUtilsKt.shouldBeEscaped($this$render)) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '`';
            String string2 = $this$render.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString()");
            String string3 = string2;
            string = stringBuilder.append(c + string3).append('`').toString();
        } else {
            String string4 = $this$render.asString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $this$shouldBeEscaped) {
        String string = $this$shouldBeEscaped.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString()");
        String string2 = string;
        if (KeywordStringsGenerated.KEYWORDS.contains(string2)) return true;
        CharSequence $this$any$iv = string2;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char it = element$iv = $this$any$iv.charAt(n);
            boolean bl = false;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @NotNull
    public static final String render(@NotNull FqNameUnsafe $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        List<Name> list = $this$render.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        StringBuilder $this$renderFqName_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Name element : pathSegments) {
            if ($this$renderFqName_u24lambda_u241.length() > 0) {
                $this$renderFqName_u24lambda_u241.append(".");
            }
            $this$renderFqName_u24lambda_u241.append(RenderingUtilsKt.render(element));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Nullable
    public static final String replacePrefixesInTypeRepresentations(@NotNull String lowerRendered, @NotNull String lowerPrefix, @NotNull String upperRendered, @NotNull String upperPrefix, @NotNull String foldedPrefix) {
        Intrinsics.checkNotNullParameter((Object)lowerRendered, (String)"lowerRendered");
        Intrinsics.checkNotNullParameter((Object)lowerPrefix, (String)"lowerPrefix");
        Intrinsics.checkNotNullParameter((Object)upperRendered, (String)"upperRendered");
        Intrinsics.checkNotNullParameter((Object)upperPrefix, (String)"upperPrefix");
        Intrinsics.checkNotNullParameter((Object)foldedPrefix, (String)"foldedPrefix");
        if (StringsKt.startsWith$default((String)lowerRendered, (String)lowerPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)upperRendered, (String)upperPrefix, (boolean)false, (int)2, null)) {
            String string = lowerRendered.substring(lowerPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String lowerWithoutPrefix = string;
            String string2 = upperRendered.substring(upperPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String upperWithoutPrefix = string2;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual((Object)lowerWithoutPrefix, (Object)upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + '!';
            }
        }
        return null;
    }

    public static final boolean typeStringsDifferOnlyInNullability(@NotNull String lower, @NotNull String upper) {
        Intrinsics.checkNotNullParameter((Object)lower, (String)"lower");
        Intrinsics.checkNotNullParameter((Object)upper, (String)"upper");
        return Intrinsics.areEqual((Object)lower, (Object)StringsKt.replace$default((String)upper, (String)"?", (String)"", (boolean)false, (int)4, null)) || StringsKt.endsWith$default((String)upper, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(lower + '?'), (Object)upper) || Intrinsics.areEqual((Object)('(' + lower + ")?"), (Object)upper);
    }
}

