/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class FrameMotionListener
extends MouseAdapter {
    private final JInternalFrame f;
    private Point loc = null;

    FrameMotionListener(JInternalFrame f) {
        this.f = f;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        int moveX = this.loc.x - p.x;
        int moveY = this.loc.y - p.y;
        this.f.getDesktopPane().getDesktopManager().dragFrame(this.f, this.f.getX() - moveX, this.f.getY() - moveY);
        this.loc = p;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
            return;
        }
        this.loc = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        this.f.getDesktopPane().getDesktopManager().beginDraggingFrame(this.f);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
            return;
        }
        this.f.getDesktopPane().getDesktopManager().endDraggingFrame(this.f);
    }
}

