/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.control.MapTransform;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public final class MapEditorController
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(MapEditorController.class.getName());
    private static final int MINI_MAP_THUMBNAIL_FINAL_HEIGHT = 64;
    private MapTransform currentMapTransform = null;

    public MapEditorController(FreeColClient freeColClient) {
        super(freeColClient);
    }

    private BufferedImage createMiniMapThumbNail() {
        MiniMap miniMap = new MiniMap(this.getFreeColClient());
        miniMap.setTileSize(24);
        Map map = this.getMap();
        int width = map.getWidth() * 24 + 12;
        int height = map.getHeight() * 24 / 4;
        miniMap.setSize(width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g1 = image.createGraphics();
        miniMap.paintMap(g1);
        g1.dispose();
        int scaledWidth = Math.min((int)((float)(64 * width) / (float)height), 128);
        BufferedImage scaledImage = new BufferedImage(scaledWidth, 64, 2);
        Graphics2D g2 = scaledImage.createGraphics();
        g2.drawImage(image, 0, 0, scaledWidth, 64, null);
        g2.dispose();
        return scaledImage;
    }

    private void requireNativeNations(Game game) {
        Specification spec = game.getSpecification();
        for (Nation n : spec.getIndianNations()) {
            Player p = game.getPlayerByNation(n);
            if (p != null) continue;
            p = new ServerPlayer(game, false, n);
            game.addPlayer(p);
        }
    }

    public void startMapEditor() {
        FreeColClient fcc = this.getFreeColClient();
        GUI gui = this.getGUI();
        try {
            Specification specification = this.getDefaultSpecification();
            fcc.setMapEditor(true);
            FreeColServer freeColServer = new FreeColServer(false, false, specification, null, 0, null);
            fcc.setFreeColServer(freeColServer);
            ServerGame serverGame = freeColServer.getGame();
            this.requireNativeNations(serverGame);
            fcc.setGame(serverGame);
            fcc.setMyPlayer(null);
            gui.playSound(null);
            gui.closeMainPanel();
            gui.closeMenus();
            gui.startMapEditorGUI();
        }
        catch (IOException e) {
            gui.showErrorPanel(StringTemplate.template("server.initialize"));
            return;
        }
    }

    public Specification getDefaultSpecification() {
        return FreeCol.loadSpecification(FreeCol.getRulesFile(), FreeCol.getAdvantages(), FreeCol.getDifficulty());
    }

    public void setMapTransform(MapTransform mt) {
        this.currentMapTransform = mt;
        this.getGUI().changeView(mt);
    }

    public MapTransform getMapTransform() {
        return this.currentMapTransform;
    }

    public void transform(Tile t) {
        if (this.currentMapTransform != null) {
            this.currentMapTransform.transform(t);
        }
    }

    public void newMap() {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame serverGame = freeColServer.getGame();
        this.getGUI().removeInGameComponents();
        this.getGUI().showMapGeneratorOptionsDialog(true, mgo -> {
            if (mgo != null) {
                serverGame.setMapGeneratorOptions((OptionGroup)mgo);
                freeColServer.generateMap(false);
                this.requireNativeNations(serverGame);
                this.getGUI().setFocus(serverGame.getMap().getTile(1, 1));
                this.getGUI().updateMenuBar();
                this.getGUI().startMapEditorGUI();
                this.getGUI().refresh();
            }
        });
    }

    public void saveMapEditorGame() {
        File file;
        File dir = FreeColDirectories.getUserMapsDirectory();
        if (dir == null) {
            dir = FreeColDirectories.getSaveDirectory();
        }
        if ((file = this.getGUI().showSaveDialog(dir, "my_map.fsm")) != null) {
            this.saveMapEditorGame(file);
        }
    }

    public void saveMapEditorGame(final File file) {
        final GUI gui = this.getGUI();
        Game game = this.getGame();
        Map map = game.getMap();
        map.resetContiguity();
        map.resetHighSeasCount();
        map.resetLayers();
        gui.showStatusPanel(Messages.message("status.savingGame"));
        new Thread("FreeColClient:-Saving-Map"){

            @Override
            public void run() {
                try {
                    BufferedImage thumb = MapEditorController.this.createMiniMapThumbNail();
                    MapEditorController.this.getFreeColServer().saveMapEditorGame(file, thumb);
                    SwingUtilities.invokeLater(() -> gui.closeStatusPanel());
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(() -> {
                        gui.closeStatusPanel();
                        gui.showErrorPanel(FreeCol.badFile("error.couldNotSave", file), e == null ? null : e.getMessage());
                    });
                }
            }
        }.start();
    }

    public void loadGame() {
        File file = this.getGUI().showLoadSaveFileDialog(FreeColDirectories.getUserMapsDirectory(), "fsm");
        if (file != null) {
            this.loadGame(file);
        }
    }

    private void loadGame(File file) {
        final FreeColClient fcc = this.getFreeColClient();
        final GUI gui = this.getGUI();
        fcc.setMapEditor(true);
        gui.showStatusPanel(Messages.message("status.loadingGame"));
        final File theFile = file;
        new Thread("FreeColClient:Loading-Map"){

            @Override
            public void run() {
                FreeColServer freeColServer = MapEditorController.this.getFreeColServer();
                try {
                    Specification spec = MapEditorController.this.getDefaultSpecification();
                    ServerGame game = FreeColServer.readGame(new FreeColSavegameFile(theFile), spec, freeColServer);
                    fcc.setGame(game);
                    MapEditorController.this.requireNativeNations(game);
                    SwingUtilities.invokeLater(() -> {
                        gui.closeStatusPanel();
                        gui.setFocus(game.getMap().getTile(1, 1));
                        gui.updateMenuBar();
                        gui.refresh();
                    });
                }
                catch (FileNotFoundException fnfe) {
                    gui.showErrorPanel(fnfe, FreeCol.badFile("error.couldNotFind", theFile));
                }
                catch (IOException | FreeColException ioe) {
                    gui.showErrorPanel(ioe, StringTemplate.key("server.initialize"));
                }
                catch (XMLStreamException xse) {
                    gui.showErrorPanel(xse, FreeCol.badFile("error.couldNotLoad", theFile));
                }
            }
        }.start();
    }
}

